/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pcaconnectorad.model.TemplateDefinition;
import software.amazon.awssdk.services.pcaconnectorad.model.TemplateRevision;
import software.amazon.awssdk.services.pcaconnectorad.model.TemplateStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TemplateSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TemplateSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(TemplateSummary.getter(TemplateSummary::arn)).setter(TemplateSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CONNECTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectorArn").getter(TemplateSummary.getter(TemplateSummary::connectorArn)).setter(TemplateSummary.setter(Builder::connectorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorArn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(TemplateSummary.getter(TemplateSummary::createdAt)).setter(TemplateSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<TemplateDefinition> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Definition").getter(TemplateSummary.getter(TemplateSummary::definition)).setter(TemplateSummary.setter(Builder::definition)).constructor(TemplateDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(TemplateSummary.getter(TemplateSummary::name)).setter(TemplateSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> OBJECT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectIdentifier").getter(TemplateSummary.getter(TemplateSummary::objectIdentifier)).setter(TemplateSummary.setter(Builder::objectIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectIdentifier").build()}).build();
    private static final SdkField<Integer> POLICY_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PolicySchema").getter(TemplateSummary.getter(TemplateSummary::policySchema)).setter(TemplateSummary.setter(Builder::policySchema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicySchema").build()}).build();
    private static final SdkField<TemplateRevision> REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Revision").getter(TemplateSummary.getter(TemplateSummary::revision)).setter(TemplateSummary.setter(Builder::revision)).constructor(TemplateRevision::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Revision").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(TemplateSummary.getter(TemplateSummary::statusAsString)).setter(TemplateSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(TemplateSummary.getter(TemplateSummary::updatedAt)).setter(TemplateSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CONNECTOR_ARN_FIELD, CREATED_AT_FIELD, DEFINITION_FIELD, NAME_FIELD, OBJECT_IDENTIFIER_FIELD, POLICY_SCHEMA_FIELD, REVISION_FIELD, STATUS_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Arn", ARN_FIELD);
            this.put("ConnectorArn", CONNECTOR_ARN_FIELD);
            this.put("CreatedAt", CREATED_AT_FIELD);
            this.put("Definition", DEFINITION_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("ObjectIdentifier", OBJECT_IDENTIFIER_FIELD);
            this.put("PolicySchema", POLICY_SCHEMA_FIELD);
            this.put("Revision", REVISION_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("UpdatedAt", UPDATED_AT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String connectorArn;
    private final Instant createdAt;
    private final TemplateDefinition definition;
    private final String name;
    private final String objectIdentifier;
    private final Integer policySchema;
    private final TemplateRevision revision;
    private final String status;
    private final Instant updatedAt;

    private TemplateSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.connectorArn = builder.connectorArn;
        this.createdAt = builder.createdAt;
        this.definition = builder.definition;
        this.name = builder.name;
        this.objectIdentifier = builder.objectIdentifier;
        this.policySchema = builder.policySchema;
        this.revision = builder.revision;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
    }

    public final String arn() {
        return this.arn;
    }

    public final String connectorArn() {
        return this.connectorArn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final TemplateDefinition definition() {
        return this.definition;
    }

    public final String name() {
        return this.name;
    }

    public final String objectIdentifier() {
        return this.objectIdentifier;
    }

    public final Integer policySchema() {
        return this.policySchema;
    }

    public final TemplateRevision revision() {
        return this.revision;
    }

    public final TemplateStatus status() {
        return TemplateStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.policySchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateSummary)) {
            return false;
        }
        TemplateSummary other = (TemplateSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.connectorArn(), other.connectorArn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.definition(), other.definition()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.objectIdentifier(), other.objectIdentifier()) && Objects.equals(this.policySchema(), other.policySchema()) && Objects.equals(this.revision(), other.revision()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"TemplateSummary").add("Arn", (Object)this.arn()).add("ConnectorArn", (Object)this.connectorArn()).add("CreatedAt", (Object)this.createdAt()).add("Definition", (Object)this.definition()).add("Name", (Object)this.name()).add("ObjectIdentifier", (Object)this.objectIdentifier()).add("PolicySchema", (Object)this.policySchema()).add("Revision", (Object)this.revision()).add("Status", (Object)this.statusAsString()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ConnectorArn": {
                return Optional.ofNullable(clazz.cast(this.connectorArn()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "Definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ObjectIdentifier": {
                return Optional.ofNullable(clazz.cast(this.objectIdentifier()));
            }
            case "PolicySchema": {
                return Optional.ofNullable(clazz.cast(this.policySchema()));
            }
            case "Revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TemplateSummary, T> g) {
        return obj -> g.apply((TemplateSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String connectorArn;
        private Instant createdAt;
        private TemplateDefinition definition;
        private String name;
        private String objectIdentifier;
        private Integer policySchema;
        private TemplateRevision revision;
        private String status;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateSummary model) {
            this.arn(model.arn);
            this.connectorArn(model.connectorArn);
            this.createdAt(model.createdAt);
            this.definition(model.definition);
            this.name(model.name);
            this.objectIdentifier(model.objectIdentifier);
            this.policySchema(model.policySchema);
            this.revision(model.revision);
            this.status(model.status);
            this.updatedAt(model.updatedAt);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getConnectorArn() {
            return this.connectorArn;
        }

        public final void setConnectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
        }

        @Override
        public final Builder connectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final TemplateDefinition.Builder getDefinition() {
            return this.definition != null ? this.definition.toBuilder() : null;
        }

        public final void setDefinition(TemplateDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(TemplateDefinition definition) {
            this.definition = definition;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getObjectIdentifier() {
            return this.objectIdentifier;
        }

        public final void setObjectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
        }

        @Override
        public final Builder objectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
            return this;
        }

        public final Integer getPolicySchema() {
            return this.policySchema;
        }

        public final void setPolicySchema(Integer policySchema) {
            this.policySchema = policySchema;
        }

        @Override
        public final Builder policySchema(Integer policySchema) {
            this.policySchema = policySchema;
            return this;
        }

        public final TemplateRevision.Builder getRevision() {
            return this.revision != null ? this.revision.toBuilder() : null;
        }

        public final void setRevision(TemplateRevision.BuilderImpl revision) {
            this.revision = revision != null ? revision.build() : null;
        }

        @Override
        public final Builder revision(TemplateRevision revision) {
            this.revision = revision;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TemplateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public TemplateSummary build() {
            return new TemplateSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TemplateSummary> {
        public Builder arn(String var1);

        public Builder connectorArn(String var1);

        public Builder createdAt(Instant var1);

        public Builder definition(TemplateDefinition var1);

        default public Builder definition(Consumer<TemplateDefinition.Builder> definition) {
            return this.definition((TemplateDefinition)((TemplateDefinition.Builder)TemplateDefinition.builder().applyMutation(definition)).build());
        }

        public Builder name(String var1);

        public Builder objectIdentifier(String var1);

        public Builder policySchema(Integer var1);

        public Builder revision(TemplateRevision var1);

        default public Builder revision(Consumer<TemplateRevision.Builder> revision) {
            return this.revision((TemplateRevision)((TemplateRevision.Builder)TemplateRevision.builder().applyMutation(revision)).build());
        }

        public Builder status(String var1);

        public Builder status(TemplateStatus var1);

        public Builder updatedAt(Instant var1);
    }
}

