/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pcaconnectorad.PcaConnectorAdAsyncClient;
import software.amazon.awssdk.services.pcaconnectorad.internal.UserAgentUtils;
import software.amazon.awssdk.services.pcaconnectorad.model.AccessControlEntrySummary;
import software.amazon.awssdk.services.pcaconnectorad.model.ListTemplateGroupAccessControlEntriesRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.ListTemplateGroupAccessControlEntriesResponse;

public class ListTemplateGroupAccessControlEntriesPublisher
implements SdkPublisher<ListTemplateGroupAccessControlEntriesResponse> {
    private final PcaConnectorAdAsyncClient client;
    private final ListTemplateGroupAccessControlEntriesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTemplateGroupAccessControlEntriesPublisher(PcaConnectorAdAsyncClient client, ListTemplateGroupAccessControlEntriesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTemplateGroupAccessControlEntriesPublisher(PcaConnectorAdAsyncClient client, ListTemplateGroupAccessControlEntriesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTemplateGroupAccessControlEntriesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTemplateGroupAccessControlEntriesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AccessControlEntrySummary> accessControlEntries() {
        Function<ListTemplateGroupAccessControlEntriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.accessControlEntries() != null) {
                return response.accessControlEntries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTemplateGroupAccessControlEntriesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTemplateGroupAccessControlEntriesResponseFetcher
    implements AsyncPageFetcher<ListTemplateGroupAccessControlEntriesResponse> {
        private ListTemplateGroupAccessControlEntriesResponseFetcher() {
        }

        public boolean hasNextPage(ListTemplateGroupAccessControlEntriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTemplateGroupAccessControlEntriesResponse> nextPage(ListTemplateGroupAccessControlEntriesResponse previousPage) {
            if (previousPage == null) {
                return ListTemplateGroupAccessControlEntriesPublisher.this.client.listTemplateGroupAccessControlEntries(ListTemplateGroupAccessControlEntriesPublisher.this.firstRequest);
            }
            return ListTemplateGroupAccessControlEntriesPublisher.this.client.listTemplateGroupAccessControlEntries((ListTemplateGroupAccessControlEntriesRequest)((Object)ListTemplateGroupAccessControlEntriesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

