/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pcaconnectorad.model.CertificateValidity;
import software.amazon.awssdk.services.pcaconnectorad.model.EnrollmentFlagsV2;
import software.amazon.awssdk.services.pcaconnectorad.model.ExtensionsV2;
import software.amazon.awssdk.services.pcaconnectorad.model.GeneralFlagsV2;
import software.amazon.awssdk.services.pcaconnectorad.model.PrivateKeyAttributesV2;
import software.amazon.awssdk.services.pcaconnectorad.model.PrivateKeyFlagsV2;
import software.amazon.awssdk.services.pcaconnectorad.model.SubjectNameFlagsV2;
import software.amazon.awssdk.services.pcaconnectorad.model.TemplateNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TemplateV2
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TemplateV2> {
    private static final SdkField<CertificateValidity> CERTIFICATE_VALIDITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CertificateValidity").getter(TemplateV2.getter(TemplateV2::certificateValidity)).setter(TemplateV2.setter(Builder::certificateValidity)).constructor(CertificateValidity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateValidity").build()}).build();
    private static final SdkField<EnrollmentFlagsV2> ENROLLMENT_FLAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EnrollmentFlags").getter(TemplateV2.getter(TemplateV2::enrollmentFlags)).setter(TemplateV2.setter(Builder::enrollmentFlags)).constructor(EnrollmentFlagsV2::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnrollmentFlags").build()}).build();
    private static final SdkField<ExtensionsV2> EXTENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Extensions").getter(TemplateV2.getter(TemplateV2::extensions)).setter(TemplateV2.setter(Builder::extensions)).constructor(ExtensionsV2::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Extensions").build()}).build();
    private static final SdkField<GeneralFlagsV2> GENERAL_FLAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GeneralFlags").getter(TemplateV2.getter(TemplateV2::generalFlags)).setter(TemplateV2.setter(Builder::generalFlags)).constructor(GeneralFlagsV2::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneralFlags").build()}).build();
    private static final SdkField<PrivateKeyAttributesV2> PRIVATE_KEY_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PrivateKeyAttributes").getter(TemplateV2.getter(TemplateV2::privateKeyAttributes)).setter(TemplateV2.setter(Builder::privateKeyAttributes)).constructor(PrivateKeyAttributesV2::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateKeyAttributes").build()}).build();
    private static final SdkField<PrivateKeyFlagsV2> PRIVATE_KEY_FLAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PrivateKeyFlags").getter(TemplateV2.getter(TemplateV2::privateKeyFlags)).setter(TemplateV2.setter(Builder::privateKeyFlags)).constructor(PrivateKeyFlagsV2::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateKeyFlags").build()}).build();
    private static final SdkField<SubjectNameFlagsV2> SUBJECT_NAME_FLAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SubjectNameFlags").getter(TemplateV2.getter(TemplateV2::subjectNameFlags)).setter(TemplateV2.setter(Builder::subjectNameFlags)).constructor(SubjectNameFlagsV2::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubjectNameFlags").build()}).build();
    private static final SdkField<List<String>> SUPERSEDED_TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupersededTemplates").getter(TemplateV2.getter(TemplateV2::supersededTemplates)).setter(TemplateV2.setter(Builder::supersededTemplates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupersededTemplates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_VALIDITY_FIELD, ENROLLMENT_FLAGS_FIELD, EXTENSIONS_FIELD, GENERAL_FLAGS_FIELD, PRIVATE_KEY_ATTRIBUTES_FIELD, PRIVATE_KEY_FLAGS_FIELD, SUBJECT_NAME_FLAGS_FIELD, SUPERSEDED_TEMPLATES_FIELD));
    private static final long serialVersionUID = 1L;
    private final CertificateValidity certificateValidity;
    private final EnrollmentFlagsV2 enrollmentFlags;
    private final ExtensionsV2 extensions;
    private final GeneralFlagsV2 generalFlags;
    private final PrivateKeyAttributesV2 privateKeyAttributes;
    private final PrivateKeyFlagsV2 privateKeyFlags;
    private final SubjectNameFlagsV2 subjectNameFlags;
    private final List<String> supersededTemplates;

    private TemplateV2(BuilderImpl builder) {
        this.certificateValidity = builder.certificateValidity;
        this.enrollmentFlags = builder.enrollmentFlags;
        this.extensions = builder.extensions;
        this.generalFlags = builder.generalFlags;
        this.privateKeyAttributes = builder.privateKeyAttributes;
        this.privateKeyFlags = builder.privateKeyFlags;
        this.subjectNameFlags = builder.subjectNameFlags;
        this.supersededTemplates = builder.supersededTemplates;
    }

    public final CertificateValidity certificateValidity() {
        return this.certificateValidity;
    }

    public final EnrollmentFlagsV2 enrollmentFlags() {
        return this.enrollmentFlags;
    }

    public final ExtensionsV2 extensions() {
        return this.extensions;
    }

    public final GeneralFlagsV2 generalFlags() {
        return this.generalFlags;
    }

    public final PrivateKeyAttributesV2 privateKeyAttributes() {
        return this.privateKeyAttributes;
    }

    public final PrivateKeyFlagsV2 privateKeyFlags() {
        return this.privateKeyFlags;
    }

    public final SubjectNameFlagsV2 subjectNameFlags() {
        return this.subjectNameFlags;
    }

    public final boolean hasSupersededTemplates() {
        return this.supersededTemplates != null && !(this.supersededTemplates instanceof SdkAutoConstructList);
    }

    public final List<String> supersededTemplates() {
        return this.supersededTemplates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateValidity());
        hashCode = 31 * hashCode + Objects.hashCode(this.enrollmentFlags());
        hashCode = 31 * hashCode + Objects.hashCode(this.extensions());
        hashCode = 31 * hashCode + Objects.hashCode(this.generalFlags());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateKeyAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateKeyFlags());
        hashCode = 31 * hashCode + Objects.hashCode(this.subjectNameFlags());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupersededTemplates() ? this.supersededTemplates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateV2)) {
            return false;
        }
        TemplateV2 other = (TemplateV2)obj;
        return Objects.equals(this.certificateValidity(), other.certificateValidity()) && Objects.equals(this.enrollmentFlags(), other.enrollmentFlags()) && Objects.equals(this.extensions(), other.extensions()) && Objects.equals(this.generalFlags(), other.generalFlags()) && Objects.equals(this.privateKeyAttributes(), other.privateKeyAttributes()) && Objects.equals(this.privateKeyFlags(), other.privateKeyFlags()) && Objects.equals(this.subjectNameFlags(), other.subjectNameFlags()) && this.hasSupersededTemplates() == other.hasSupersededTemplates() && Objects.equals(this.supersededTemplates(), other.supersededTemplates());
    }

    public final String toString() {
        return ToString.builder((String)"TemplateV2").add("CertificateValidity", (Object)this.certificateValidity()).add("EnrollmentFlags", (Object)this.enrollmentFlags()).add("Extensions", (Object)this.extensions()).add("GeneralFlags", (Object)this.generalFlags()).add("PrivateKeyAttributes", (Object)this.privateKeyAttributes()).add("PrivateKeyFlags", (Object)this.privateKeyFlags()).add("SubjectNameFlags", (Object)this.subjectNameFlags()).add("SupersededTemplates", this.hasSupersededTemplates() ? this.supersededTemplates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateValidity": {
                return Optional.ofNullable(clazz.cast(this.certificateValidity()));
            }
            case "EnrollmentFlags": {
                return Optional.ofNullable(clazz.cast(this.enrollmentFlags()));
            }
            case "Extensions": {
                return Optional.ofNullable(clazz.cast(this.extensions()));
            }
            case "GeneralFlags": {
                return Optional.ofNullable(clazz.cast(this.generalFlags()));
            }
            case "PrivateKeyAttributes": {
                return Optional.ofNullable(clazz.cast(this.privateKeyAttributes()));
            }
            case "PrivateKeyFlags": {
                return Optional.ofNullable(clazz.cast(this.privateKeyFlags()));
            }
            case "SubjectNameFlags": {
                return Optional.ofNullable(clazz.cast(this.subjectNameFlags()));
            }
            case "SupersededTemplates": {
                return Optional.ofNullable(clazz.cast(this.supersededTemplates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TemplateV2, T> g) {
        return obj -> g.apply((TemplateV2)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CertificateValidity certificateValidity;
        private EnrollmentFlagsV2 enrollmentFlags;
        private ExtensionsV2 extensions;
        private GeneralFlagsV2 generalFlags;
        private PrivateKeyAttributesV2 privateKeyAttributes;
        private PrivateKeyFlagsV2 privateKeyFlags;
        private SubjectNameFlagsV2 subjectNameFlags;
        private List<String> supersededTemplates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateV2 model) {
            this.certificateValidity(model.certificateValidity);
            this.enrollmentFlags(model.enrollmentFlags);
            this.extensions(model.extensions);
            this.generalFlags(model.generalFlags);
            this.privateKeyAttributes(model.privateKeyAttributes);
            this.privateKeyFlags(model.privateKeyFlags);
            this.subjectNameFlags(model.subjectNameFlags);
            this.supersededTemplates(model.supersededTemplates);
        }

        public final CertificateValidity.Builder getCertificateValidity() {
            return this.certificateValidity != null ? this.certificateValidity.toBuilder() : null;
        }

        public final void setCertificateValidity(CertificateValidity.BuilderImpl certificateValidity) {
            this.certificateValidity = certificateValidity != null ? certificateValidity.build() : null;
        }

        @Override
        public final Builder certificateValidity(CertificateValidity certificateValidity) {
            this.certificateValidity = certificateValidity;
            return this;
        }

        public final EnrollmentFlagsV2.Builder getEnrollmentFlags() {
            return this.enrollmentFlags != null ? this.enrollmentFlags.toBuilder() : null;
        }

        public final void setEnrollmentFlags(EnrollmentFlagsV2.BuilderImpl enrollmentFlags) {
            this.enrollmentFlags = enrollmentFlags != null ? enrollmentFlags.build() : null;
        }

        @Override
        public final Builder enrollmentFlags(EnrollmentFlagsV2 enrollmentFlags) {
            this.enrollmentFlags = enrollmentFlags;
            return this;
        }

        public final ExtensionsV2.Builder getExtensions() {
            return this.extensions != null ? this.extensions.toBuilder() : null;
        }

        public final void setExtensions(ExtensionsV2.BuilderImpl extensions) {
            this.extensions = extensions != null ? extensions.build() : null;
        }

        @Override
        public final Builder extensions(ExtensionsV2 extensions) {
            this.extensions = extensions;
            return this;
        }

        public final GeneralFlagsV2.Builder getGeneralFlags() {
            return this.generalFlags != null ? this.generalFlags.toBuilder() : null;
        }

        public final void setGeneralFlags(GeneralFlagsV2.BuilderImpl generalFlags) {
            this.generalFlags = generalFlags != null ? generalFlags.build() : null;
        }

        @Override
        public final Builder generalFlags(GeneralFlagsV2 generalFlags) {
            this.generalFlags = generalFlags;
            return this;
        }

        public final PrivateKeyAttributesV2.Builder getPrivateKeyAttributes() {
            return this.privateKeyAttributes != null ? this.privateKeyAttributes.toBuilder() : null;
        }

        public final void setPrivateKeyAttributes(PrivateKeyAttributesV2.BuilderImpl privateKeyAttributes) {
            this.privateKeyAttributes = privateKeyAttributes != null ? privateKeyAttributes.build() : null;
        }

        @Override
        public final Builder privateKeyAttributes(PrivateKeyAttributesV2 privateKeyAttributes) {
            this.privateKeyAttributes = privateKeyAttributes;
            return this;
        }

        public final PrivateKeyFlagsV2.Builder getPrivateKeyFlags() {
            return this.privateKeyFlags != null ? this.privateKeyFlags.toBuilder() : null;
        }

        public final void setPrivateKeyFlags(PrivateKeyFlagsV2.BuilderImpl privateKeyFlags) {
            this.privateKeyFlags = privateKeyFlags != null ? privateKeyFlags.build() : null;
        }

        @Override
        public final Builder privateKeyFlags(PrivateKeyFlagsV2 privateKeyFlags) {
            this.privateKeyFlags = privateKeyFlags;
            return this;
        }

        public final SubjectNameFlagsV2.Builder getSubjectNameFlags() {
            return this.subjectNameFlags != null ? this.subjectNameFlags.toBuilder() : null;
        }

        public final void setSubjectNameFlags(SubjectNameFlagsV2.BuilderImpl subjectNameFlags) {
            this.subjectNameFlags = subjectNameFlags != null ? subjectNameFlags.build() : null;
        }

        @Override
        public final Builder subjectNameFlags(SubjectNameFlagsV2 subjectNameFlags) {
            this.subjectNameFlags = subjectNameFlags;
            return this;
        }

        public final Collection<String> getSupersededTemplates() {
            if (this.supersededTemplates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supersededTemplates;
        }

        public final void setSupersededTemplates(Collection<String> supersededTemplates) {
            this.supersededTemplates = TemplateNameListCopier.copy(supersededTemplates);
        }

        @Override
        public final Builder supersededTemplates(Collection<String> supersededTemplates) {
            this.supersededTemplates = TemplateNameListCopier.copy(supersededTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supersededTemplates(String ... supersededTemplates) {
            this.supersededTemplates(Arrays.asList(supersededTemplates));
            return this;
        }

        public TemplateV2 build() {
            return new TemplateV2(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TemplateV2> {
        public Builder certificateValidity(CertificateValidity var1);

        default public Builder certificateValidity(Consumer<CertificateValidity.Builder> certificateValidity) {
            return this.certificateValidity((CertificateValidity)((CertificateValidity.Builder)CertificateValidity.builder().applyMutation(certificateValidity)).build());
        }

        public Builder enrollmentFlags(EnrollmentFlagsV2 var1);

        default public Builder enrollmentFlags(Consumer<EnrollmentFlagsV2.Builder> enrollmentFlags) {
            return this.enrollmentFlags((EnrollmentFlagsV2)((EnrollmentFlagsV2.Builder)EnrollmentFlagsV2.builder().applyMutation(enrollmentFlags)).build());
        }

        public Builder extensions(ExtensionsV2 var1);

        default public Builder extensions(Consumer<ExtensionsV2.Builder> extensions) {
            return this.extensions((ExtensionsV2)((ExtensionsV2.Builder)ExtensionsV2.builder().applyMutation(extensions)).build());
        }

        public Builder generalFlags(GeneralFlagsV2 var1);

        default public Builder generalFlags(Consumer<GeneralFlagsV2.Builder> generalFlags) {
            return this.generalFlags((GeneralFlagsV2)((GeneralFlagsV2.Builder)GeneralFlagsV2.builder().applyMutation(generalFlags)).build());
        }

        public Builder privateKeyAttributes(PrivateKeyAttributesV2 var1);

        default public Builder privateKeyAttributes(Consumer<PrivateKeyAttributesV2.Builder> privateKeyAttributes) {
            return this.privateKeyAttributes((PrivateKeyAttributesV2)((PrivateKeyAttributesV2.Builder)PrivateKeyAttributesV2.builder().applyMutation(privateKeyAttributes)).build());
        }

        public Builder privateKeyFlags(PrivateKeyFlagsV2 var1);

        default public Builder privateKeyFlags(Consumer<PrivateKeyFlagsV2.Builder> privateKeyFlags) {
            return this.privateKeyFlags((PrivateKeyFlagsV2)((PrivateKeyFlagsV2.Builder)PrivateKeyFlagsV2.builder().applyMutation(privateKeyFlags)).build());
        }

        public Builder subjectNameFlags(SubjectNameFlagsV2 var1);

        default public Builder subjectNameFlags(Consumer<SubjectNameFlagsV2.Builder> subjectNameFlags) {
            return this.subjectNameFlags((SubjectNameFlagsV2)((SubjectNameFlagsV2.Builder)SubjectNameFlagsV2.builder().applyMutation(subjectNameFlags)).build());
        }

        public Builder supersededTemplates(Collection<String> var1);

        public Builder supersededTemplates(String ... var1);
    }
}

