/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pcaconnectorad.model.PcaConnectorAdRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListServicePrincipalNamesRequest
extends PcaConnectorAdRequest
implements ToCopyableBuilder<Builder, ListServicePrincipalNamesRequest> {
    private static final SdkField<String> DIRECTORY_REGISTRATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryRegistrationArn").getter(ListServicePrincipalNamesRequest.getter(ListServicePrincipalNamesRequest::directoryRegistrationArn)).setter(ListServicePrincipalNamesRequest.setter(Builder::directoryRegistrationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DirectoryRegistrationArn").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListServicePrincipalNamesRequest.getter(ListServicePrincipalNamesRequest::maxResults)).setter(ListServicePrincipalNamesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListServicePrincipalNamesRequest.getter(ListServicePrincipalNamesRequest::nextToken)).setter(ListServicePrincipalNamesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_REGISTRATION_ARN_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String directoryRegistrationArn;
    private final Integer maxResults;
    private final String nextToken;

    private ListServicePrincipalNamesRequest(BuilderImpl builder) {
        super(builder);
        this.directoryRegistrationArn = builder.directoryRegistrationArn;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String directoryRegistrationArn() {
        return this.directoryRegistrationArn;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryRegistrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServicePrincipalNamesRequest)) {
            return false;
        }
        ListServicePrincipalNamesRequest other = (ListServicePrincipalNamesRequest)((Object)obj);
        return Objects.equals(this.directoryRegistrationArn(), other.directoryRegistrationArn()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListServicePrincipalNamesRequest").add("DirectoryRegistrationArn", (Object)this.directoryRegistrationArn()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryRegistrationArn": {
                return Optional.ofNullable(clazz.cast(this.directoryRegistrationArn()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListServicePrincipalNamesRequest, T> g) {
        return obj -> g.apply((ListServicePrincipalNamesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PcaConnectorAdRequest.BuilderImpl
    implements Builder {
        private String directoryRegistrationArn;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServicePrincipalNamesRequest model) {
            super(model);
            this.directoryRegistrationArn(model.directoryRegistrationArn);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getDirectoryRegistrationArn() {
            return this.directoryRegistrationArn;
        }

        public final void setDirectoryRegistrationArn(String directoryRegistrationArn) {
            this.directoryRegistrationArn = directoryRegistrationArn;
        }

        @Override
        public final Builder directoryRegistrationArn(String directoryRegistrationArn) {
            this.directoryRegistrationArn = directoryRegistrationArn;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListServicePrincipalNamesRequest build() {
            return new ListServicePrincipalNamesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PcaConnectorAdRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListServicePrincipalNamesRequest> {
        public Builder directoryRegistrationArn(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

