/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WrappedKeyMaterialFormat {
    KEY_CRYPTOGRAM("KEY_CRYPTOGRAM"),
    TR31_KEY_BLOCK("TR31_KEY_BLOCK"),
    TR34_KEY_BLOCK("TR34_KEY_BLOCK"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WrappedKeyMaterialFormat> VALUE_MAP;
    private final String value;

    private WrappedKeyMaterialFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WrappedKeyMaterialFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WrappedKeyMaterialFormat> knownValues() {
        EnumSet<WrappedKeyMaterialFormat> knownValues = EnumSet.allOf(WrappedKeyMaterialFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WrappedKeyMaterialFormat.class, WrappedKeyMaterialFormat::toString);
    }
}

