/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SessionKeyDerivationMode {
    EMV_COMMON_SESSION_KEY("EMV_COMMON_SESSION_KEY"),
    EMV2000("EMV2000"),
    AMEX("AMEX"),
    MASTERCARD_SESSION_KEY("MASTERCARD_SESSION_KEY"),
    VISA("VISA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SessionKeyDerivationMode> VALUE_MAP;
    private final String value;

    private SessionKeyDerivationMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SessionKeyDerivationMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SessionKeyDerivationMode> knownValues() {
        EnumSet<SessionKeyDerivationMode> knownValues = EnumSet.allOf(SessionKeyDerivationMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SessionKeyDerivationMode.class, SessionKeyDerivationMode::toString);
    }
}

