/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PinData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PinData> {
    private static final SdkField<String> PIN_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PinOffset").getter(PinData.getter(PinData::pinOffset)).setter(PinData.setter(Builder::pinOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PinOffset").build()}).build();
    private static final SdkField<String> VERIFICATION_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerificationValue").getter(PinData.getter(PinData::verificationValue)).setter(PinData.setter(Builder::verificationValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIN_OFFSET_FIELD, VERIFICATION_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PinData.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String pinOffset;
    private final String verificationValue;
    private final Type type;

    private PinData(BuilderImpl builder) {
        this.pinOffset = builder.pinOffset;
        this.verificationValue = builder.verificationValue;
        this.type = builder.type;
    }

    public final String pinOffset() {
        return this.pinOffset;
    }

    public final String verificationValue() {
        return this.verificationValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pinOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.verificationValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PinData)) {
            return false;
        }
        PinData other = (PinData)obj;
        return Objects.equals(this.pinOffset(), other.pinOffset()) && Objects.equals(this.verificationValue(), other.verificationValue());
    }

    public final String toString() {
        return ToString.builder((String)"PinData").add("PinOffset", (Object)(this.pinOffset() == null ? null : "*** Sensitive Data Redacted ***")).add("VerificationValue", (Object)(this.verificationValue() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PinOffset": {
                return Optional.ofNullable(clazz.cast(this.pinOffset()));
            }
            case "VerificationValue": {
                return Optional.ofNullable(clazz.cast(this.verificationValue()));
            }
        }
        return Optional.empty();
    }

    public static PinData fromPinOffset(String pinOffset) {
        return (PinData)PinData.builder().pinOffset(pinOffset).build();
    }

    public static PinData fromVerificationValue(String verificationValue) {
        return (PinData)PinData.builder().verificationValue(verificationValue).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("PinOffset", PIN_OFFSET_FIELD);
        map.put("VerificationValue", VERIFICATION_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PinData, T> g) {
        return obj -> g.apply((PinData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        PIN_OFFSET,
        VERIFICATION_VALUE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String pinOffset;
        private String verificationValue;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PinData model) {
            this.pinOffset(model.pinOffset);
            this.verificationValue(model.verificationValue);
        }

        public final String getPinOffset() {
            return this.pinOffset;
        }

        public final void setPinOffset(String pinOffset) {
            String oldValue = this.pinOffset;
            this.pinOffset = pinOffset;
            this.handleUnionValueChange(Type.PIN_OFFSET, oldValue, this.pinOffset);
        }

        @Override
        public final Builder pinOffset(String pinOffset) {
            String oldValue = this.pinOffset;
            this.pinOffset = pinOffset;
            this.handleUnionValueChange(Type.PIN_OFFSET, oldValue, this.pinOffset);
            return this;
        }

        public final String getVerificationValue() {
            return this.verificationValue;
        }

        public final void setVerificationValue(String verificationValue) {
            String oldValue = this.verificationValue;
            this.verificationValue = verificationValue;
            this.handleUnionValueChange(Type.VERIFICATION_VALUE, oldValue, this.verificationValue);
        }

        @Override
        public final Builder verificationValue(String verificationValue) {
            String oldValue = this.verificationValue;
            this.verificationValue = verificationValue;
            this.handleUnionValueChange(Type.VERIFICATION_VALUE, oldValue, this.verificationValue);
            return this;
        }

        public PinData build() {
            return new PinData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PinData> {
        public Builder pinOffset(String var1);

        public Builder verificationValue(String var1);
    }
}

