/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.paymentcryptographydata.model.AsymmetricEncryptionAttributes;
import software.amazon.awssdk.services.paymentcryptographydata.model.DukptEncryptionAttributes;
import software.amazon.awssdk.services.paymentcryptographydata.model.EmvEncryptionAttributes;
import software.amazon.awssdk.services.paymentcryptographydata.model.SymmetricEncryptionAttributes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EncryptionDecryptionAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EncryptionDecryptionAttributes> {
    private static final SdkField<SymmetricEncryptionAttributes> SYMMETRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Symmetric").getter(EncryptionDecryptionAttributes.getter(EncryptionDecryptionAttributes::symmetric)).setter(EncryptionDecryptionAttributes.setter(Builder::symmetric)).constructor(SymmetricEncryptionAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Symmetric").build()}).build();
    private static final SdkField<AsymmetricEncryptionAttributes> ASYMMETRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Asymmetric").getter(EncryptionDecryptionAttributes.getter(EncryptionDecryptionAttributes::asymmetric)).setter(EncryptionDecryptionAttributes.setter(Builder::asymmetric)).constructor(AsymmetricEncryptionAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Asymmetric").build()}).build();
    private static final SdkField<DukptEncryptionAttributes> DUKPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Dukpt").getter(EncryptionDecryptionAttributes.getter(EncryptionDecryptionAttributes::dukpt)).setter(EncryptionDecryptionAttributes.setter(Builder::dukpt)).constructor(DukptEncryptionAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dukpt").build()}).build();
    private static final SdkField<EmvEncryptionAttributes> EMV_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Emv").getter(EncryptionDecryptionAttributes.getter(EncryptionDecryptionAttributes::emv)).setter(EncryptionDecryptionAttributes.setter(Builder::emv)).constructor(EmvEncryptionAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Emv").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYMMETRIC_FIELD, ASYMMETRIC_FIELD, DUKPT_FIELD, EMV_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Symmetric", SYMMETRIC_FIELD);
            this.put("Asymmetric", ASYMMETRIC_FIELD);
            this.put("Dukpt", DUKPT_FIELD);
            this.put("Emv", EMV_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final SymmetricEncryptionAttributes symmetric;
    private final AsymmetricEncryptionAttributes asymmetric;
    private final DukptEncryptionAttributes dukpt;
    private final EmvEncryptionAttributes emv;
    private final Type type;

    private EncryptionDecryptionAttributes(BuilderImpl builder) {
        this.symmetric = builder.symmetric;
        this.asymmetric = builder.asymmetric;
        this.dukpt = builder.dukpt;
        this.emv = builder.emv;
        this.type = builder.type;
    }

    public final SymmetricEncryptionAttributes symmetric() {
        return this.symmetric;
    }

    public final AsymmetricEncryptionAttributes asymmetric() {
        return this.asymmetric;
    }

    public final DukptEncryptionAttributes dukpt() {
        return this.dukpt;
    }

    public final EmvEncryptionAttributes emv() {
        return this.emv;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.symmetric());
        hashCode = 31 * hashCode + Objects.hashCode(this.asymmetric());
        hashCode = 31 * hashCode + Objects.hashCode(this.dukpt());
        hashCode = 31 * hashCode + Objects.hashCode(this.emv());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionDecryptionAttributes)) {
            return false;
        }
        EncryptionDecryptionAttributes other = (EncryptionDecryptionAttributes)obj;
        return Objects.equals(this.symmetric(), other.symmetric()) && Objects.equals(this.asymmetric(), other.asymmetric()) && Objects.equals(this.dukpt(), other.dukpt()) && Objects.equals(this.emv(), other.emv());
    }

    public final String toString() {
        return ToString.builder((String)"EncryptionDecryptionAttributes").add("Symmetric", (Object)this.symmetric()).add("Asymmetric", (Object)this.asymmetric()).add("Dukpt", (Object)this.dukpt()).add("Emv", (Object)this.emv()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Symmetric": {
                return Optional.ofNullable(clazz.cast(this.symmetric()));
            }
            case "Asymmetric": {
                return Optional.ofNullable(clazz.cast(this.asymmetric()));
            }
            case "Dukpt": {
                return Optional.ofNullable(clazz.cast(this.dukpt()));
            }
            case "Emv": {
                return Optional.ofNullable(clazz.cast(this.emv()));
            }
        }
        return Optional.empty();
    }

    public static EncryptionDecryptionAttributes fromSymmetric(SymmetricEncryptionAttributes symmetric) {
        return (EncryptionDecryptionAttributes)EncryptionDecryptionAttributes.builder().symmetric(symmetric).build();
    }

    public static EncryptionDecryptionAttributes fromSymmetric(Consumer<SymmetricEncryptionAttributes.Builder> symmetric) {
        SymmetricEncryptionAttributes.Builder builder = SymmetricEncryptionAttributes.builder();
        symmetric.accept(builder);
        return EncryptionDecryptionAttributes.fromSymmetric((SymmetricEncryptionAttributes)builder.build());
    }

    public static EncryptionDecryptionAttributes fromAsymmetric(AsymmetricEncryptionAttributes asymmetric) {
        return (EncryptionDecryptionAttributes)EncryptionDecryptionAttributes.builder().asymmetric(asymmetric).build();
    }

    public static EncryptionDecryptionAttributes fromAsymmetric(Consumer<AsymmetricEncryptionAttributes.Builder> asymmetric) {
        AsymmetricEncryptionAttributes.Builder builder = AsymmetricEncryptionAttributes.builder();
        asymmetric.accept(builder);
        return EncryptionDecryptionAttributes.fromAsymmetric((AsymmetricEncryptionAttributes)builder.build());
    }

    public static EncryptionDecryptionAttributes fromDukpt(DukptEncryptionAttributes dukpt) {
        return (EncryptionDecryptionAttributes)EncryptionDecryptionAttributes.builder().dukpt(dukpt).build();
    }

    public static EncryptionDecryptionAttributes fromDukpt(Consumer<DukptEncryptionAttributes.Builder> dukpt) {
        DukptEncryptionAttributes.Builder builder = DukptEncryptionAttributes.builder();
        dukpt.accept(builder);
        return EncryptionDecryptionAttributes.fromDukpt((DukptEncryptionAttributes)builder.build());
    }

    public static EncryptionDecryptionAttributes fromEmv(EmvEncryptionAttributes emv) {
        return (EncryptionDecryptionAttributes)EncryptionDecryptionAttributes.builder().emv(emv).build();
    }

    public static EncryptionDecryptionAttributes fromEmv(Consumer<EmvEncryptionAttributes.Builder> emv) {
        EmvEncryptionAttributes.Builder builder = EmvEncryptionAttributes.builder();
        emv.accept(builder);
        return EncryptionDecryptionAttributes.fromEmv((EmvEncryptionAttributes)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EncryptionDecryptionAttributes, T> g) {
        return obj -> g.apply((EncryptionDecryptionAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        SYMMETRIC,
        ASYMMETRIC,
        DUKPT,
        EMV,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private SymmetricEncryptionAttributes symmetric;
        private AsymmetricEncryptionAttributes asymmetric;
        private DukptEncryptionAttributes dukpt;
        private EmvEncryptionAttributes emv;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionDecryptionAttributes model) {
            this.symmetric(model.symmetric);
            this.asymmetric(model.asymmetric);
            this.dukpt(model.dukpt);
            this.emv(model.emv);
        }

        public final SymmetricEncryptionAttributes.Builder getSymmetric() {
            return this.symmetric != null ? this.symmetric.toBuilder() : null;
        }

        public final void setSymmetric(SymmetricEncryptionAttributes.BuilderImpl symmetric) {
            SymmetricEncryptionAttributes oldValue = this.symmetric;
            this.symmetric = symmetric != null ? symmetric.build() : null;
            this.handleUnionValueChange(Type.SYMMETRIC, oldValue, this.symmetric);
        }

        @Override
        public final Builder symmetric(SymmetricEncryptionAttributes symmetric) {
            SymmetricEncryptionAttributes oldValue = this.symmetric;
            this.symmetric = symmetric;
            this.handleUnionValueChange(Type.SYMMETRIC, oldValue, this.symmetric);
            return this;
        }

        public final AsymmetricEncryptionAttributes.Builder getAsymmetric() {
            return this.asymmetric != null ? this.asymmetric.toBuilder() : null;
        }

        public final void setAsymmetric(AsymmetricEncryptionAttributes.BuilderImpl asymmetric) {
            AsymmetricEncryptionAttributes oldValue = this.asymmetric;
            this.asymmetric = asymmetric != null ? asymmetric.build() : null;
            this.handleUnionValueChange(Type.ASYMMETRIC, oldValue, this.asymmetric);
        }

        @Override
        public final Builder asymmetric(AsymmetricEncryptionAttributes asymmetric) {
            AsymmetricEncryptionAttributes oldValue = this.asymmetric;
            this.asymmetric = asymmetric;
            this.handleUnionValueChange(Type.ASYMMETRIC, oldValue, this.asymmetric);
            return this;
        }

        public final DukptEncryptionAttributes.Builder getDukpt() {
            return this.dukpt != null ? this.dukpt.toBuilder() : null;
        }

        public final void setDukpt(DukptEncryptionAttributes.BuilderImpl dukpt) {
            DukptEncryptionAttributes oldValue = this.dukpt;
            this.dukpt = dukpt != null ? dukpt.build() : null;
            this.handleUnionValueChange(Type.DUKPT, oldValue, this.dukpt);
        }

        @Override
        public final Builder dukpt(DukptEncryptionAttributes dukpt) {
            DukptEncryptionAttributes oldValue = this.dukpt;
            this.dukpt = dukpt;
            this.handleUnionValueChange(Type.DUKPT, oldValue, this.dukpt);
            return this;
        }

        public final EmvEncryptionAttributes.Builder getEmv() {
            return this.emv != null ? this.emv.toBuilder() : null;
        }

        public final void setEmv(EmvEncryptionAttributes.BuilderImpl emv) {
            EmvEncryptionAttributes oldValue = this.emv;
            this.emv = emv != null ? emv.build() : null;
            this.handleUnionValueChange(Type.EMV, oldValue, this.emv);
        }

        @Override
        public final Builder emv(EmvEncryptionAttributes emv) {
            EmvEncryptionAttributes oldValue = this.emv;
            this.emv = emv;
            this.handleUnionValueChange(Type.EMV, oldValue, this.emv);
            return this;
        }

        public EncryptionDecryptionAttributes build() {
            return new EncryptionDecryptionAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EncryptionDecryptionAttributes> {
        public Builder symmetric(SymmetricEncryptionAttributes var1);

        default public Builder symmetric(Consumer<SymmetricEncryptionAttributes.Builder> symmetric) {
            return this.symmetric((SymmetricEncryptionAttributes)((SymmetricEncryptionAttributes.Builder)SymmetricEncryptionAttributes.builder().applyMutation(symmetric)).build());
        }

        public Builder asymmetric(AsymmetricEncryptionAttributes var1);

        default public Builder asymmetric(Consumer<AsymmetricEncryptionAttributes.Builder> asymmetric) {
            return this.asymmetric((AsymmetricEncryptionAttributes)((AsymmetricEncryptionAttributes.Builder)AsymmetricEncryptionAttributes.builder().applyMutation(asymmetric)).build());
        }

        public Builder dukpt(DukptEncryptionAttributes var1);

        default public Builder dukpt(Consumer<DukptEncryptionAttributes.Builder> dukpt) {
            return this.dukpt((DukptEncryptionAttributes)((DukptEncryptionAttributes.Builder)DukptEncryptionAttributes.builder().applyMutation(dukpt)).build());
        }

        public Builder emv(EmvEncryptionAttributes var1);

        default public Builder emv(Consumer<EmvEncryptionAttributes.Builder> emv) {
            return this.emv((EmvEncryptionAttributes)((EmvEncryptionAttributes.Builder)EmvEncryptionAttributes.builder().applyMutation(emv)).build());
        }
    }
}

