/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.paymentcryptographydata.model.Ibm3624PinVerification;
import software.amazon.awssdk.services.paymentcryptographydata.model.VisaPinVerification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PinVerificationAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PinVerificationAttributes> {
    private static final SdkField<VisaPinVerification> VISA_PIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VisaPin").getter(PinVerificationAttributes.getter(PinVerificationAttributes::visaPin)).setter(PinVerificationAttributes.setter(Builder::visaPin)).constructor(VisaPinVerification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisaPin").build()}).build();
    private static final SdkField<Ibm3624PinVerification> IBM3624_PIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Ibm3624Pin").getter(PinVerificationAttributes.getter(PinVerificationAttributes::ibm3624Pin)).setter(PinVerificationAttributes.setter(Builder::ibm3624Pin)).constructor(Ibm3624PinVerification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ibm3624Pin").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISA_PIN_FIELD, IBM3624_PIN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("VisaPin", VISA_PIN_FIELD);
            this.put("Ibm3624Pin", IBM3624_PIN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final VisaPinVerification visaPin;
    private final Ibm3624PinVerification ibm3624Pin;
    private final Type type;

    private PinVerificationAttributes(BuilderImpl builder) {
        this.visaPin = builder.visaPin;
        this.ibm3624Pin = builder.ibm3624Pin;
        this.type = builder.type;
    }

    public final VisaPinVerification visaPin() {
        return this.visaPin;
    }

    public final Ibm3624PinVerification ibm3624Pin() {
        return this.ibm3624Pin;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.visaPin());
        hashCode = 31 * hashCode + Objects.hashCode(this.ibm3624Pin());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PinVerificationAttributes)) {
            return false;
        }
        PinVerificationAttributes other = (PinVerificationAttributes)obj;
        return Objects.equals(this.visaPin(), other.visaPin()) && Objects.equals(this.ibm3624Pin(), other.ibm3624Pin());
    }

    public final String toString() {
        return ToString.builder((String)"PinVerificationAttributes").add("VisaPin", (Object)this.visaPin()).add("Ibm3624Pin", (Object)this.ibm3624Pin()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VisaPin": {
                return Optional.ofNullable(clazz.cast(this.visaPin()));
            }
            case "Ibm3624Pin": {
                return Optional.ofNullable(clazz.cast(this.ibm3624Pin()));
            }
        }
        return Optional.empty();
    }

    public static PinVerificationAttributes fromVisaPin(VisaPinVerification visaPin) {
        return (PinVerificationAttributes)PinVerificationAttributes.builder().visaPin(visaPin).build();
    }

    public static PinVerificationAttributes fromVisaPin(Consumer<VisaPinVerification.Builder> visaPin) {
        VisaPinVerification.Builder builder = VisaPinVerification.builder();
        visaPin.accept(builder);
        return PinVerificationAttributes.fromVisaPin((VisaPinVerification)builder.build());
    }

    public static PinVerificationAttributes fromIbm3624Pin(Ibm3624PinVerification ibm3624Pin) {
        return (PinVerificationAttributes)PinVerificationAttributes.builder().ibm3624Pin(ibm3624Pin).build();
    }

    public static PinVerificationAttributes fromIbm3624Pin(Consumer<Ibm3624PinVerification.Builder> ibm3624Pin) {
        Ibm3624PinVerification.Builder builder = Ibm3624PinVerification.builder();
        ibm3624Pin.accept(builder);
        return PinVerificationAttributes.fromIbm3624Pin((Ibm3624PinVerification)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PinVerificationAttributes, T> g) {
        return obj -> g.apply((PinVerificationAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        VISA_PIN,
        IBM3624_PIN,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private VisaPinVerification visaPin;
        private Ibm3624PinVerification ibm3624Pin;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PinVerificationAttributes model) {
            this.visaPin(model.visaPin);
            this.ibm3624Pin(model.ibm3624Pin);
        }

        public final VisaPinVerification.Builder getVisaPin() {
            return this.visaPin != null ? this.visaPin.toBuilder() : null;
        }

        public final void setVisaPin(VisaPinVerification.BuilderImpl visaPin) {
            VisaPinVerification oldValue = this.visaPin;
            this.visaPin = visaPin != null ? visaPin.build() : null;
            this.handleUnionValueChange(Type.VISA_PIN, oldValue, this.visaPin);
        }

        @Override
        public final Builder visaPin(VisaPinVerification visaPin) {
            VisaPinVerification oldValue = this.visaPin;
            this.visaPin = visaPin;
            this.handleUnionValueChange(Type.VISA_PIN, oldValue, this.visaPin);
            return this;
        }

        public final Ibm3624PinVerification.Builder getIbm3624Pin() {
            return this.ibm3624Pin != null ? this.ibm3624Pin.toBuilder() : null;
        }

        public final void setIbm3624Pin(Ibm3624PinVerification.BuilderImpl ibm3624Pin) {
            Ibm3624PinVerification oldValue = this.ibm3624Pin;
            this.ibm3624Pin = ibm3624Pin != null ? ibm3624Pin.build() : null;
            this.handleUnionValueChange(Type.IBM3624_PIN, oldValue, this.ibm3624Pin);
        }

        @Override
        public final Builder ibm3624Pin(Ibm3624PinVerification ibm3624Pin) {
            Ibm3624PinVerification oldValue = this.ibm3624Pin;
            this.ibm3624Pin = ibm3624Pin;
            this.handleUnionValueChange(Type.IBM3624_PIN, oldValue, this.ibm3624Pin);
            return this;
        }

        public PinVerificationAttributes build() {
            return new PinVerificationAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PinVerificationAttributes> {
        public Builder visaPin(VisaPinVerification var1);

        default public Builder visaPin(Consumer<VisaPinVerification.Builder> visaPin) {
            return this.visaPin((VisaPinVerification)((VisaPinVerification.Builder)VisaPinVerification.builder().applyMutation(visaPin)).build());
        }

        public Builder ibm3624Pin(Ibm3624PinVerification var1);

        default public Builder ibm3624Pin(Consumer<Ibm3624PinVerification.Builder> ibm3624Pin) {
            return this.ibm3624Pin((Ibm3624PinVerification)((Ibm3624PinVerification.Builder)Ibm3624PinVerification.builder().applyMutation(ibm3624Pin)).build());
        }
    }
}

