/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.paymentcryptographydata.model.AmexCardSecurityCodeVersion1;
import software.amazon.awssdk.services.paymentcryptographydata.model.AmexCardSecurityCodeVersion2;
import software.amazon.awssdk.services.paymentcryptographydata.model.CardHolderVerificationValue;
import software.amazon.awssdk.services.paymentcryptographydata.model.CardVerificationValue1;
import software.amazon.awssdk.services.paymentcryptographydata.model.CardVerificationValue2;
import software.amazon.awssdk.services.paymentcryptographydata.model.DynamicCardVerificationCode;
import software.amazon.awssdk.services.paymentcryptographydata.model.DynamicCardVerificationValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CardGenerationAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CardGenerationAttributes> {
    private static final SdkField<AmexCardSecurityCodeVersion1> AMEX_CARD_SECURITY_CODE_VERSION1_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AmexCardSecurityCodeVersion1").getter(CardGenerationAttributes.getter(CardGenerationAttributes::amexCardSecurityCodeVersion1)).setter(CardGenerationAttributes.setter(Builder::amexCardSecurityCodeVersion1)).constructor(AmexCardSecurityCodeVersion1::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmexCardSecurityCodeVersion1").build()}).build();
    private static final SdkField<AmexCardSecurityCodeVersion2> AMEX_CARD_SECURITY_CODE_VERSION2_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AmexCardSecurityCodeVersion2").getter(CardGenerationAttributes.getter(CardGenerationAttributes::amexCardSecurityCodeVersion2)).setter(CardGenerationAttributes.setter(Builder::amexCardSecurityCodeVersion2)).constructor(AmexCardSecurityCodeVersion2::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmexCardSecurityCodeVersion2").build()}).build();
    private static final SdkField<CardVerificationValue1> CARD_VERIFICATION_VALUE1_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CardVerificationValue1").getter(CardGenerationAttributes.getter(CardGenerationAttributes::cardVerificationValue1)).setter(CardGenerationAttributes.setter(Builder::cardVerificationValue1)).constructor(CardVerificationValue1::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CardVerificationValue1").build()}).build();
    private static final SdkField<CardVerificationValue2> CARD_VERIFICATION_VALUE2_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CardVerificationValue2").getter(CardGenerationAttributes.getter(CardGenerationAttributes::cardVerificationValue2)).setter(CardGenerationAttributes.setter(Builder::cardVerificationValue2)).constructor(CardVerificationValue2::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CardVerificationValue2").build()}).build();
    private static final SdkField<CardHolderVerificationValue> CARD_HOLDER_VERIFICATION_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CardHolderVerificationValue").getter(CardGenerationAttributes.getter(CardGenerationAttributes::cardHolderVerificationValue)).setter(CardGenerationAttributes.setter(Builder::cardHolderVerificationValue)).constructor(CardHolderVerificationValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CardHolderVerificationValue").build()}).build();
    private static final SdkField<DynamicCardVerificationCode> DYNAMIC_CARD_VERIFICATION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DynamicCardVerificationCode").getter(CardGenerationAttributes.getter(CardGenerationAttributes::dynamicCardVerificationCode)).setter(CardGenerationAttributes.setter(Builder::dynamicCardVerificationCode)).constructor(DynamicCardVerificationCode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamicCardVerificationCode").build()}).build();
    private static final SdkField<DynamicCardVerificationValue> DYNAMIC_CARD_VERIFICATION_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DynamicCardVerificationValue").getter(CardGenerationAttributes.getter(CardGenerationAttributes::dynamicCardVerificationValue)).setter(CardGenerationAttributes.setter(Builder::dynamicCardVerificationValue)).constructor(DynamicCardVerificationValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamicCardVerificationValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMEX_CARD_SECURITY_CODE_VERSION1_FIELD, AMEX_CARD_SECURITY_CODE_VERSION2_FIELD, CARD_VERIFICATION_VALUE1_FIELD, CARD_VERIFICATION_VALUE2_FIELD, CARD_HOLDER_VERIFICATION_VALUE_FIELD, DYNAMIC_CARD_VERIFICATION_CODE_FIELD, DYNAMIC_CARD_VERIFICATION_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final AmexCardSecurityCodeVersion1 amexCardSecurityCodeVersion1;
    private final AmexCardSecurityCodeVersion2 amexCardSecurityCodeVersion2;
    private final CardVerificationValue1 cardVerificationValue1;
    private final CardVerificationValue2 cardVerificationValue2;
    private final CardHolderVerificationValue cardHolderVerificationValue;
    private final DynamicCardVerificationCode dynamicCardVerificationCode;
    private final DynamicCardVerificationValue dynamicCardVerificationValue;
    private final Type type;

    private CardGenerationAttributes(BuilderImpl builder) {
        this.amexCardSecurityCodeVersion1 = builder.amexCardSecurityCodeVersion1;
        this.amexCardSecurityCodeVersion2 = builder.amexCardSecurityCodeVersion2;
        this.cardVerificationValue1 = builder.cardVerificationValue1;
        this.cardVerificationValue2 = builder.cardVerificationValue2;
        this.cardHolderVerificationValue = builder.cardHolderVerificationValue;
        this.dynamicCardVerificationCode = builder.dynamicCardVerificationCode;
        this.dynamicCardVerificationValue = builder.dynamicCardVerificationValue;
        this.type = builder.type;
    }

    public final AmexCardSecurityCodeVersion1 amexCardSecurityCodeVersion1() {
        return this.amexCardSecurityCodeVersion1;
    }

    public final AmexCardSecurityCodeVersion2 amexCardSecurityCodeVersion2() {
        return this.amexCardSecurityCodeVersion2;
    }

    public final CardVerificationValue1 cardVerificationValue1() {
        return this.cardVerificationValue1;
    }

    public final CardVerificationValue2 cardVerificationValue2() {
        return this.cardVerificationValue2;
    }

    public final CardHolderVerificationValue cardHolderVerificationValue() {
        return this.cardHolderVerificationValue;
    }

    public final DynamicCardVerificationCode dynamicCardVerificationCode() {
        return this.dynamicCardVerificationCode;
    }

    public final DynamicCardVerificationValue dynamicCardVerificationValue() {
        return this.dynamicCardVerificationValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amexCardSecurityCodeVersion1());
        hashCode = 31 * hashCode + Objects.hashCode(this.amexCardSecurityCodeVersion2());
        hashCode = 31 * hashCode + Objects.hashCode(this.cardVerificationValue1());
        hashCode = 31 * hashCode + Objects.hashCode(this.cardVerificationValue2());
        hashCode = 31 * hashCode + Objects.hashCode(this.cardHolderVerificationValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamicCardVerificationCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamicCardVerificationValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CardGenerationAttributes)) {
            return false;
        }
        CardGenerationAttributes other = (CardGenerationAttributes)obj;
        return Objects.equals(this.amexCardSecurityCodeVersion1(), other.amexCardSecurityCodeVersion1()) && Objects.equals(this.amexCardSecurityCodeVersion2(), other.amexCardSecurityCodeVersion2()) && Objects.equals(this.cardVerificationValue1(), other.cardVerificationValue1()) && Objects.equals(this.cardVerificationValue2(), other.cardVerificationValue2()) && Objects.equals(this.cardHolderVerificationValue(), other.cardHolderVerificationValue()) && Objects.equals(this.dynamicCardVerificationCode(), other.dynamicCardVerificationCode()) && Objects.equals(this.dynamicCardVerificationValue(), other.dynamicCardVerificationValue());
    }

    public final String toString() {
        return ToString.builder((String)"CardGenerationAttributes").add("AmexCardSecurityCodeVersion1", (Object)this.amexCardSecurityCodeVersion1()).add("AmexCardSecurityCodeVersion2", (Object)this.amexCardSecurityCodeVersion2()).add("CardVerificationValue1", (Object)this.cardVerificationValue1()).add("CardVerificationValue2", (Object)this.cardVerificationValue2()).add("CardHolderVerificationValue", (Object)this.cardHolderVerificationValue()).add("DynamicCardVerificationCode", (Object)this.dynamicCardVerificationCode()).add("DynamicCardVerificationValue", (Object)this.dynamicCardVerificationValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmexCardSecurityCodeVersion1": {
                return Optional.ofNullable(clazz.cast(this.amexCardSecurityCodeVersion1()));
            }
            case "AmexCardSecurityCodeVersion2": {
                return Optional.ofNullable(clazz.cast(this.amexCardSecurityCodeVersion2()));
            }
            case "CardVerificationValue1": {
                return Optional.ofNullable(clazz.cast(this.cardVerificationValue1()));
            }
            case "CardVerificationValue2": {
                return Optional.ofNullable(clazz.cast(this.cardVerificationValue2()));
            }
            case "CardHolderVerificationValue": {
                return Optional.ofNullable(clazz.cast(this.cardHolderVerificationValue()));
            }
            case "DynamicCardVerificationCode": {
                return Optional.ofNullable(clazz.cast(this.dynamicCardVerificationCode()));
            }
            case "DynamicCardVerificationValue": {
                return Optional.ofNullable(clazz.cast(this.dynamicCardVerificationValue()));
            }
        }
        return Optional.empty();
    }

    public static CardGenerationAttributes fromAmexCardSecurityCodeVersion1(AmexCardSecurityCodeVersion1 amexCardSecurityCodeVersion1) {
        return (CardGenerationAttributes)CardGenerationAttributes.builder().amexCardSecurityCodeVersion1(amexCardSecurityCodeVersion1).build();
    }

    public static CardGenerationAttributes fromAmexCardSecurityCodeVersion1(Consumer<AmexCardSecurityCodeVersion1.Builder> amexCardSecurityCodeVersion1) {
        AmexCardSecurityCodeVersion1.Builder builder = AmexCardSecurityCodeVersion1.builder();
        amexCardSecurityCodeVersion1.accept(builder);
        return CardGenerationAttributes.fromAmexCardSecurityCodeVersion1((AmexCardSecurityCodeVersion1)builder.build());
    }

    public static CardGenerationAttributes fromAmexCardSecurityCodeVersion2(AmexCardSecurityCodeVersion2 amexCardSecurityCodeVersion2) {
        return (CardGenerationAttributes)CardGenerationAttributes.builder().amexCardSecurityCodeVersion2(amexCardSecurityCodeVersion2).build();
    }

    public static CardGenerationAttributes fromAmexCardSecurityCodeVersion2(Consumer<AmexCardSecurityCodeVersion2.Builder> amexCardSecurityCodeVersion2) {
        AmexCardSecurityCodeVersion2.Builder builder = AmexCardSecurityCodeVersion2.builder();
        amexCardSecurityCodeVersion2.accept(builder);
        return CardGenerationAttributes.fromAmexCardSecurityCodeVersion2((AmexCardSecurityCodeVersion2)builder.build());
    }

    public static CardGenerationAttributes fromCardVerificationValue1(CardVerificationValue1 cardVerificationValue1) {
        return (CardGenerationAttributes)CardGenerationAttributes.builder().cardVerificationValue1(cardVerificationValue1).build();
    }

    public static CardGenerationAttributes fromCardVerificationValue1(Consumer<CardVerificationValue1.Builder> cardVerificationValue1) {
        CardVerificationValue1.Builder builder = CardVerificationValue1.builder();
        cardVerificationValue1.accept(builder);
        return CardGenerationAttributes.fromCardVerificationValue1((CardVerificationValue1)builder.build());
    }

    public static CardGenerationAttributes fromCardVerificationValue2(CardVerificationValue2 cardVerificationValue2) {
        return (CardGenerationAttributes)CardGenerationAttributes.builder().cardVerificationValue2(cardVerificationValue2).build();
    }

    public static CardGenerationAttributes fromCardVerificationValue2(Consumer<CardVerificationValue2.Builder> cardVerificationValue2) {
        CardVerificationValue2.Builder builder = CardVerificationValue2.builder();
        cardVerificationValue2.accept(builder);
        return CardGenerationAttributes.fromCardVerificationValue2((CardVerificationValue2)builder.build());
    }

    public static CardGenerationAttributes fromCardHolderVerificationValue(CardHolderVerificationValue cardHolderVerificationValue) {
        return (CardGenerationAttributes)CardGenerationAttributes.builder().cardHolderVerificationValue(cardHolderVerificationValue).build();
    }

    public static CardGenerationAttributes fromCardHolderVerificationValue(Consumer<CardHolderVerificationValue.Builder> cardHolderVerificationValue) {
        CardHolderVerificationValue.Builder builder = CardHolderVerificationValue.builder();
        cardHolderVerificationValue.accept(builder);
        return CardGenerationAttributes.fromCardHolderVerificationValue((CardHolderVerificationValue)builder.build());
    }

    public static CardGenerationAttributes fromDynamicCardVerificationCode(DynamicCardVerificationCode dynamicCardVerificationCode) {
        return (CardGenerationAttributes)CardGenerationAttributes.builder().dynamicCardVerificationCode(dynamicCardVerificationCode).build();
    }

    public static CardGenerationAttributes fromDynamicCardVerificationCode(Consumer<DynamicCardVerificationCode.Builder> dynamicCardVerificationCode) {
        DynamicCardVerificationCode.Builder builder = DynamicCardVerificationCode.builder();
        dynamicCardVerificationCode.accept(builder);
        return CardGenerationAttributes.fromDynamicCardVerificationCode((DynamicCardVerificationCode)builder.build());
    }

    public static CardGenerationAttributes fromDynamicCardVerificationValue(DynamicCardVerificationValue dynamicCardVerificationValue) {
        return (CardGenerationAttributes)CardGenerationAttributes.builder().dynamicCardVerificationValue(dynamicCardVerificationValue).build();
    }

    public static CardGenerationAttributes fromDynamicCardVerificationValue(Consumer<DynamicCardVerificationValue.Builder> dynamicCardVerificationValue) {
        DynamicCardVerificationValue.Builder builder = DynamicCardVerificationValue.builder();
        dynamicCardVerificationValue.accept(builder);
        return CardGenerationAttributes.fromDynamicCardVerificationValue((DynamicCardVerificationValue)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CardGenerationAttributes, T> g) {
        return obj -> g.apply((CardGenerationAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        AMEX_CARD_SECURITY_CODE_VERSION1,
        AMEX_CARD_SECURITY_CODE_VERSION2,
        CARD_VERIFICATION_VALUE1,
        CARD_VERIFICATION_VALUE2,
        CARD_HOLDER_VERIFICATION_VALUE,
        DYNAMIC_CARD_VERIFICATION_CODE,
        DYNAMIC_CARD_VERIFICATION_VALUE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private AmexCardSecurityCodeVersion1 amexCardSecurityCodeVersion1;
        private AmexCardSecurityCodeVersion2 amexCardSecurityCodeVersion2;
        private CardVerificationValue1 cardVerificationValue1;
        private CardVerificationValue2 cardVerificationValue2;
        private CardHolderVerificationValue cardHolderVerificationValue;
        private DynamicCardVerificationCode dynamicCardVerificationCode;
        private DynamicCardVerificationValue dynamicCardVerificationValue;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CardGenerationAttributes model) {
            this.amexCardSecurityCodeVersion1(model.amexCardSecurityCodeVersion1);
            this.amexCardSecurityCodeVersion2(model.amexCardSecurityCodeVersion2);
            this.cardVerificationValue1(model.cardVerificationValue1);
            this.cardVerificationValue2(model.cardVerificationValue2);
            this.cardHolderVerificationValue(model.cardHolderVerificationValue);
            this.dynamicCardVerificationCode(model.dynamicCardVerificationCode);
            this.dynamicCardVerificationValue(model.dynamicCardVerificationValue);
        }

        public final AmexCardSecurityCodeVersion1.Builder getAmexCardSecurityCodeVersion1() {
            return this.amexCardSecurityCodeVersion1 != null ? this.amexCardSecurityCodeVersion1.toBuilder() : null;
        }

        public final void setAmexCardSecurityCodeVersion1(AmexCardSecurityCodeVersion1.BuilderImpl amexCardSecurityCodeVersion1) {
            AmexCardSecurityCodeVersion1 oldValue = this.amexCardSecurityCodeVersion1;
            this.amexCardSecurityCodeVersion1 = amexCardSecurityCodeVersion1 != null ? amexCardSecurityCodeVersion1.build() : null;
            this.handleUnionValueChange(Type.AMEX_CARD_SECURITY_CODE_VERSION1, oldValue, this.amexCardSecurityCodeVersion1);
        }

        @Override
        public final Builder amexCardSecurityCodeVersion1(AmexCardSecurityCodeVersion1 amexCardSecurityCodeVersion1) {
            AmexCardSecurityCodeVersion1 oldValue = this.amexCardSecurityCodeVersion1;
            this.amexCardSecurityCodeVersion1 = amexCardSecurityCodeVersion1;
            this.handleUnionValueChange(Type.AMEX_CARD_SECURITY_CODE_VERSION1, oldValue, this.amexCardSecurityCodeVersion1);
            return this;
        }

        public final AmexCardSecurityCodeVersion2.Builder getAmexCardSecurityCodeVersion2() {
            return this.amexCardSecurityCodeVersion2 != null ? this.amexCardSecurityCodeVersion2.toBuilder() : null;
        }

        public final void setAmexCardSecurityCodeVersion2(AmexCardSecurityCodeVersion2.BuilderImpl amexCardSecurityCodeVersion2) {
            AmexCardSecurityCodeVersion2 oldValue = this.amexCardSecurityCodeVersion2;
            this.amexCardSecurityCodeVersion2 = amexCardSecurityCodeVersion2 != null ? amexCardSecurityCodeVersion2.build() : null;
            this.handleUnionValueChange(Type.AMEX_CARD_SECURITY_CODE_VERSION2, oldValue, this.amexCardSecurityCodeVersion2);
        }

        @Override
        public final Builder amexCardSecurityCodeVersion2(AmexCardSecurityCodeVersion2 amexCardSecurityCodeVersion2) {
            AmexCardSecurityCodeVersion2 oldValue = this.amexCardSecurityCodeVersion2;
            this.amexCardSecurityCodeVersion2 = amexCardSecurityCodeVersion2;
            this.handleUnionValueChange(Type.AMEX_CARD_SECURITY_CODE_VERSION2, oldValue, this.amexCardSecurityCodeVersion2);
            return this;
        }

        public final CardVerificationValue1.Builder getCardVerificationValue1() {
            return this.cardVerificationValue1 != null ? this.cardVerificationValue1.toBuilder() : null;
        }

        public final void setCardVerificationValue1(CardVerificationValue1.BuilderImpl cardVerificationValue1) {
            CardVerificationValue1 oldValue = this.cardVerificationValue1;
            this.cardVerificationValue1 = cardVerificationValue1 != null ? cardVerificationValue1.build() : null;
            this.handleUnionValueChange(Type.CARD_VERIFICATION_VALUE1, oldValue, this.cardVerificationValue1);
        }

        @Override
        public final Builder cardVerificationValue1(CardVerificationValue1 cardVerificationValue1) {
            CardVerificationValue1 oldValue = this.cardVerificationValue1;
            this.cardVerificationValue1 = cardVerificationValue1;
            this.handleUnionValueChange(Type.CARD_VERIFICATION_VALUE1, oldValue, this.cardVerificationValue1);
            return this;
        }

        public final CardVerificationValue2.Builder getCardVerificationValue2() {
            return this.cardVerificationValue2 != null ? this.cardVerificationValue2.toBuilder() : null;
        }

        public final void setCardVerificationValue2(CardVerificationValue2.BuilderImpl cardVerificationValue2) {
            CardVerificationValue2 oldValue = this.cardVerificationValue2;
            this.cardVerificationValue2 = cardVerificationValue2 != null ? cardVerificationValue2.build() : null;
            this.handleUnionValueChange(Type.CARD_VERIFICATION_VALUE2, oldValue, this.cardVerificationValue2);
        }

        @Override
        public final Builder cardVerificationValue2(CardVerificationValue2 cardVerificationValue2) {
            CardVerificationValue2 oldValue = this.cardVerificationValue2;
            this.cardVerificationValue2 = cardVerificationValue2;
            this.handleUnionValueChange(Type.CARD_VERIFICATION_VALUE2, oldValue, this.cardVerificationValue2);
            return this;
        }

        public final CardHolderVerificationValue.Builder getCardHolderVerificationValue() {
            return this.cardHolderVerificationValue != null ? this.cardHolderVerificationValue.toBuilder() : null;
        }

        public final void setCardHolderVerificationValue(CardHolderVerificationValue.BuilderImpl cardHolderVerificationValue) {
            CardHolderVerificationValue oldValue = this.cardHolderVerificationValue;
            this.cardHolderVerificationValue = cardHolderVerificationValue != null ? cardHolderVerificationValue.build() : null;
            this.handleUnionValueChange(Type.CARD_HOLDER_VERIFICATION_VALUE, oldValue, this.cardHolderVerificationValue);
        }

        @Override
        public final Builder cardHolderVerificationValue(CardHolderVerificationValue cardHolderVerificationValue) {
            CardHolderVerificationValue oldValue = this.cardHolderVerificationValue;
            this.cardHolderVerificationValue = cardHolderVerificationValue;
            this.handleUnionValueChange(Type.CARD_HOLDER_VERIFICATION_VALUE, oldValue, this.cardHolderVerificationValue);
            return this;
        }

        public final DynamicCardVerificationCode.Builder getDynamicCardVerificationCode() {
            return this.dynamicCardVerificationCode != null ? this.dynamicCardVerificationCode.toBuilder() : null;
        }

        public final void setDynamicCardVerificationCode(DynamicCardVerificationCode.BuilderImpl dynamicCardVerificationCode) {
            DynamicCardVerificationCode oldValue = this.dynamicCardVerificationCode;
            this.dynamicCardVerificationCode = dynamicCardVerificationCode != null ? dynamicCardVerificationCode.build() : null;
            this.handleUnionValueChange(Type.DYNAMIC_CARD_VERIFICATION_CODE, oldValue, this.dynamicCardVerificationCode);
        }

        @Override
        public final Builder dynamicCardVerificationCode(DynamicCardVerificationCode dynamicCardVerificationCode) {
            DynamicCardVerificationCode oldValue = this.dynamicCardVerificationCode;
            this.dynamicCardVerificationCode = dynamicCardVerificationCode;
            this.handleUnionValueChange(Type.DYNAMIC_CARD_VERIFICATION_CODE, oldValue, this.dynamicCardVerificationCode);
            return this;
        }

        public final DynamicCardVerificationValue.Builder getDynamicCardVerificationValue() {
            return this.dynamicCardVerificationValue != null ? this.dynamicCardVerificationValue.toBuilder() : null;
        }

        public final void setDynamicCardVerificationValue(DynamicCardVerificationValue.BuilderImpl dynamicCardVerificationValue) {
            DynamicCardVerificationValue oldValue = this.dynamicCardVerificationValue;
            this.dynamicCardVerificationValue = dynamicCardVerificationValue != null ? dynamicCardVerificationValue.build() : null;
            this.handleUnionValueChange(Type.DYNAMIC_CARD_VERIFICATION_VALUE, oldValue, this.dynamicCardVerificationValue);
        }

        @Override
        public final Builder dynamicCardVerificationValue(DynamicCardVerificationValue dynamicCardVerificationValue) {
            DynamicCardVerificationValue oldValue = this.dynamicCardVerificationValue;
            this.dynamicCardVerificationValue = dynamicCardVerificationValue;
            this.handleUnionValueChange(Type.DYNAMIC_CARD_VERIFICATION_VALUE, oldValue, this.dynamicCardVerificationValue);
            return this;
        }

        public CardGenerationAttributes build() {
            return new CardGenerationAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CardGenerationAttributes> {
        public Builder amexCardSecurityCodeVersion1(AmexCardSecurityCodeVersion1 var1);

        default public Builder amexCardSecurityCodeVersion1(Consumer<AmexCardSecurityCodeVersion1.Builder> amexCardSecurityCodeVersion1) {
            return this.amexCardSecurityCodeVersion1((AmexCardSecurityCodeVersion1)((AmexCardSecurityCodeVersion1.Builder)AmexCardSecurityCodeVersion1.builder().applyMutation(amexCardSecurityCodeVersion1)).build());
        }

        public Builder amexCardSecurityCodeVersion2(AmexCardSecurityCodeVersion2 var1);

        default public Builder amexCardSecurityCodeVersion2(Consumer<AmexCardSecurityCodeVersion2.Builder> amexCardSecurityCodeVersion2) {
            return this.amexCardSecurityCodeVersion2((AmexCardSecurityCodeVersion2)((AmexCardSecurityCodeVersion2.Builder)AmexCardSecurityCodeVersion2.builder().applyMutation(amexCardSecurityCodeVersion2)).build());
        }

        public Builder cardVerificationValue1(CardVerificationValue1 var1);

        default public Builder cardVerificationValue1(Consumer<CardVerificationValue1.Builder> cardVerificationValue1) {
            return this.cardVerificationValue1((CardVerificationValue1)((CardVerificationValue1.Builder)CardVerificationValue1.builder().applyMutation(cardVerificationValue1)).build());
        }

        public Builder cardVerificationValue2(CardVerificationValue2 var1);

        default public Builder cardVerificationValue2(Consumer<CardVerificationValue2.Builder> cardVerificationValue2) {
            return this.cardVerificationValue2((CardVerificationValue2)((CardVerificationValue2.Builder)CardVerificationValue2.builder().applyMutation(cardVerificationValue2)).build());
        }

        public Builder cardHolderVerificationValue(CardHolderVerificationValue var1);

        default public Builder cardHolderVerificationValue(Consumer<CardHolderVerificationValue.Builder> cardHolderVerificationValue) {
            return this.cardHolderVerificationValue((CardHolderVerificationValue)((CardHolderVerificationValue.Builder)CardHolderVerificationValue.builder().applyMutation(cardHolderVerificationValue)).build());
        }

        public Builder dynamicCardVerificationCode(DynamicCardVerificationCode var1);

        default public Builder dynamicCardVerificationCode(Consumer<DynamicCardVerificationCode.Builder> dynamicCardVerificationCode) {
            return this.dynamicCardVerificationCode((DynamicCardVerificationCode)((DynamicCardVerificationCode.Builder)DynamicCardVerificationCode.builder().applyMutation(dynamicCardVerificationCode)).build());
        }

        public Builder dynamicCardVerificationValue(DynamicCardVerificationValue var1);

        default public Builder dynamicCardVerificationValue(Consumer<DynamicCardVerificationValue.Builder> dynamicCardVerificationValue) {
            return this.dynamicCardVerificationValue((DynamicCardVerificationValue)((DynamicCardVerificationValue.Builder)DynamicCardVerificationValue.builder().applyMutation(dynamicCardVerificationValue)).build());
        }
    }
}

