/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptographydata.model.DukptDerivationType;
import software.amazon.awssdk.services.paymentcryptographydata.model.DukptKeyVariant;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DukptDerivationAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DukptDerivationAttributes> {
    private static final SdkField<String> KEY_SERIAL_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeySerialNumber").getter(DukptDerivationAttributes.getter(DukptDerivationAttributes::keySerialNumber)).setter(DukptDerivationAttributes.setter(Builder::keySerialNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeySerialNumber").build()}).build();
    private static final SdkField<String> DUKPT_KEY_DERIVATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DukptKeyDerivationType").getter(DukptDerivationAttributes.getter(DukptDerivationAttributes::dukptKeyDerivationTypeAsString)).setter(DukptDerivationAttributes.setter(Builder::dukptKeyDerivationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DukptKeyDerivationType").build()}).build();
    private static final SdkField<String> DUKPT_KEY_VARIANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DukptKeyVariant").getter(DukptDerivationAttributes.getter(DukptDerivationAttributes::dukptKeyVariantAsString)).setter(DukptDerivationAttributes.setter(Builder::dukptKeyVariant)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DukptKeyVariant").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_SERIAL_NUMBER_FIELD, DUKPT_KEY_DERIVATION_TYPE_FIELD, DUKPT_KEY_VARIANT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String keySerialNumber;
    private final String dukptKeyDerivationType;
    private final String dukptKeyVariant;

    private DukptDerivationAttributes(BuilderImpl builder) {
        this.keySerialNumber = builder.keySerialNumber;
        this.dukptKeyDerivationType = builder.dukptKeyDerivationType;
        this.dukptKeyVariant = builder.dukptKeyVariant;
    }

    public final String keySerialNumber() {
        return this.keySerialNumber;
    }

    public final DukptDerivationType dukptKeyDerivationType() {
        return DukptDerivationType.fromValue(this.dukptKeyDerivationType);
    }

    public final String dukptKeyDerivationTypeAsString() {
        return this.dukptKeyDerivationType;
    }

    public final DukptKeyVariant dukptKeyVariant() {
        return DukptKeyVariant.fromValue(this.dukptKeyVariant);
    }

    public final String dukptKeyVariantAsString() {
        return this.dukptKeyVariant;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keySerialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.dukptKeyDerivationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dukptKeyVariantAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DukptDerivationAttributes)) {
            return false;
        }
        DukptDerivationAttributes other = (DukptDerivationAttributes)obj;
        return Objects.equals(this.keySerialNumber(), other.keySerialNumber()) && Objects.equals(this.dukptKeyDerivationTypeAsString(), other.dukptKeyDerivationTypeAsString()) && Objects.equals(this.dukptKeyVariantAsString(), other.dukptKeyVariantAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DukptDerivationAttributes").add("KeySerialNumber", (Object)this.keySerialNumber()).add("DukptKeyDerivationType", (Object)this.dukptKeyDerivationTypeAsString()).add("DukptKeyVariant", (Object)this.dukptKeyVariantAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeySerialNumber": {
                return Optional.ofNullable(clazz.cast(this.keySerialNumber()));
            }
            case "DukptKeyDerivationType": {
                return Optional.ofNullable(clazz.cast(this.dukptKeyDerivationTypeAsString()));
            }
            case "DukptKeyVariant": {
                return Optional.ofNullable(clazz.cast(this.dukptKeyVariantAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DukptDerivationAttributes, T> g) {
        return obj -> g.apply((DukptDerivationAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String keySerialNumber;
        private String dukptKeyDerivationType;
        private String dukptKeyVariant;

        private BuilderImpl() {
        }

        private BuilderImpl(DukptDerivationAttributes model) {
            this.keySerialNumber(model.keySerialNumber);
            this.dukptKeyDerivationType(model.dukptKeyDerivationType);
            this.dukptKeyVariant(model.dukptKeyVariant);
        }

        public final String getKeySerialNumber() {
            return this.keySerialNumber;
        }

        public final void setKeySerialNumber(String keySerialNumber) {
            this.keySerialNumber = keySerialNumber;
        }

        @Override
        public final Builder keySerialNumber(String keySerialNumber) {
            this.keySerialNumber = keySerialNumber;
            return this;
        }

        public final String getDukptKeyDerivationType() {
            return this.dukptKeyDerivationType;
        }

        public final void setDukptKeyDerivationType(String dukptKeyDerivationType) {
            this.dukptKeyDerivationType = dukptKeyDerivationType;
        }

        @Override
        public final Builder dukptKeyDerivationType(String dukptKeyDerivationType) {
            this.dukptKeyDerivationType = dukptKeyDerivationType;
            return this;
        }

        @Override
        public final Builder dukptKeyDerivationType(DukptDerivationType dukptKeyDerivationType) {
            this.dukptKeyDerivationType(dukptKeyDerivationType == null ? null : dukptKeyDerivationType.toString());
            return this;
        }

        public final String getDukptKeyVariant() {
            return this.dukptKeyVariant;
        }

        public final void setDukptKeyVariant(String dukptKeyVariant) {
            this.dukptKeyVariant = dukptKeyVariant;
        }

        @Override
        public final Builder dukptKeyVariant(String dukptKeyVariant) {
            this.dukptKeyVariant = dukptKeyVariant;
            return this;
        }

        @Override
        public final Builder dukptKeyVariant(DukptKeyVariant dukptKeyVariant) {
            this.dukptKeyVariant(dukptKeyVariant == null ? null : dukptKeyVariant.toString());
            return this;
        }

        public DukptDerivationAttributes build() {
            return new DukptDerivationAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DukptDerivationAttributes> {
        public Builder keySerialNumber(String var1);

        public Builder dukptKeyDerivationType(String var1);

        public Builder dukptKeyDerivationType(DukptDerivationType var1);

        public Builder dukptKeyVariant(String var1);

        public Builder dukptKeyVariant(DukptKeyVariant var1);
    }
}

