/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptographydata.model.PaymentCryptographyDataResponse;
import software.amazon.awssdk.services.paymentcryptographydata.model.PinData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeneratePinDataResponse
extends PaymentCryptographyDataResponse
implements ToCopyableBuilder<Builder, GeneratePinDataResponse> {
    private static final SdkField<String> ENCRYPTED_PIN_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptedPinBlock").getter(GeneratePinDataResponse.getter(GeneratePinDataResponse::encryptedPinBlock)).setter(GeneratePinDataResponse.setter(Builder::encryptedPinBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptedPinBlock").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionKeyArn").getter(GeneratePinDataResponse.getter(GeneratePinDataResponse::encryptionKeyArn)).setter(GeneratePinDataResponse.setter(Builder::encryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyArn").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_CHECK_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionKeyCheckValue").getter(GeneratePinDataResponse.getter(GeneratePinDataResponse::encryptionKeyCheckValue)).setter(GeneratePinDataResponse.setter(Builder::encryptionKeyCheckValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyCheckValue").build()}).build();
    private static final SdkField<String> GENERATION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GenerationKeyArn").getter(GeneratePinDataResponse.getter(GeneratePinDataResponse::generationKeyArn)).setter(GeneratePinDataResponse.setter(Builder::generationKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerationKeyArn").build()}).build();
    private static final SdkField<String> GENERATION_KEY_CHECK_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GenerationKeyCheckValue").getter(GeneratePinDataResponse.getter(GeneratePinDataResponse::generationKeyCheckValue)).setter(GeneratePinDataResponse.setter(Builder::generationKeyCheckValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerationKeyCheckValue").build()}).build();
    private static final SdkField<PinData> PIN_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PinData").getter(GeneratePinDataResponse.getter(GeneratePinDataResponse::pinData)).setter(GeneratePinDataResponse.setter(Builder::pinData)).constructor(PinData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PinData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTED_PIN_BLOCK_FIELD, ENCRYPTION_KEY_ARN_FIELD, ENCRYPTION_KEY_CHECK_VALUE_FIELD, GENERATION_KEY_ARN_FIELD, GENERATION_KEY_CHECK_VALUE_FIELD, PIN_DATA_FIELD));
    private final String encryptedPinBlock;
    private final String encryptionKeyArn;
    private final String encryptionKeyCheckValue;
    private final String generationKeyArn;
    private final String generationKeyCheckValue;
    private final PinData pinData;

    private GeneratePinDataResponse(BuilderImpl builder) {
        super(builder);
        this.encryptedPinBlock = builder.encryptedPinBlock;
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.encryptionKeyCheckValue = builder.encryptionKeyCheckValue;
        this.generationKeyArn = builder.generationKeyArn;
        this.generationKeyCheckValue = builder.generationKeyCheckValue;
        this.pinData = builder.pinData;
    }

    public final String encryptedPinBlock() {
        return this.encryptedPinBlock;
    }

    public final String encryptionKeyArn() {
        return this.encryptionKeyArn;
    }

    public final String encryptionKeyCheckValue() {
        return this.encryptionKeyCheckValue;
    }

    public final String generationKeyArn() {
        return this.generationKeyArn;
    }

    public final String generationKeyCheckValue() {
        return this.generationKeyCheckValue;
    }

    public final PinData pinData() {
        return this.pinData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptedPinBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKeyCheckValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.generationKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.generationKeyCheckValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.pinData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeneratePinDataResponse)) {
            return false;
        }
        GeneratePinDataResponse other = (GeneratePinDataResponse)((Object)obj);
        return Objects.equals(this.encryptedPinBlock(), other.encryptedPinBlock()) && Objects.equals(this.encryptionKeyArn(), other.encryptionKeyArn()) && Objects.equals(this.encryptionKeyCheckValue(), other.encryptionKeyCheckValue()) && Objects.equals(this.generationKeyArn(), other.generationKeyArn()) && Objects.equals(this.generationKeyCheckValue(), other.generationKeyCheckValue()) && Objects.equals(this.pinData(), other.pinData());
    }

    public final String toString() {
        return ToString.builder((String)"GeneratePinDataResponse").add("EncryptedPinBlock", (Object)this.encryptedPinBlock()).add("EncryptionKeyArn", (Object)this.encryptionKeyArn()).add("EncryptionKeyCheckValue", (Object)this.encryptionKeyCheckValue()).add("GenerationKeyArn", (Object)this.generationKeyArn()).add("GenerationKeyCheckValue", (Object)this.generationKeyCheckValue()).add("PinData", (Object)this.pinData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EncryptedPinBlock": {
                return Optional.ofNullable(clazz.cast(this.encryptedPinBlock()));
            }
            case "EncryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.encryptionKeyArn()));
            }
            case "EncryptionKeyCheckValue": {
                return Optional.ofNullable(clazz.cast(this.encryptionKeyCheckValue()));
            }
            case "GenerationKeyArn": {
                return Optional.ofNullable(clazz.cast(this.generationKeyArn()));
            }
            case "GenerationKeyCheckValue": {
                return Optional.ofNullable(clazz.cast(this.generationKeyCheckValue()));
            }
            case "PinData": {
                return Optional.ofNullable(clazz.cast(this.pinData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GeneratePinDataResponse, T> g) {
        return obj -> g.apply((GeneratePinDataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PaymentCryptographyDataResponse.BuilderImpl
    implements Builder {
        private String encryptedPinBlock;
        private String encryptionKeyArn;
        private String encryptionKeyCheckValue;
        private String generationKeyArn;
        private String generationKeyCheckValue;
        private PinData pinData;

        private BuilderImpl() {
        }

        private BuilderImpl(GeneratePinDataResponse model) {
            super(model);
            this.encryptedPinBlock(model.encryptedPinBlock);
            this.encryptionKeyArn(model.encryptionKeyArn);
            this.encryptionKeyCheckValue(model.encryptionKeyCheckValue);
            this.generationKeyArn(model.generationKeyArn);
            this.generationKeyCheckValue(model.generationKeyCheckValue);
            this.pinData(model.pinData);
        }

        public final String getEncryptedPinBlock() {
            return this.encryptedPinBlock;
        }

        public final void setEncryptedPinBlock(String encryptedPinBlock) {
            this.encryptedPinBlock = encryptedPinBlock;
        }

        @Override
        public final Builder encryptedPinBlock(String encryptedPinBlock) {
            this.encryptedPinBlock = encryptedPinBlock;
            return this;
        }

        public final String getEncryptionKeyArn() {
            return this.encryptionKeyArn;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final String getEncryptionKeyCheckValue() {
            return this.encryptionKeyCheckValue;
        }

        public final void setEncryptionKeyCheckValue(String encryptionKeyCheckValue) {
            this.encryptionKeyCheckValue = encryptionKeyCheckValue;
        }

        @Override
        public final Builder encryptionKeyCheckValue(String encryptionKeyCheckValue) {
            this.encryptionKeyCheckValue = encryptionKeyCheckValue;
            return this;
        }

        public final String getGenerationKeyArn() {
            return this.generationKeyArn;
        }

        public final void setGenerationKeyArn(String generationKeyArn) {
            this.generationKeyArn = generationKeyArn;
        }

        @Override
        public final Builder generationKeyArn(String generationKeyArn) {
            this.generationKeyArn = generationKeyArn;
            return this;
        }

        public final String getGenerationKeyCheckValue() {
            return this.generationKeyCheckValue;
        }

        public final void setGenerationKeyCheckValue(String generationKeyCheckValue) {
            this.generationKeyCheckValue = generationKeyCheckValue;
        }

        @Override
        public final Builder generationKeyCheckValue(String generationKeyCheckValue) {
            this.generationKeyCheckValue = generationKeyCheckValue;
            return this;
        }

        public final PinData.Builder getPinData() {
            return this.pinData != null ? this.pinData.toBuilder() : null;
        }

        public final void setPinData(PinData.BuilderImpl pinData) {
            this.pinData = pinData != null ? pinData.build() : null;
        }

        @Override
        public final Builder pinData(PinData pinData) {
            this.pinData = pinData;
            return this;
        }

        @Override
        public GeneratePinDataResponse build() {
            return new GeneratePinDataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PaymentCryptographyDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GeneratePinDataResponse> {
        public Builder encryptedPinBlock(String var1);

        public Builder encryptionKeyArn(String var1);

        public Builder encryptionKeyCheckValue(String var1);

        public Builder generationKeyArn(String var1);

        public Builder generationKeyCheckValue(String var1);

        public Builder pinData(PinData var1);

        default public Builder pinData(Consumer<PinData.Builder> pinData) {
            return this.pinData((PinData)((PinData.Builder)PinData.builder().applyMutation(pinData)).build());
        }
    }
}

