/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifyAuthRequestCryptogramRequest extends PaymentCryptographyDataRequest implements
        ToCopyableBuilder<VerifyAuthRequestCryptogramRequest.Builder, VerifyAuthRequestCryptogramRequest> {
    private static final SdkField<String> AUTH_REQUEST_CRYPTOGRAM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthRequestCryptogram").getter(getter(VerifyAuthRequestCryptogramRequest::authRequestCryptogram))
            .setter(setter(Builder::authRequestCryptogram))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthRequestCryptogram").build())
            .build();

    private static final SdkField<CryptogramAuthResponse> AUTH_RESPONSE_ATTRIBUTES_FIELD = SdkField
            .<CryptogramAuthResponse> builder(MarshallingType.SDK_POJO).memberName("AuthResponseAttributes")
            .getter(getter(VerifyAuthRequestCryptogramRequest::authResponseAttributes))
            .setter(setter(Builder::authResponseAttributes)).constructor(CryptogramAuthResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthResponseAttributes").build())
            .build();

    private static final SdkField<String> KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyIdentifier").getter(getter(VerifyAuthRequestCryptogramRequest::keyIdentifier))
            .setter(setter(Builder::keyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyIdentifier").build()).build();

    private static final SdkField<String> MAJOR_KEY_DERIVATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MajorKeyDerivationMode")
            .getter(getter(VerifyAuthRequestCryptogramRequest::majorKeyDerivationModeAsString))
            .setter(setter(Builder::majorKeyDerivationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MajorKeyDerivationMode").build())
            .build();

    private static final SdkField<SessionKeyDerivation> SESSION_KEY_DERIVATION_ATTRIBUTES_FIELD = SdkField
            .<SessionKeyDerivation> builder(MarshallingType.SDK_POJO)
            .memberName("SessionKeyDerivationAttributes")
            .getter(getter(VerifyAuthRequestCryptogramRequest::sessionKeyDerivationAttributes))
            .setter(setter(Builder::sessionKeyDerivationAttributes))
            .constructor(SessionKeyDerivation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionKeyDerivationAttributes")
                    .build()).build();

    private static final SdkField<String> TRANSACTION_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransactionData").getter(getter(VerifyAuthRequestCryptogramRequest::transactionData))
            .setter(setter(Builder::transactionData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactionData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_REQUEST_CRYPTOGRAM_FIELD,
            AUTH_RESPONSE_ATTRIBUTES_FIELD, KEY_IDENTIFIER_FIELD, MAJOR_KEY_DERIVATION_MODE_FIELD,
            SESSION_KEY_DERIVATION_ATTRIBUTES_FIELD, TRANSACTION_DATA_FIELD));

    private final String authRequestCryptogram;

    private final CryptogramAuthResponse authResponseAttributes;

    private final String keyIdentifier;

    private final String majorKeyDerivationMode;

    private final SessionKeyDerivation sessionKeyDerivationAttributes;

    private final String transactionData;

    private VerifyAuthRequestCryptogramRequest(BuilderImpl builder) {
        super(builder);
        this.authRequestCryptogram = builder.authRequestCryptogram;
        this.authResponseAttributes = builder.authResponseAttributes;
        this.keyIdentifier = builder.keyIdentifier;
        this.majorKeyDerivationMode = builder.majorKeyDerivationMode;
        this.sessionKeyDerivationAttributes = builder.sessionKeyDerivationAttributes;
        this.transactionData = builder.transactionData;
    }

    /**
     * <p>
     * The auth request cryptogram imported into Amazon Web Services Payment Cryptography for ARQC verification using a
     * major encryption key and transaction data.
     * </p>
     * 
     * @return The auth request cryptogram imported into Amazon Web Services Payment Cryptography for ARQC verification
     *         using a major encryption key and transaction data.
     */
    public final String authRequestCryptogram() {
        return authRequestCryptogram;
    }

    /**
     * <p>
     * The attributes and values for auth request cryptogram verification. These parameters are required in case using
     * ARPC Method 1 or Method 2 for ARQC verification.
     * </p>
     * 
     * @return The attributes and values for auth request cryptogram verification. These parameters are required in case
     *         using ARPC Method 1 or Method 2 for ARQC verification.
     */
    public final CryptogramAuthResponse authResponseAttributes() {
        return authResponseAttributes;
    }

    /**
     * <p>
     * The <code>keyARN</code> of the major encryption key that Amazon Web Services Payment Cryptography uses for ARQC
     * verification.
     * </p>
     * 
     * @return The <code>keyARN</code> of the major encryption key that Amazon Web Services Payment Cryptography uses
     *         for ARQC verification.
     */
    public final String keyIdentifier() {
        return keyIdentifier;
    }

    /**
     * <p>
     * The method to use when deriving the major encryption key for ARQC verification within Amazon Web Services Payment
     * Cryptography. The same key derivation mode was used for ARQC generation outside of Amazon Web Services Payment
     * Cryptography.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #majorKeyDerivationMode} will return {@link MajorKeyDerivationMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #majorKeyDerivationModeAsString}.
     * </p>
     * 
     * @return The method to use when deriving the major encryption key for ARQC verification within Amazon Web Services
     *         Payment Cryptography. The same key derivation mode was used for ARQC generation outside of Amazon Web
     *         Services Payment Cryptography.
     * @see MajorKeyDerivationMode
     */
    public final MajorKeyDerivationMode majorKeyDerivationMode() {
        return MajorKeyDerivationMode.fromValue(majorKeyDerivationMode);
    }

    /**
     * <p>
     * The method to use when deriving the major encryption key for ARQC verification within Amazon Web Services Payment
     * Cryptography. The same key derivation mode was used for ARQC generation outside of Amazon Web Services Payment
     * Cryptography.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #majorKeyDerivationMode} will return {@link MajorKeyDerivationMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #majorKeyDerivationModeAsString}.
     * </p>
     * 
     * @return The method to use when deriving the major encryption key for ARQC verification within Amazon Web Services
     *         Payment Cryptography. The same key derivation mode was used for ARQC generation outside of Amazon Web
     *         Services Payment Cryptography.
     * @see MajorKeyDerivationMode
     */
    public final String majorKeyDerivationModeAsString() {
        return majorKeyDerivationMode;
    }

    /**
     * <p>
     * The attributes and values to use for deriving a session key for ARQC verification within Amazon Web Services
     * Payment Cryptography. The same attributes were used for ARQC generation outside of Amazon Web Services Payment
     * Cryptography.
     * </p>
     * 
     * @return The attributes and values to use for deriving a session key for ARQC verification within Amazon Web
     *         Services Payment Cryptography. The same attributes were used for ARQC generation outside of Amazon Web
     *         Services Payment Cryptography.
     */
    public final SessionKeyDerivation sessionKeyDerivationAttributes() {
        return sessionKeyDerivationAttributes;
    }

    /**
     * <p>
     * The transaction data that Amazon Web Services Payment Cryptography uses for ARQC verification. The same
     * transaction is used for ARQC generation outside of Amazon Web Services Payment Cryptography.
     * </p>
     * 
     * @return The transaction data that Amazon Web Services Payment Cryptography uses for ARQC verification. The same
     *         transaction is used for ARQC generation outside of Amazon Web Services Payment Cryptography.
     */
    public final String transactionData() {
        return transactionData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authRequestCryptogram());
        hashCode = 31 * hashCode + Objects.hashCode(authResponseAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(keyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(majorKeyDerivationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sessionKeyDerivationAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(transactionData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyAuthRequestCryptogramRequest)) {
            return false;
        }
        VerifyAuthRequestCryptogramRequest other = (VerifyAuthRequestCryptogramRequest) obj;
        return Objects.equals(authRequestCryptogram(), other.authRequestCryptogram())
                && Objects.equals(authResponseAttributes(), other.authResponseAttributes())
                && Objects.equals(keyIdentifier(), other.keyIdentifier())
                && Objects.equals(majorKeyDerivationModeAsString(), other.majorKeyDerivationModeAsString())
                && Objects.equals(sessionKeyDerivationAttributes(), other.sessionKeyDerivationAttributes())
                && Objects.equals(transactionData(), other.transactionData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerifyAuthRequestCryptogramRequest").add("AuthRequestCryptogram", authRequestCryptogram())
                .add("AuthResponseAttributes", authResponseAttributes()).add("KeyIdentifier", keyIdentifier())
                .add("MajorKeyDerivationMode", majorKeyDerivationModeAsString())
                .add("SessionKeyDerivationAttributes", sessionKeyDerivationAttributes())
                .add("TransactionData", transactionData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthRequestCryptogram":
            return Optional.ofNullable(clazz.cast(authRequestCryptogram()));
        case "AuthResponseAttributes":
            return Optional.ofNullable(clazz.cast(authResponseAttributes()));
        case "KeyIdentifier":
            return Optional.ofNullable(clazz.cast(keyIdentifier()));
        case "MajorKeyDerivationMode":
            return Optional.ofNullable(clazz.cast(majorKeyDerivationModeAsString()));
        case "SessionKeyDerivationAttributes":
            return Optional.ofNullable(clazz.cast(sessionKeyDerivationAttributes()));
        case "TransactionData":
            return Optional.ofNullable(clazz.cast(transactionData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VerifyAuthRequestCryptogramRequest, T> g) {
        return obj -> g.apply((VerifyAuthRequestCryptogramRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PaymentCryptographyDataRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, VerifyAuthRequestCryptogramRequest> {
        /**
         * <p>
         * The auth request cryptogram imported into Amazon Web Services Payment Cryptography for ARQC verification
         * using a major encryption key and transaction data.
         * </p>
         * 
         * @param authRequestCryptogram
         *        The auth request cryptogram imported into Amazon Web Services Payment Cryptography for ARQC
         *        verification using a major encryption key and transaction data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authRequestCryptogram(String authRequestCryptogram);

        /**
         * <p>
         * The attributes and values for auth request cryptogram verification. These parameters are required in case
         * using ARPC Method 1 or Method 2 for ARQC verification.
         * </p>
         * 
         * @param authResponseAttributes
         *        The attributes and values for auth request cryptogram verification. These parameters are required in
         *        case using ARPC Method 1 or Method 2 for ARQC verification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authResponseAttributes(CryptogramAuthResponse authResponseAttributes);

        /**
         * <p>
         * The attributes and values for auth request cryptogram verification. These parameters are required in case
         * using ARPC Method 1 or Method 2 for ARQC verification.
         * </p>
         * This is a convenience method that creates an instance of the {@link CryptogramAuthResponse.Builder} avoiding
         * the need to create one manually via {@link CryptogramAuthResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CryptogramAuthResponse.Builder#build()} is called immediately and
         * its result is passed to {@link #authResponseAttributes(CryptogramAuthResponse)}.
         * 
         * @param authResponseAttributes
         *        a consumer that will call methods on {@link CryptogramAuthResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authResponseAttributes(CryptogramAuthResponse)
         */
        default Builder authResponseAttributes(Consumer<CryptogramAuthResponse.Builder> authResponseAttributes) {
            return authResponseAttributes(CryptogramAuthResponse.builder().applyMutation(authResponseAttributes).build());
        }

        /**
         * <p>
         * The <code>keyARN</code> of the major encryption key that Amazon Web Services Payment Cryptography uses for
         * ARQC verification.
         * </p>
         * 
         * @param keyIdentifier
         *        The <code>keyARN</code> of the major encryption key that Amazon Web Services Payment Cryptography uses
         *        for ARQC verification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyIdentifier(String keyIdentifier);

        /**
         * <p>
         * The method to use when deriving the major encryption key for ARQC verification within Amazon Web Services
         * Payment Cryptography. The same key derivation mode was used for ARQC generation outside of Amazon Web
         * Services Payment Cryptography.
         * </p>
         * 
         * @param majorKeyDerivationMode
         *        The method to use when deriving the major encryption key for ARQC verification within Amazon Web
         *        Services Payment Cryptography. The same key derivation mode was used for ARQC generation outside of
         *        Amazon Web Services Payment Cryptography.
         * @see MajorKeyDerivationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MajorKeyDerivationMode
         */
        Builder majorKeyDerivationMode(String majorKeyDerivationMode);

        /**
         * <p>
         * The method to use when deriving the major encryption key for ARQC verification within Amazon Web Services
         * Payment Cryptography. The same key derivation mode was used for ARQC generation outside of Amazon Web
         * Services Payment Cryptography.
         * </p>
         * 
         * @param majorKeyDerivationMode
         *        The method to use when deriving the major encryption key for ARQC verification within Amazon Web
         *        Services Payment Cryptography. The same key derivation mode was used for ARQC generation outside of
         *        Amazon Web Services Payment Cryptography.
         * @see MajorKeyDerivationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MajorKeyDerivationMode
         */
        Builder majorKeyDerivationMode(MajorKeyDerivationMode majorKeyDerivationMode);

        /**
         * <p>
         * The attributes and values to use for deriving a session key for ARQC verification within Amazon Web Services
         * Payment Cryptography. The same attributes were used for ARQC generation outside of Amazon Web Services
         * Payment Cryptography.
         * </p>
         * 
         * @param sessionKeyDerivationAttributes
         *        The attributes and values to use for deriving a session key for ARQC verification within Amazon Web
         *        Services Payment Cryptography. The same attributes were used for ARQC generation outside of Amazon Web
         *        Services Payment Cryptography.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionKeyDerivationAttributes(SessionKeyDerivation sessionKeyDerivationAttributes);

        /**
         * <p>
         * The attributes and values to use for deriving a session key for ARQC verification within Amazon Web Services
         * Payment Cryptography. The same attributes were used for ARQC generation outside of Amazon Web Services
         * Payment Cryptography.
         * </p>
         * This is a convenience method that creates an instance of the {@link SessionKeyDerivation.Builder} avoiding
         * the need to create one manually via {@link SessionKeyDerivation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SessionKeyDerivation.Builder#build()} is called immediately and
         * its result is passed to {@link #sessionKeyDerivationAttributes(SessionKeyDerivation)}.
         * 
         * @param sessionKeyDerivationAttributes
         *        a consumer that will call methods on {@link SessionKeyDerivation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sessionKeyDerivationAttributes(SessionKeyDerivation)
         */
        default Builder sessionKeyDerivationAttributes(Consumer<SessionKeyDerivation.Builder> sessionKeyDerivationAttributes) {
            return sessionKeyDerivationAttributes(SessionKeyDerivation.builder().applyMutation(sessionKeyDerivationAttributes)
                    .build());
        }

        /**
         * <p>
         * The transaction data that Amazon Web Services Payment Cryptography uses for ARQC verification. The same
         * transaction is used for ARQC generation outside of Amazon Web Services Payment Cryptography.
         * </p>
         * 
         * @param transactionData
         *        The transaction data that Amazon Web Services Payment Cryptography uses for ARQC verification. The
         *        same transaction is used for ARQC generation outside of Amazon Web Services Payment Cryptography.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactionData(String transactionData);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PaymentCryptographyDataRequest.BuilderImpl implements Builder {
        private String authRequestCryptogram;

        private CryptogramAuthResponse authResponseAttributes;

        private String keyIdentifier;

        private String majorKeyDerivationMode;

        private SessionKeyDerivation sessionKeyDerivationAttributes;

        private String transactionData;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyAuthRequestCryptogramRequest model) {
            super(model);
            authRequestCryptogram(model.authRequestCryptogram);
            authResponseAttributes(model.authResponseAttributes);
            keyIdentifier(model.keyIdentifier);
            majorKeyDerivationMode(model.majorKeyDerivationMode);
            sessionKeyDerivationAttributes(model.sessionKeyDerivationAttributes);
            transactionData(model.transactionData);
        }

        public final String getAuthRequestCryptogram() {
            return authRequestCryptogram;
        }

        public final void setAuthRequestCryptogram(String authRequestCryptogram) {
            this.authRequestCryptogram = authRequestCryptogram;
        }

        @Override
        public final Builder authRequestCryptogram(String authRequestCryptogram) {
            this.authRequestCryptogram = authRequestCryptogram;
            return this;
        }

        public final CryptogramAuthResponse.Builder getAuthResponseAttributes() {
            return authResponseAttributes != null ? authResponseAttributes.toBuilder() : null;
        }

        public final void setAuthResponseAttributes(CryptogramAuthResponse.BuilderImpl authResponseAttributes) {
            this.authResponseAttributes = authResponseAttributes != null ? authResponseAttributes.build() : null;
        }

        @Override
        public final Builder authResponseAttributes(CryptogramAuthResponse authResponseAttributes) {
            this.authResponseAttributes = authResponseAttributes;
            return this;
        }

        public final String getKeyIdentifier() {
            return keyIdentifier;
        }

        public final void setKeyIdentifier(String keyIdentifier) {
            this.keyIdentifier = keyIdentifier;
        }

        @Override
        public final Builder keyIdentifier(String keyIdentifier) {
            this.keyIdentifier = keyIdentifier;
            return this;
        }

        public final String getMajorKeyDerivationMode() {
            return majorKeyDerivationMode;
        }

        public final void setMajorKeyDerivationMode(String majorKeyDerivationMode) {
            this.majorKeyDerivationMode = majorKeyDerivationMode;
        }

        @Override
        public final Builder majorKeyDerivationMode(String majorKeyDerivationMode) {
            this.majorKeyDerivationMode = majorKeyDerivationMode;
            return this;
        }

        @Override
        public final Builder majorKeyDerivationMode(MajorKeyDerivationMode majorKeyDerivationMode) {
            this.majorKeyDerivationMode(majorKeyDerivationMode == null ? null : majorKeyDerivationMode.toString());
            return this;
        }

        public final SessionKeyDerivation.Builder getSessionKeyDerivationAttributes() {
            return sessionKeyDerivationAttributes != null ? sessionKeyDerivationAttributes.toBuilder() : null;
        }

        public final void setSessionKeyDerivationAttributes(SessionKeyDerivation.BuilderImpl sessionKeyDerivationAttributes) {
            this.sessionKeyDerivationAttributes = sessionKeyDerivationAttributes != null ? sessionKeyDerivationAttributes.build()
                    : null;
        }

        @Override
        public final Builder sessionKeyDerivationAttributes(SessionKeyDerivation sessionKeyDerivationAttributes) {
            this.sessionKeyDerivationAttributes = sessionKeyDerivationAttributes;
            return this;
        }

        public final String getTransactionData() {
            return transactionData;
        }

        public final void setTransactionData(String transactionData) {
            this.transactionData = transactionData;
        }

        @Override
        public final Builder transactionData(String transactionData) {
            this.transactionData = transactionData;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public VerifyAuthRequestCryptogramRequest build() {
            return new VerifyAuthRequestCryptogramRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
