/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TranslatePinDataResponse extends PaymentCryptographyDataResponse implements
        ToCopyableBuilder<TranslatePinDataResponse.Builder, TranslatePinDataResponse> {
    private static final SdkField<String> KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KeyArn")
            .getter(getter(TranslatePinDataResponse::keyArn)).setter(setter(Builder::keyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyArn").build()).build();

    private static final SdkField<String> KEY_CHECK_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyCheckValue").getter(getter(TranslatePinDataResponse::keyCheckValue))
            .setter(setter(Builder::keyCheckValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyCheckValue").build()).build();

    private static final SdkField<String> PIN_BLOCK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PinBlock").getter(getter(TranslatePinDataResponse::pinBlock)).setter(setter(Builder::pinBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PinBlock").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ARN_FIELD,
            KEY_CHECK_VALUE_FIELD, PIN_BLOCK_FIELD));

    private final String keyArn;

    private final String keyCheckValue;

    private final String pinBlock;

    private TranslatePinDataResponse(BuilderImpl builder) {
        super(builder);
        this.keyArn = builder.keyArn;
        this.keyCheckValue = builder.keyCheckValue;
        this.pinBlock = builder.pinBlock;
    }

    /**
     * <p>
     * The <code>keyARN</code> of the encryption key that Amazon Web Services Payment Cryptography uses to encrypt
     * outgoing PIN block data after translation.
     * </p>
     * 
     * @return The <code>keyARN</code> of the encryption key that Amazon Web Services Payment Cryptography uses to
     *         encrypt outgoing PIN block data after translation.
     */
    public final String keyArn() {
        return keyArn;
    }

    /**
     * <p>
     * The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a given key have
     * the same key or to detect that a key has changed. Amazon Web Services Payment Cryptography calculates the KCV by
     * using standard algorithms, typically by encrypting 8 or 16 bytes or "00" or "01" and then truncating the result
     * to the first 3 bytes, or 6 hex digits, of the resulting cryptogram.
     * </p>
     * 
     * @return The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a given
     *         key have the same key or to detect that a key has changed. Amazon Web Services Payment Cryptography
     *         calculates the KCV by using standard algorithms, typically by encrypting 8 or 16 bytes or "00" or "01"
     *         and then truncating the result to the first 3 bytes, or 6 hex digits, of the resulting cryptogram.
     */
    public final String keyCheckValue() {
        return keyCheckValue;
    }

    /**
     * <p>
     * The ougoing encrypted PIN block data after tranlation.
     * </p>
     * 
     * @return The ougoing encrypted PIN block data after tranlation.
     */
    public final String pinBlock() {
        return pinBlock;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyArn());
        hashCode = 31 * hashCode + Objects.hashCode(keyCheckValue());
        hashCode = 31 * hashCode + Objects.hashCode(pinBlock());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TranslatePinDataResponse)) {
            return false;
        }
        TranslatePinDataResponse other = (TranslatePinDataResponse) obj;
        return Objects.equals(keyArn(), other.keyArn()) && Objects.equals(keyCheckValue(), other.keyCheckValue())
                && Objects.equals(pinBlock(), other.pinBlock());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TranslatePinDataResponse").add("KeyArn", keyArn()).add("KeyCheckValue", keyCheckValue())
                .add("PinBlock", pinBlock()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyArn":
            return Optional.ofNullable(clazz.cast(keyArn()));
        case "KeyCheckValue":
            return Optional.ofNullable(clazz.cast(keyCheckValue()));
        case "PinBlock":
            return Optional.ofNullable(clazz.cast(pinBlock()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TranslatePinDataResponse, T> g) {
        return obj -> g.apply((TranslatePinDataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PaymentCryptographyDataResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, TranslatePinDataResponse> {
        /**
         * <p>
         * The <code>keyARN</code> of the encryption key that Amazon Web Services Payment Cryptography uses to encrypt
         * outgoing PIN block data after translation.
         * </p>
         * 
         * @param keyArn
         *        The <code>keyARN</code> of the encryption key that Amazon Web Services Payment Cryptography uses to
         *        encrypt outgoing PIN block data after translation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyArn(String keyArn);

        /**
         * <p>
         * The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a given key
         * have the same key or to detect that a key has changed. Amazon Web Services Payment Cryptography calculates
         * the KCV by using standard algorithms, typically by encrypting 8 or 16 bytes or "00" or "01" and then
         * truncating the result to the first 3 bytes, or 6 hex digits, of the resulting cryptogram.
         * </p>
         * 
         * @param keyCheckValue
         *        The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a
         *        given key have the same key or to detect that a key has changed. Amazon Web Services Payment
         *        Cryptography calculates the KCV by using standard algorithms, typically by encrypting 8 or 16 bytes or
         *        "00" or "01" and then truncating the result to the first 3 bytes, or 6 hex digits, of the resulting
         *        cryptogram.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyCheckValue(String keyCheckValue);

        /**
         * <p>
         * The ougoing encrypted PIN block data after tranlation.
         * </p>
         * 
         * @param pinBlock
         *        The ougoing encrypted PIN block data after tranlation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pinBlock(String pinBlock);
    }

    static final class BuilderImpl extends PaymentCryptographyDataResponse.BuilderImpl implements Builder {
        private String keyArn;

        private String keyCheckValue;

        private String pinBlock;

        private BuilderImpl() {
        }

        private BuilderImpl(TranslatePinDataResponse model) {
            super(model);
            keyArn(model.keyArn);
            keyCheckValue(model.keyCheckValue);
            pinBlock(model.pinBlock);
        }

        public final String getKeyArn() {
            return keyArn;
        }

        public final void setKeyArn(String keyArn) {
            this.keyArn = keyArn;
        }

        @Override
        public final Builder keyArn(String keyArn) {
            this.keyArn = keyArn;
            return this;
        }

        public final String getKeyCheckValue() {
            return keyCheckValue;
        }

        public final void setKeyCheckValue(String keyCheckValue) {
            this.keyCheckValue = keyCheckValue;
        }

        @Override
        public final Builder keyCheckValue(String keyCheckValue) {
            this.keyCheckValue = keyCheckValue;
            return this;
        }

        public final String getPinBlock() {
            return pinBlock;
        }

        public final void setPinBlock(String pinBlock) {
            this.pinBlock = pinBlock;
        }

        @Override
        public final Builder pinBlock(String pinBlock) {
            this.pinBlock = pinBlock;
            return this;
        }

        @Override
        public TranslatePinDataResponse build() {
            return new TranslatePinDataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
