/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EncryptDataRequest extends PaymentCryptographyDataRequest implements
        ToCopyableBuilder<EncryptDataRequest.Builder, EncryptDataRequest> {
    private static final SdkField<EncryptionDecryptionAttributes> ENCRYPTION_ATTRIBUTES_FIELD = SdkField
            .<EncryptionDecryptionAttributes> builder(MarshallingType.SDK_POJO).memberName("EncryptionAttributes")
            .getter(getter(EncryptDataRequest::encryptionAttributes)).setter(setter(Builder::encryptionAttributes))
            .constructor(EncryptionDecryptionAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionAttributes").build())
            .build();

    private static final SdkField<String> KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyIdentifier").getter(getter(EncryptDataRequest::keyIdentifier)).setter(setter(Builder::keyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("KeyIdentifier").build()).build();

    private static final SdkField<String> PLAIN_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlainText").getter(getter(EncryptDataRequest::plainText)).setter(setter(Builder::plainText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlainText").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_ATTRIBUTES_FIELD,
            KEY_IDENTIFIER_FIELD, PLAIN_TEXT_FIELD));

    private final EncryptionDecryptionAttributes encryptionAttributes;

    private final String keyIdentifier;

    private final String plainText;

    private EncryptDataRequest(BuilderImpl builder) {
        super(builder);
        this.encryptionAttributes = builder.encryptionAttributes;
        this.keyIdentifier = builder.keyIdentifier;
        this.plainText = builder.plainText;
    }

    /**
     * <p>
     * The encryption key type and attributes for plaintext encryption.
     * </p>
     * 
     * @return The encryption key type and attributes for plaintext encryption.
     */
    public final EncryptionDecryptionAttributes encryptionAttributes() {
        return encryptionAttributes;
    }

    /**
     * <p>
     * The <code>keyARN</code> of the encryption key that Amazon Web Services Payment Cryptography uses for plaintext
     * encryption.
     * </p>
     * 
     * @return The <code>keyARN</code> of the encryption key that Amazon Web Services Payment Cryptography uses for
     *         plaintext encryption.
     */
    public final String keyIdentifier() {
        return keyIdentifier;
    }

    /**
     * <p>
     * The plaintext to be encrypted.
     * </p>
     * 
     * @return The plaintext to be encrypted.
     */
    public final String plainText() {
        return plainText;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(encryptionAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(keyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(plainText());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptDataRequest)) {
            return false;
        }
        EncryptDataRequest other = (EncryptDataRequest) obj;
        return Objects.equals(encryptionAttributes(), other.encryptionAttributes())
                && Objects.equals(keyIdentifier(), other.keyIdentifier()) && Objects.equals(plainText(), other.plainText());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EncryptDataRequest").add("EncryptionAttributes", encryptionAttributes())
                .add("KeyIdentifier", keyIdentifier())
                .add("PlainText", plainText() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EncryptionAttributes":
            return Optional.ofNullable(clazz.cast(encryptionAttributes()));
        case "KeyIdentifier":
            return Optional.ofNullable(clazz.cast(keyIdentifier()));
        case "PlainText":
            return Optional.ofNullable(clazz.cast(plainText()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EncryptDataRequest, T> g) {
        return obj -> g.apply((EncryptDataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PaymentCryptographyDataRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, EncryptDataRequest> {
        /**
         * <p>
         * The encryption key type and attributes for plaintext encryption.
         * </p>
         * 
         * @param encryptionAttributes
         *        The encryption key type and attributes for plaintext encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionAttributes(EncryptionDecryptionAttributes encryptionAttributes);

        /**
         * <p>
         * The encryption key type and attributes for plaintext encryption.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionDecryptionAttributes.Builder}
         * avoiding the need to create one manually via {@link EncryptionDecryptionAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionDecryptionAttributes.Builder#build()} is called
         * immediately and its result is passed to {@link #encryptionAttributes(EncryptionDecryptionAttributes)}.
         * 
         * @param encryptionAttributes
         *        a consumer that will call methods on {@link EncryptionDecryptionAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionAttributes(EncryptionDecryptionAttributes)
         */
        default Builder encryptionAttributes(Consumer<EncryptionDecryptionAttributes.Builder> encryptionAttributes) {
            return encryptionAttributes(EncryptionDecryptionAttributes.builder().applyMutation(encryptionAttributes).build());
        }

        /**
         * <p>
         * The <code>keyARN</code> of the encryption key that Amazon Web Services Payment Cryptography uses for
         * plaintext encryption.
         * </p>
         * 
         * @param keyIdentifier
         *        The <code>keyARN</code> of the encryption key that Amazon Web Services Payment Cryptography uses for
         *        plaintext encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyIdentifier(String keyIdentifier);

        /**
         * <p>
         * The plaintext to be encrypted.
         * </p>
         * 
         * @param plainText
         *        The plaintext to be encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder plainText(String plainText);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PaymentCryptographyDataRequest.BuilderImpl implements Builder {
        private EncryptionDecryptionAttributes encryptionAttributes;

        private String keyIdentifier;

        private String plainText;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptDataRequest model) {
            super(model);
            encryptionAttributes(model.encryptionAttributes);
            keyIdentifier(model.keyIdentifier);
            plainText(model.plainText);
        }

        public final EncryptionDecryptionAttributes.Builder getEncryptionAttributes() {
            return encryptionAttributes != null ? encryptionAttributes.toBuilder() : null;
        }

        public final void setEncryptionAttributes(EncryptionDecryptionAttributes.BuilderImpl encryptionAttributes) {
            this.encryptionAttributes = encryptionAttributes != null ? encryptionAttributes.build() : null;
        }

        @Override
        public final Builder encryptionAttributes(EncryptionDecryptionAttributes encryptionAttributes) {
            this.encryptionAttributes = encryptionAttributes;
            return this;
        }

        public final String getKeyIdentifier() {
            return keyIdentifier;
        }

        public final void setKeyIdentifier(String keyIdentifier) {
            this.keyIdentifier = keyIdentifier;
        }

        @Override
        public final Builder keyIdentifier(String keyIdentifier) {
            this.keyIdentifier = keyIdentifier;
            return this;
        }

        public final String getPlainText() {
            return plainText;
        }

        public final void setPlainText(String plainText) {
            this.plainText = plainText;
        }

        @Override
        public final Builder plainText(String plainText) {
            this.plainText = plainText;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EncryptDataRequest build() {
            return new EncryptDataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
