/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DecryptDataRequest extends PaymentCryptographyDataRequest implements
        ToCopyableBuilder<DecryptDataRequest.Builder, DecryptDataRequest> {
    private static final SdkField<String> CIPHER_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CipherText").getter(getter(DecryptDataRequest::cipherText)).setter(setter(Builder::cipherText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CipherText").build()).build();

    private static final SdkField<EncryptionDecryptionAttributes> DECRYPTION_ATTRIBUTES_FIELD = SdkField
            .<EncryptionDecryptionAttributes> builder(MarshallingType.SDK_POJO).memberName("DecryptionAttributes")
            .getter(getter(DecryptDataRequest::decryptionAttributes)).setter(setter(Builder::decryptionAttributes))
            .constructor(EncryptionDecryptionAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DecryptionAttributes").build())
            .build();

    private static final SdkField<String> KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyIdentifier").getter(getter(DecryptDataRequest::keyIdentifier)).setter(setter(Builder::keyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("KeyIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIPHER_TEXT_FIELD,
            DECRYPTION_ATTRIBUTES_FIELD, KEY_IDENTIFIER_FIELD));

    private final String cipherText;

    private final EncryptionDecryptionAttributes decryptionAttributes;

    private final String keyIdentifier;

    private DecryptDataRequest(BuilderImpl builder) {
        super(builder);
        this.cipherText = builder.cipherText;
        this.decryptionAttributes = builder.decryptionAttributes;
        this.keyIdentifier = builder.keyIdentifier;
    }

    /**
     * <p>
     * The ciphertext to decrypt.
     * </p>
     * 
     * @return The ciphertext to decrypt.
     */
    public final String cipherText() {
        return cipherText;
    }

    /**
     * <p>
     * The encryption key type and attributes for ciphertext decryption.
     * </p>
     * 
     * @return The encryption key type and attributes for ciphertext decryption.
     */
    public final EncryptionDecryptionAttributes decryptionAttributes() {
        return decryptionAttributes;
    }

    /**
     * <p>
     * The <code>keyARN</code> of the encryption key that Amazon Web Services Payment Cryptography uses for ciphertext
     * decryption.
     * </p>
     * 
     * @return The <code>keyARN</code> of the encryption key that Amazon Web Services Payment Cryptography uses for
     *         ciphertext decryption.
     */
    public final String keyIdentifier() {
        return keyIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cipherText());
        hashCode = 31 * hashCode + Objects.hashCode(decryptionAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(keyIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecryptDataRequest)) {
            return false;
        }
        DecryptDataRequest other = (DecryptDataRequest) obj;
        return Objects.equals(cipherText(), other.cipherText())
                && Objects.equals(decryptionAttributes(), other.decryptionAttributes())
                && Objects.equals(keyIdentifier(), other.keyIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DecryptDataRequest")
                .add("CipherText", cipherText() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DecryptionAttributes", decryptionAttributes()).add("KeyIdentifier", keyIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CipherText":
            return Optional.ofNullable(clazz.cast(cipherText()));
        case "DecryptionAttributes":
            return Optional.ofNullable(clazz.cast(decryptionAttributes()));
        case "KeyIdentifier":
            return Optional.ofNullable(clazz.cast(keyIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DecryptDataRequest, T> g) {
        return obj -> g.apply((DecryptDataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PaymentCryptographyDataRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DecryptDataRequest> {
        /**
         * <p>
         * The ciphertext to decrypt.
         * </p>
         * 
         * @param cipherText
         *        The ciphertext to decrypt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cipherText(String cipherText);

        /**
         * <p>
         * The encryption key type and attributes for ciphertext decryption.
         * </p>
         * 
         * @param decryptionAttributes
         *        The encryption key type and attributes for ciphertext decryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decryptionAttributes(EncryptionDecryptionAttributes decryptionAttributes);

        /**
         * <p>
         * The encryption key type and attributes for ciphertext decryption.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionDecryptionAttributes.Builder}
         * avoiding the need to create one manually via {@link EncryptionDecryptionAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionDecryptionAttributes.Builder#build()} is called
         * immediately and its result is passed to {@link #decryptionAttributes(EncryptionDecryptionAttributes)}.
         * 
         * @param decryptionAttributes
         *        a consumer that will call methods on {@link EncryptionDecryptionAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #decryptionAttributes(EncryptionDecryptionAttributes)
         */
        default Builder decryptionAttributes(Consumer<EncryptionDecryptionAttributes.Builder> decryptionAttributes) {
            return decryptionAttributes(EncryptionDecryptionAttributes.builder().applyMutation(decryptionAttributes).build());
        }

        /**
         * <p>
         * The <code>keyARN</code> of the encryption key that Amazon Web Services Payment Cryptography uses for
         * ciphertext decryption.
         * </p>
         * 
         * @param keyIdentifier
         *        The <code>keyARN</code> of the encryption key that Amazon Web Services Payment Cryptography uses for
         *        ciphertext decryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyIdentifier(String keyIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PaymentCryptographyDataRequest.BuilderImpl implements Builder {
        private String cipherText;

        private EncryptionDecryptionAttributes decryptionAttributes;

        private String keyIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DecryptDataRequest model) {
            super(model);
            cipherText(model.cipherText);
            decryptionAttributes(model.decryptionAttributes);
            keyIdentifier(model.keyIdentifier);
        }

        public final String getCipherText() {
            return cipherText;
        }

        public final void setCipherText(String cipherText) {
            this.cipherText = cipherText;
        }

        @Override
        public final Builder cipherText(String cipherText) {
            this.cipherText = cipherText;
            return this;
        }

        public final EncryptionDecryptionAttributes.Builder getDecryptionAttributes() {
            return decryptionAttributes != null ? decryptionAttributes.toBuilder() : null;
        }

        public final void setDecryptionAttributes(EncryptionDecryptionAttributes.BuilderImpl decryptionAttributes) {
            this.decryptionAttributes = decryptionAttributes != null ? decryptionAttributes.build() : null;
        }

        @Override
        public final Builder decryptionAttributes(EncryptionDecryptionAttributes decryptionAttributes) {
            this.decryptionAttributes = decryptionAttributes;
            return this;
        }

        public final String getKeyIdentifier() {
            return keyIdentifier;
        }

        public final void setKeyIdentifier(String keyIdentifier) {
            this.keyIdentifier = keyIdentifier;
        }

        @Override
        public final Builder keyIdentifier(String keyIdentifier) {
            this.keyIdentifier = keyIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DecryptDataRequest build() {
            return new DecryptDataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
