/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptography.model.As2805KeyVariant;
import software.amazon.awssdk.services.paymentcryptography.model.KeyAlgorithm;
import software.amazon.awssdk.services.paymentcryptography.model.KeyModesOfUse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportAs2805KeyCryptogram
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImportAs2805KeyCryptogram> {
    private static final SdkField<String> AS2805_KEY_VARIANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("As2805KeyVariant").getter(ImportAs2805KeyCryptogram.getter(ImportAs2805KeyCryptogram::as2805KeyVariantAsString)).setter(ImportAs2805KeyCryptogram.setter(Builder::as2805KeyVariant)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("As2805KeyVariant").build()}).build();
    private static final SdkField<KeyModesOfUse> KEY_MODES_OF_USE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KeyModesOfUse").getter(ImportAs2805KeyCryptogram.getter(ImportAs2805KeyCryptogram::keyModesOfUse)).setter(ImportAs2805KeyCryptogram.setter(Builder::keyModesOfUse)).constructor(KeyModesOfUse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyModesOfUse").build()}).build();
    private static final SdkField<String> KEY_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyAlgorithm").getter(ImportAs2805KeyCryptogram.getter(ImportAs2805KeyCryptogram::keyAlgorithmAsString)).setter(ImportAs2805KeyCryptogram.setter(Builder::keyAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAlgorithm").build()}).build();
    private static final SdkField<Boolean> EXPORTABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Exportable").getter(ImportAs2805KeyCryptogram.getter(ImportAs2805KeyCryptogram::exportable)).setter(ImportAs2805KeyCryptogram.setter(Builder::exportable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exportable").build()}).build();
    private static final SdkField<String> WRAPPING_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WrappingKeyIdentifier").getter(ImportAs2805KeyCryptogram.getter(ImportAs2805KeyCryptogram::wrappingKeyIdentifier)).setter(ImportAs2805KeyCryptogram.setter(Builder::wrappingKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappingKeyIdentifier").build()}).build();
    private static final SdkField<String> WRAPPED_KEY_CRYPTOGRAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WrappedKeyCryptogram").getter(ImportAs2805KeyCryptogram.getter(ImportAs2805KeyCryptogram::wrappedKeyCryptogram)).setter(ImportAs2805KeyCryptogram.setter(Builder::wrappedKeyCryptogram)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappedKeyCryptogram").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AS2805_KEY_VARIANT_FIELD, KEY_MODES_OF_USE_FIELD, KEY_ALGORITHM_FIELD, EXPORTABLE_FIELD, WRAPPING_KEY_IDENTIFIER_FIELD, WRAPPED_KEY_CRYPTOGRAM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImportAs2805KeyCryptogram.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String as2805KeyVariant;
    private final KeyModesOfUse keyModesOfUse;
    private final String keyAlgorithm;
    private final Boolean exportable;
    private final String wrappingKeyIdentifier;
    private final String wrappedKeyCryptogram;

    private ImportAs2805KeyCryptogram(BuilderImpl builder) {
        this.as2805KeyVariant = builder.as2805KeyVariant;
        this.keyModesOfUse = builder.keyModesOfUse;
        this.keyAlgorithm = builder.keyAlgorithm;
        this.exportable = builder.exportable;
        this.wrappingKeyIdentifier = builder.wrappingKeyIdentifier;
        this.wrappedKeyCryptogram = builder.wrappedKeyCryptogram;
    }

    public final As2805KeyVariant as2805KeyVariant() {
        return As2805KeyVariant.fromValue(this.as2805KeyVariant);
    }

    public final String as2805KeyVariantAsString() {
        return this.as2805KeyVariant;
    }

    public final KeyModesOfUse keyModesOfUse() {
        return this.keyModesOfUse;
    }

    public final KeyAlgorithm keyAlgorithm() {
        return KeyAlgorithm.fromValue(this.keyAlgorithm);
    }

    public final String keyAlgorithmAsString() {
        return this.keyAlgorithm;
    }

    public final Boolean exportable() {
        return this.exportable;
    }

    public final String wrappingKeyIdentifier() {
        return this.wrappingKeyIdentifier;
    }

    public final String wrappedKeyCryptogram() {
        return this.wrappedKeyCryptogram;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.as2805KeyVariantAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyModesOfUse());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportable());
        hashCode = 31 * hashCode + Objects.hashCode(this.wrappingKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.wrappedKeyCryptogram());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportAs2805KeyCryptogram)) {
            return false;
        }
        ImportAs2805KeyCryptogram other = (ImportAs2805KeyCryptogram)obj;
        return Objects.equals(this.as2805KeyVariantAsString(), other.as2805KeyVariantAsString()) && Objects.equals(this.keyModesOfUse(), other.keyModesOfUse()) && Objects.equals(this.keyAlgorithmAsString(), other.keyAlgorithmAsString()) && Objects.equals(this.exportable(), other.exportable()) && Objects.equals(this.wrappingKeyIdentifier(), other.wrappingKeyIdentifier()) && Objects.equals(this.wrappedKeyCryptogram(), other.wrappedKeyCryptogram());
    }

    public final String toString() {
        return ToString.builder((String)"ImportAs2805KeyCryptogram").add("As2805KeyVariant", (Object)this.as2805KeyVariantAsString()).add("KeyModesOfUse", (Object)this.keyModesOfUse()).add("KeyAlgorithm", (Object)this.keyAlgorithmAsString()).add("Exportable", (Object)this.exportable()).add("WrappingKeyIdentifier", (Object)this.wrappingKeyIdentifier()).add("WrappedKeyCryptogram", (Object)(this.wrappedKeyCryptogram() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "As2805KeyVariant": {
                return Optional.ofNullable(clazz.cast(this.as2805KeyVariantAsString()));
            }
            case "KeyModesOfUse": {
                return Optional.ofNullable(clazz.cast(this.keyModesOfUse()));
            }
            case "KeyAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.keyAlgorithmAsString()));
            }
            case "Exportable": {
                return Optional.ofNullable(clazz.cast(this.exportable()));
            }
            case "WrappingKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.wrappingKeyIdentifier()));
            }
            case "WrappedKeyCryptogram": {
                return Optional.ofNullable(clazz.cast(this.wrappedKeyCryptogram()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("As2805KeyVariant", AS2805_KEY_VARIANT_FIELD);
        map.put("KeyModesOfUse", KEY_MODES_OF_USE_FIELD);
        map.put("KeyAlgorithm", KEY_ALGORITHM_FIELD);
        map.put("Exportable", EXPORTABLE_FIELD);
        map.put("WrappingKeyIdentifier", WRAPPING_KEY_IDENTIFIER_FIELD);
        map.put("WrappedKeyCryptogram", WRAPPED_KEY_CRYPTOGRAM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportAs2805KeyCryptogram, T> g) {
        return obj -> g.apply((ImportAs2805KeyCryptogram)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String as2805KeyVariant;
        private KeyModesOfUse keyModesOfUse;
        private String keyAlgorithm;
        private Boolean exportable;
        private String wrappingKeyIdentifier;
        private String wrappedKeyCryptogram;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportAs2805KeyCryptogram model) {
            this.as2805KeyVariant(model.as2805KeyVariant);
            this.keyModesOfUse(model.keyModesOfUse);
            this.keyAlgorithm(model.keyAlgorithm);
            this.exportable(model.exportable);
            this.wrappingKeyIdentifier(model.wrappingKeyIdentifier);
            this.wrappedKeyCryptogram(model.wrappedKeyCryptogram);
        }

        public final String getAs2805KeyVariant() {
            return this.as2805KeyVariant;
        }

        public final void setAs2805KeyVariant(String as2805KeyVariant) {
            this.as2805KeyVariant = as2805KeyVariant;
        }

        @Override
        public final Builder as2805KeyVariant(String as2805KeyVariant) {
            this.as2805KeyVariant = as2805KeyVariant;
            return this;
        }

        @Override
        public final Builder as2805KeyVariant(As2805KeyVariant as2805KeyVariant) {
            this.as2805KeyVariant(as2805KeyVariant == null ? null : as2805KeyVariant.toString());
            return this;
        }

        public final KeyModesOfUse.Builder getKeyModesOfUse() {
            return this.keyModesOfUse != null ? this.keyModesOfUse.toBuilder() : null;
        }

        public final void setKeyModesOfUse(KeyModesOfUse.BuilderImpl keyModesOfUse) {
            this.keyModesOfUse = keyModesOfUse != null ? keyModesOfUse.build() : null;
        }

        @Override
        public final Builder keyModesOfUse(KeyModesOfUse keyModesOfUse) {
            this.keyModesOfUse = keyModesOfUse;
            return this;
        }

        public final String getKeyAlgorithm() {
            return this.keyAlgorithm;
        }

        public final void setKeyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
        }

        @Override
        public final Builder keyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
            return this;
        }

        @Override
        public final Builder keyAlgorithm(KeyAlgorithm keyAlgorithm) {
            this.keyAlgorithm(keyAlgorithm == null ? null : keyAlgorithm.toString());
            return this;
        }

        public final Boolean getExportable() {
            return this.exportable;
        }

        public final void setExportable(Boolean exportable) {
            this.exportable = exportable;
        }

        @Override
        public final Builder exportable(Boolean exportable) {
            this.exportable = exportable;
            return this;
        }

        public final String getWrappingKeyIdentifier() {
            return this.wrappingKeyIdentifier;
        }

        public final void setWrappingKeyIdentifier(String wrappingKeyIdentifier) {
            this.wrappingKeyIdentifier = wrappingKeyIdentifier;
        }

        @Override
        public final Builder wrappingKeyIdentifier(String wrappingKeyIdentifier) {
            this.wrappingKeyIdentifier = wrappingKeyIdentifier;
            return this;
        }

        public final String getWrappedKeyCryptogram() {
            return this.wrappedKeyCryptogram;
        }

        public final void setWrappedKeyCryptogram(String wrappedKeyCryptogram) {
            this.wrappedKeyCryptogram = wrappedKeyCryptogram;
        }

        @Override
        public final Builder wrappedKeyCryptogram(String wrappedKeyCryptogram) {
            this.wrappedKeyCryptogram = wrappedKeyCryptogram;
            return this;
        }

        public ImportAs2805KeyCryptogram build() {
            return new ImportAs2805KeyCryptogram(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImportAs2805KeyCryptogram> {
        public Builder as2805KeyVariant(String var1);

        public Builder as2805KeyVariant(As2805KeyVariant var1);

        public Builder keyModesOfUse(KeyModesOfUse var1);

        default public Builder keyModesOfUse(Consumer<KeyModesOfUse.Builder> keyModesOfUse) {
            return this.keyModesOfUse((KeyModesOfUse)((KeyModesOfUse.Builder)KeyModesOfUse.builder().applyMutation(keyModesOfUse)).build());
        }

        public Builder keyAlgorithm(String var1);

        public Builder keyAlgorithm(KeyAlgorithm var1);

        public Builder exportable(Boolean var1);

        public Builder wrappingKeyIdentifier(String var1);

        public Builder wrappedKeyCryptogram(String var1);
    }
}

