/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptography.model.KeyAlgorithm;
import software.amazon.awssdk.services.paymentcryptography.model.PaymentCryptographyResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetParametersForImportResponse
extends PaymentCryptographyResponse
implements ToCopyableBuilder<Builder, GetParametersForImportResponse> {
    private static final SdkField<String> WRAPPING_KEY_CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WrappingKeyCertificate").getter(GetParametersForImportResponse.getter(GetParametersForImportResponse::wrappingKeyCertificate)).setter(GetParametersForImportResponse.setter(Builder::wrappingKeyCertificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappingKeyCertificate").build()}).build();
    private static final SdkField<String> WRAPPING_KEY_CERTIFICATE_CHAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WrappingKeyCertificateChain").getter(GetParametersForImportResponse.getter(GetParametersForImportResponse::wrappingKeyCertificateChain)).setter(GetParametersForImportResponse.setter(Builder::wrappingKeyCertificateChain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappingKeyCertificateChain").build()}).build();
    private static final SdkField<String> WRAPPING_KEY_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WrappingKeyAlgorithm").getter(GetParametersForImportResponse.getter(GetParametersForImportResponse::wrappingKeyAlgorithmAsString)).setter(GetParametersForImportResponse.setter(Builder::wrappingKeyAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappingKeyAlgorithm").build()}).build();
    private static final SdkField<String> IMPORT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImportToken").getter(GetParametersForImportResponse.getter(GetParametersForImportResponse::importToken)).setter(GetParametersForImportResponse.setter(Builder::importToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportToken").build()}).build();
    private static final SdkField<Instant> PARAMETERS_VALID_UNTIL_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ParametersValidUntilTimestamp").getter(GetParametersForImportResponse.getter(GetParametersForImportResponse::parametersValidUntilTimestamp)).setter(GetParametersForImportResponse.setter(Builder::parametersValidUntilTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParametersValidUntilTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WRAPPING_KEY_CERTIFICATE_FIELD, WRAPPING_KEY_CERTIFICATE_CHAIN_FIELD, WRAPPING_KEY_ALGORITHM_FIELD, IMPORT_TOKEN_FIELD, PARAMETERS_VALID_UNTIL_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetParametersForImportResponse.memberNameToFieldInitializer();
    private final String wrappingKeyCertificate;
    private final String wrappingKeyCertificateChain;
    private final String wrappingKeyAlgorithm;
    private final String importToken;
    private final Instant parametersValidUntilTimestamp;

    private GetParametersForImportResponse(BuilderImpl builder) {
        super(builder);
        this.wrappingKeyCertificate = builder.wrappingKeyCertificate;
        this.wrappingKeyCertificateChain = builder.wrappingKeyCertificateChain;
        this.wrappingKeyAlgorithm = builder.wrappingKeyAlgorithm;
        this.importToken = builder.importToken;
        this.parametersValidUntilTimestamp = builder.parametersValidUntilTimestamp;
    }

    public final String wrappingKeyCertificate() {
        return this.wrappingKeyCertificate;
    }

    public final String wrappingKeyCertificateChain() {
        return this.wrappingKeyCertificateChain;
    }

    public final KeyAlgorithm wrappingKeyAlgorithm() {
        return KeyAlgorithm.fromValue(this.wrappingKeyAlgorithm);
    }

    public final String wrappingKeyAlgorithmAsString() {
        return this.wrappingKeyAlgorithm;
    }

    public final String importToken() {
        return this.importToken;
    }

    public final Instant parametersValidUntilTimestamp() {
        return this.parametersValidUntilTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.wrappingKeyCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.wrappingKeyCertificateChain());
        hashCode = 31 * hashCode + Objects.hashCode(this.wrappingKeyAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.importToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.parametersValidUntilTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParametersForImportResponse)) {
            return false;
        }
        GetParametersForImportResponse other = (GetParametersForImportResponse)((Object)obj);
        return Objects.equals(this.wrappingKeyCertificate(), other.wrappingKeyCertificate()) && Objects.equals(this.wrappingKeyCertificateChain(), other.wrappingKeyCertificateChain()) && Objects.equals(this.wrappingKeyAlgorithmAsString(), other.wrappingKeyAlgorithmAsString()) && Objects.equals(this.importToken(), other.importToken()) && Objects.equals(this.parametersValidUntilTimestamp(), other.parametersValidUntilTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"GetParametersForImportResponse").add("WrappingKeyCertificate", (Object)this.wrappingKeyCertificate()).add("WrappingKeyCertificateChain", (Object)this.wrappingKeyCertificateChain()).add("WrappingKeyAlgorithm", (Object)this.wrappingKeyAlgorithmAsString()).add("ImportToken", (Object)this.importToken()).add("ParametersValidUntilTimestamp", (Object)this.parametersValidUntilTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WrappingKeyCertificate": {
                return Optional.ofNullable(clazz.cast(this.wrappingKeyCertificate()));
            }
            case "WrappingKeyCertificateChain": {
                return Optional.ofNullable(clazz.cast(this.wrappingKeyCertificateChain()));
            }
            case "WrappingKeyAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.wrappingKeyAlgorithmAsString()));
            }
            case "ImportToken": {
                return Optional.ofNullable(clazz.cast(this.importToken()));
            }
            case "ParametersValidUntilTimestamp": {
                return Optional.ofNullable(clazz.cast(this.parametersValidUntilTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WrappingKeyCertificate", WRAPPING_KEY_CERTIFICATE_FIELD);
        map.put("WrappingKeyCertificateChain", WRAPPING_KEY_CERTIFICATE_CHAIN_FIELD);
        map.put("WrappingKeyAlgorithm", WRAPPING_KEY_ALGORITHM_FIELD);
        map.put("ImportToken", IMPORT_TOKEN_FIELD);
        map.put("ParametersValidUntilTimestamp", PARAMETERS_VALID_UNTIL_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetParametersForImportResponse, T> g) {
        return obj -> g.apply((GetParametersForImportResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PaymentCryptographyResponse.BuilderImpl
    implements Builder {
        private String wrappingKeyCertificate;
        private String wrappingKeyCertificateChain;
        private String wrappingKeyAlgorithm;
        private String importToken;
        private Instant parametersValidUntilTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetParametersForImportResponse model) {
            super(model);
            this.wrappingKeyCertificate(model.wrappingKeyCertificate);
            this.wrappingKeyCertificateChain(model.wrappingKeyCertificateChain);
            this.wrappingKeyAlgorithm(model.wrappingKeyAlgorithm);
            this.importToken(model.importToken);
            this.parametersValidUntilTimestamp(model.parametersValidUntilTimestamp);
        }

        public final String getWrappingKeyCertificate() {
            return this.wrappingKeyCertificate;
        }

        public final void setWrappingKeyCertificate(String wrappingKeyCertificate) {
            this.wrappingKeyCertificate = wrappingKeyCertificate;
        }

        @Override
        public final Builder wrappingKeyCertificate(String wrappingKeyCertificate) {
            this.wrappingKeyCertificate = wrappingKeyCertificate;
            return this;
        }

        public final String getWrappingKeyCertificateChain() {
            return this.wrappingKeyCertificateChain;
        }

        public final void setWrappingKeyCertificateChain(String wrappingKeyCertificateChain) {
            this.wrappingKeyCertificateChain = wrappingKeyCertificateChain;
        }

        @Override
        public final Builder wrappingKeyCertificateChain(String wrappingKeyCertificateChain) {
            this.wrappingKeyCertificateChain = wrappingKeyCertificateChain;
            return this;
        }

        public final String getWrappingKeyAlgorithm() {
            return this.wrappingKeyAlgorithm;
        }

        public final void setWrappingKeyAlgorithm(String wrappingKeyAlgorithm) {
            this.wrappingKeyAlgorithm = wrappingKeyAlgorithm;
        }

        @Override
        public final Builder wrappingKeyAlgorithm(String wrappingKeyAlgorithm) {
            this.wrappingKeyAlgorithm = wrappingKeyAlgorithm;
            return this;
        }

        @Override
        public final Builder wrappingKeyAlgorithm(KeyAlgorithm wrappingKeyAlgorithm) {
            this.wrappingKeyAlgorithm(wrappingKeyAlgorithm == null ? null : wrappingKeyAlgorithm.toString());
            return this;
        }

        public final String getImportToken() {
            return this.importToken;
        }

        public final void setImportToken(String importToken) {
            this.importToken = importToken;
        }

        @Override
        public final Builder importToken(String importToken) {
            this.importToken = importToken;
            return this;
        }

        public final Instant getParametersValidUntilTimestamp() {
            return this.parametersValidUntilTimestamp;
        }

        public final void setParametersValidUntilTimestamp(Instant parametersValidUntilTimestamp) {
            this.parametersValidUntilTimestamp = parametersValidUntilTimestamp;
        }

        @Override
        public final Builder parametersValidUntilTimestamp(Instant parametersValidUntilTimestamp) {
            this.parametersValidUntilTimestamp = parametersValidUntilTimestamp;
            return this;
        }

        @Override
        public GetParametersForImportResponse build() {
            return new GetParametersForImportResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PaymentCryptographyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetParametersForImportResponse> {
        public Builder wrappingKeyCertificate(String var1);

        public Builder wrappingKeyCertificateChain(String var1);

        public Builder wrappingKeyAlgorithm(String var1);

        public Builder wrappingKeyAlgorithm(KeyAlgorithm var1);

        public Builder importToken(String var1);

        public Builder parametersValidUntilTimestamp(Instant var1);
    }
}

