/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptography.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCertificateSigningRequestRequest extends PaymentCryptographyRequest implements
        ToCopyableBuilder<GetCertificateSigningRequestRequest.Builder, GetCertificateSigningRequestRequest> {
    private static final SdkField<String> KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyIdentifier").getter(getter(GetCertificateSigningRequestRequest::keyIdentifier))
            .setter(setter(Builder::keyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyIdentifier").build()).build();

    private static final SdkField<String> SIGNING_ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SigningAlgorithm").getter(getter(GetCertificateSigningRequestRequest::signingAlgorithmAsString))
            .setter(setter(Builder::signingAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningAlgorithm").build()).build();

    private static final SdkField<CertificateSubjectType> CERTIFICATE_SUBJECT_FIELD = SdkField
            .<CertificateSubjectType> builder(MarshallingType.SDK_POJO).memberName("CertificateSubject")
            .getter(getter(GetCertificateSigningRequestRequest::certificateSubject)).setter(setter(Builder::certificateSubject))
            .constructor(CertificateSubjectType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateSubject").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_IDENTIFIER_FIELD,
            SIGNING_ALGORITHM_FIELD, CERTIFICATE_SUBJECT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String keyIdentifier;

    private final String signingAlgorithm;

    private final CertificateSubjectType certificateSubject;

    private GetCertificateSigningRequestRequest(BuilderImpl builder) {
        super(builder);
        this.keyIdentifier = builder.keyIdentifier;
        this.signingAlgorithm = builder.signingAlgorithm;
        this.certificateSubject = builder.certificateSubject;
    }

    /**
     * <p>
     * Asymmetric key used for generating the certificate signing request
     * </p>
     * 
     * @return Asymmetric key used for generating the certificate signing request
     */
    public final String keyIdentifier() {
        return keyIdentifier;
    }

    /**
     * <p>
     * The cryptographic algorithm used to sign your CSR.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #signingAlgorithm}
     * will return {@link SigningAlgorithmType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #signingAlgorithmAsString}.
     * </p>
     * 
     * @return The cryptographic algorithm used to sign your CSR.
     * @see SigningAlgorithmType
     */
    public final SigningAlgorithmType signingAlgorithm() {
        return SigningAlgorithmType.fromValue(signingAlgorithm);
    }

    /**
     * <p>
     * The cryptographic algorithm used to sign your CSR.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #signingAlgorithm}
     * will return {@link SigningAlgorithmType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #signingAlgorithmAsString}.
     * </p>
     * 
     * @return The cryptographic algorithm used to sign your CSR.
     * @see SigningAlgorithmType
     */
    public final String signingAlgorithmAsString() {
        return signingAlgorithm;
    }

    /**
     * <p>
     * The metadata used to create the CSR.
     * </p>
     * 
     * @return The metadata used to create the CSR.
     */
    public final CertificateSubjectType certificateSubject() {
        return certificateSubject;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(signingAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(certificateSubject());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCertificateSigningRequestRequest)) {
            return false;
        }
        GetCertificateSigningRequestRequest other = (GetCertificateSigningRequestRequest) obj;
        return Objects.equals(keyIdentifier(), other.keyIdentifier())
                && Objects.equals(signingAlgorithmAsString(), other.signingAlgorithmAsString())
                && Objects.equals(certificateSubject(), other.certificateSubject());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCertificateSigningRequestRequest").add("KeyIdentifier", keyIdentifier())
                .add("SigningAlgorithm", signingAlgorithmAsString()).add("CertificateSubject", certificateSubject()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyIdentifier":
            return Optional.ofNullable(clazz.cast(keyIdentifier()));
        case "SigningAlgorithm":
            return Optional.ofNullable(clazz.cast(signingAlgorithmAsString()));
        case "CertificateSubject":
            return Optional.ofNullable(clazz.cast(certificateSubject()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KeyIdentifier", KEY_IDENTIFIER_FIELD);
        map.put("SigningAlgorithm", SIGNING_ALGORITHM_FIELD);
        map.put("CertificateSubject", CERTIFICATE_SUBJECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCertificateSigningRequestRequest, T> g) {
        return obj -> g.apply((GetCertificateSigningRequestRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PaymentCryptographyRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCertificateSigningRequestRequest> {
        /**
         * <p>
         * Asymmetric key used for generating the certificate signing request
         * </p>
         * 
         * @param keyIdentifier
         *        Asymmetric key used for generating the certificate signing request
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyIdentifier(String keyIdentifier);

        /**
         * <p>
         * The cryptographic algorithm used to sign your CSR.
         * </p>
         * 
         * @param signingAlgorithm
         *        The cryptographic algorithm used to sign your CSR.
         * @see SigningAlgorithmType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SigningAlgorithmType
         */
        Builder signingAlgorithm(String signingAlgorithm);

        /**
         * <p>
         * The cryptographic algorithm used to sign your CSR.
         * </p>
         * 
         * @param signingAlgorithm
         *        The cryptographic algorithm used to sign your CSR.
         * @see SigningAlgorithmType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SigningAlgorithmType
         */
        Builder signingAlgorithm(SigningAlgorithmType signingAlgorithm);

        /**
         * <p>
         * The metadata used to create the CSR.
         * </p>
         * 
         * @param certificateSubject
         *        The metadata used to create the CSR.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateSubject(CertificateSubjectType certificateSubject);

        /**
         * <p>
         * The metadata used to create the CSR.
         * </p>
         * This is a convenience method that creates an instance of the {@link CertificateSubjectType.Builder} avoiding
         * the need to create one manually via {@link CertificateSubjectType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CertificateSubjectType.Builder#build()} is called immediately and
         * its result is passed to {@link #certificateSubject(CertificateSubjectType)}.
         * 
         * @param certificateSubject
         *        a consumer that will call methods on {@link CertificateSubjectType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificateSubject(CertificateSubjectType)
         */
        default Builder certificateSubject(Consumer<CertificateSubjectType.Builder> certificateSubject) {
            return certificateSubject(CertificateSubjectType.builder().applyMutation(certificateSubject).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PaymentCryptographyRequest.BuilderImpl implements Builder {
        private String keyIdentifier;

        private String signingAlgorithm;

        private CertificateSubjectType certificateSubject;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCertificateSigningRequestRequest model) {
            super(model);
            keyIdentifier(model.keyIdentifier);
            signingAlgorithm(model.signingAlgorithm);
            certificateSubject(model.certificateSubject);
        }

        public final String getKeyIdentifier() {
            return keyIdentifier;
        }

        public final void setKeyIdentifier(String keyIdentifier) {
            this.keyIdentifier = keyIdentifier;
        }

        @Override
        public final Builder keyIdentifier(String keyIdentifier) {
            this.keyIdentifier = keyIdentifier;
            return this;
        }

        public final String getSigningAlgorithm() {
            return signingAlgorithm;
        }

        public final void setSigningAlgorithm(String signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
        }

        @Override
        public final Builder signingAlgorithm(String signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
            return this;
        }

        @Override
        public final Builder signingAlgorithm(SigningAlgorithmType signingAlgorithm) {
            this.signingAlgorithm(signingAlgorithm == null ? null : signingAlgorithm.toString());
            return this;
        }

        public final CertificateSubjectType.Builder getCertificateSubject() {
            return certificateSubject != null ? certificateSubject.toBuilder() : null;
        }

        public final void setCertificateSubject(CertificateSubjectType.BuilderImpl certificateSubject) {
            this.certificateSubject = certificateSubject != null ? certificateSubject.build() : null;
        }

        @Override
        public final Builder certificateSubject(CertificateSubjectType certificateSubject) {
            this.certificateSubject = certificateSubject;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCertificateSigningRequestRequest build() {
            return new GetCertificateSigningRequestRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
