/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptography.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameter information for key material export using symmetric TR-31 key exchange method.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportTr31KeyBlock implements SdkPojo, Serializable,
        ToCopyableBuilder<ExportTr31KeyBlock.Builder, ExportTr31KeyBlock> {
    private static final SdkField<String> WRAPPING_KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WrappingKeyIdentifier").getter(getter(ExportTr31KeyBlock::wrappingKeyIdentifier))
            .setter(setter(Builder::wrappingKeyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappingKeyIdentifier").build())
            .build();

    private static final SdkField<KeyBlockHeaders> KEY_BLOCK_HEADERS_FIELD = SdkField
            .<KeyBlockHeaders> builder(MarshallingType.SDK_POJO).memberName("KeyBlockHeaders")
            .getter(getter(ExportTr31KeyBlock::keyBlockHeaders)).setter(setter(Builder::keyBlockHeaders))
            .constructor(KeyBlockHeaders::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyBlockHeaders").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WRAPPING_KEY_IDENTIFIER_FIELD,
            KEY_BLOCK_HEADERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String wrappingKeyIdentifier;

    private final KeyBlockHeaders keyBlockHeaders;

    private ExportTr31KeyBlock(BuilderImpl builder) {
        this.wrappingKeyIdentifier = builder.wrappingKeyIdentifier;
        this.keyBlockHeaders = builder.keyBlockHeaders;
    }

    /**
     * <p>
     * The <code>KeyARN</code> of the the wrapping key. This key encrypts or wraps the key under export for TR-31 key
     * block generation.
     * </p>
     * 
     * @return The <code>KeyARN</code> of the the wrapping key. This key encrypts or wraps the key under export for
     *         TR-31 key block generation.
     */
    public final String wrappingKeyIdentifier() {
        return wrappingKeyIdentifier;
    }

    /**
     * <p>
     * Optional metadata for export associated with the key material. This data is signed but transmitted in clear text.
     * </p>
     * 
     * @return Optional metadata for export associated with the key material. This data is signed but transmitted in
     *         clear text.
     */
    public final KeyBlockHeaders keyBlockHeaders() {
        return keyBlockHeaders;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(wrappingKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(keyBlockHeaders());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportTr31KeyBlock)) {
            return false;
        }
        ExportTr31KeyBlock other = (ExportTr31KeyBlock) obj;
        return Objects.equals(wrappingKeyIdentifier(), other.wrappingKeyIdentifier())
                && Objects.equals(keyBlockHeaders(), other.keyBlockHeaders());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportTr31KeyBlock").add("WrappingKeyIdentifier", wrappingKeyIdentifier())
                .add("KeyBlockHeaders", keyBlockHeaders()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WrappingKeyIdentifier":
            return Optional.ofNullable(clazz.cast(wrappingKeyIdentifier()));
        case "KeyBlockHeaders":
            return Optional.ofNullable(clazz.cast(keyBlockHeaders()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WrappingKeyIdentifier", WRAPPING_KEY_IDENTIFIER_FIELD);
        map.put("KeyBlockHeaders", KEY_BLOCK_HEADERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportTr31KeyBlock, T> g) {
        return obj -> g.apply((ExportTr31KeyBlock) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportTr31KeyBlock> {
        /**
         * <p>
         * The <code>KeyARN</code> of the the wrapping key. This key encrypts or wraps the key under export for TR-31
         * key block generation.
         * </p>
         * 
         * @param wrappingKeyIdentifier
         *        The <code>KeyARN</code> of the the wrapping key. This key encrypts or wraps the key under export for
         *        TR-31 key block generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wrappingKeyIdentifier(String wrappingKeyIdentifier);

        /**
         * <p>
         * Optional metadata for export associated with the key material. This data is signed but transmitted in clear
         * text.
         * </p>
         * 
         * @param keyBlockHeaders
         *        Optional metadata for export associated with the key material. This data is signed but transmitted in
         *        clear text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyBlockHeaders(KeyBlockHeaders keyBlockHeaders);

        /**
         * <p>
         * Optional metadata for export associated with the key material. This data is signed but transmitted in clear
         * text.
         * </p>
         * This is a convenience method that creates an instance of the {@link KeyBlockHeaders.Builder} avoiding the
         * need to create one manually via {@link KeyBlockHeaders#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KeyBlockHeaders.Builder#build()} is called immediately and its
         * result is passed to {@link #keyBlockHeaders(KeyBlockHeaders)}.
         * 
         * @param keyBlockHeaders
         *        a consumer that will call methods on {@link KeyBlockHeaders.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyBlockHeaders(KeyBlockHeaders)
         */
        default Builder keyBlockHeaders(Consumer<KeyBlockHeaders.Builder> keyBlockHeaders) {
            return keyBlockHeaders(KeyBlockHeaders.builder().applyMutation(keyBlockHeaders).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String wrappingKeyIdentifier;

        private KeyBlockHeaders keyBlockHeaders;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportTr31KeyBlock model) {
            wrappingKeyIdentifier(model.wrappingKeyIdentifier);
            keyBlockHeaders(model.keyBlockHeaders);
        }

        public final String getWrappingKeyIdentifier() {
            return wrappingKeyIdentifier;
        }

        public final void setWrappingKeyIdentifier(String wrappingKeyIdentifier) {
            this.wrappingKeyIdentifier = wrappingKeyIdentifier;
        }

        @Override
        public final Builder wrappingKeyIdentifier(String wrappingKeyIdentifier) {
            this.wrappingKeyIdentifier = wrappingKeyIdentifier;
            return this;
        }

        public final KeyBlockHeaders.Builder getKeyBlockHeaders() {
            return keyBlockHeaders != null ? keyBlockHeaders.toBuilder() : null;
        }

        public final void setKeyBlockHeaders(KeyBlockHeaders.BuilderImpl keyBlockHeaders) {
            this.keyBlockHeaders = keyBlockHeaders != null ? keyBlockHeaders.build() : null;
        }

        @Override
        public final Builder keyBlockHeaders(KeyBlockHeaders keyBlockHeaders) {
            this.keyBlockHeaders = keyBlockHeaders;
            return this;
        }

        @Override
        public ExportTr31KeyBlock build() {
            return new ExportTr31KeyBlock(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
