/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MultiRegionKeyType {
    PRIMARY("PRIMARY"),
    REPLICA("REPLICA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MultiRegionKeyType> VALUE_MAP;
    private final String value;

    private MultiRegionKeyType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MultiRegionKeyType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MultiRegionKeyType> knownValues() {
        EnumSet<MultiRegionKeyType> knownValues = EnumSet.allOf(MultiRegionKeyType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MultiRegionKeyType.class, MultiRegionKeyType::toString);
    }
}

