/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptography.model.KeyBlockHeaders;
import software.amazon.awssdk.services.paymentcryptography.model.Tr34KeyBlockFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportTr34KeyBlock
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportTr34KeyBlock> {
    private static final SdkField<String> CERTIFICATE_AUTHORITY_PUBLIC_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateAuthorityPublicKeyIdentifier").getter(ExportTr34KeyBlock.getter(ExportTr34KeyBlock::certificateAuthorityPublicKeyIdentifier)).setter(ExportTr34KeyBlock.setter(Builder::certificateAuthorityPublicKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityPublicKeyIdentifier").build()}).build();
    private static final SdkField<String> WRAPPING_KEY_CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WrappingKeyCertificate").getter(ExportTr34KeyBlock.getter(ExportTr34KeyBlock::wrappingKeyCertificate)).setter(ExportTr34KeyBlock.setter(Builder::wrappingKeyCertificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappingKeyCertificate").build()}).build();
    private static final SdkField<String> EXPORT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportToken").getter(ExportTr34KeyBlock.getter(ExportTr34KeyBlock::exportToken)).setter(ExportTr34KeyBlock.setter(Builder::exportToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportToken").build()}).build();
    private static final SdkField<String> SIGNING_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SigningKeyIdentifier").getter(ExportTr34KeyBlock.getter(ExportTr34KeyBlock::signingKeyIdentifier)).setter(ExportTr34KeyBlock.setter(Builder::signingKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningKeyIdentifier").build()}).build();
    private static final SdkField<String> SIGNING_KEY_CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SigningKeyCertificate").getter(ExportTr34KeyBlock.getter(ExportTr34KeyBlock::signingKeyCertificate)).setter(ExportTr34KeyBlock.setter(Builder::signingKeyCertificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningKeyCertificate").build()}).build();
    private static final SdkField<String> KEY_BLOCK_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyBlockFormat").getter(ExportTr34KeyBlock.getter(ExportTr34KeyBlock::keyBlockFormatAsString)).setter(ExportTr34KeyBlock.setter(Builder::keyBlockFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyBlockFormat").build()}).build();
    private static final SdkField<String> RANDOM_NONCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RandomNonce").getter(ExportTr34KeyBlock.getter(ExportTr34KeyBlock::randomNonce)).setter(ExportTr34KeyBlock.setter(Builder::randomNonce)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RandomNonce").build()}).build();
    private static final SdkField<KeyBlockHeaders> KEY_BLOCK_HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KeyBlockHeaders").getter(ExportTr34KeyBlock.getter(ExportTr34KeyBlock::keyBlockHeaders)).setter(ExportTr34KeyBlock.setter(Builder::keyBlockHeaders)).constructor(KeyBlockHeaders::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyBlockHeaders").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_AUTHORITY_PUBLIC_KEY_IDENTIFIER_FIELD, WRAPPING_KEY_CERTIFICATE_FIELD, EXPORT_TOKEN_FIELD, SIGNING_KEY_IDENTIFIER_FIELD, SIGNING_KEY_CERTIFICATE_FIELD, KEY_BLOCK_FORMAT_FIELD, RANDOM_NONCE_FIELD, KEY_BLOCK_HEADERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExportTr34KeyBlock.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String certificateAuthorityPublicKeyIdentifier;
    private final String wrappingKeyCertificate;
    private final String exportToken;
    private final String signingKeyIdentifier;
    private final String signingKeyCertificate;
    private final String keyBlockFormat;
    private final String randomNonce;
    private final KeyBlockHeaders keyBlockHeaders;

    private ExportTr34KeyBlock(BuilderImpl builder) {
        this.certificateAuthorityPublicKeyIdentifier = builder.certificateAuthorityPublicKeyIdentifier;
        this.wrappingKeyCertificate = builder.wrappingKeyCertificate;
        this.exportToken = builder.exportToken;
        this.signingKeyIdentifier = builder.signingKeyIdentifier;
        this.signingKeyCertificate = builder.signingKeyCertificate;
        this.keyBlockFormat = builder.keyBlockFormat;
        this.randomNonce = builder.randomNonce;
        this.keyBlockHeaders = builder.keyBlockHeaders;
    }

    public final String certificateAuthorityPublicKeyIdentifier() {
        return this.certificateAuthorityPublicKeyIdentifier;
    }

    public final String wrappingKeyCertificate() {
        return this.wrappingKeyCertificate;
    }

    public final String exportToken() {
        return this.exportToken;
    }

    public final String signingKeyIdentifier() {
        return this.signingKeyIdentifier;
    }

    public final String signingKeyCertificate() {
        return this.signingKeyCertificate;
    }

    public final Tr34KeyBlockFormat keyBlockFormat() {
        return Tr34KeyBlockFormat.fromValue(this.keyBlockFormat);
    }

    public final String keyBlockFormatAsString() {
        return this.keyBlockFormat;
    }

    public final String randomNonce() {
        return this.randomNonce;
    }

    public final KeyBlockHeaders keyBlockHeaders() {
        return this.keyBlockHeaders;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateAuthorityPublicKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.wrappingKeyCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingKeyCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyBlockFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.randomNonce());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyBlockHeaders());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportTr34KeyBlock)) {
            return false;
        }
        ExportTr34KeyBlock other = (ExportTr34KeyBlock)obj;
        return Objects.equals(this.certificateAuthorityPublicKeyIdentifier(), other.certificateAuthorityPublicKeyIdentifier()) && Objects.equals(this.wrappingKeyCertificate(), other.wrappingKeyCertificate()) && Objects.equals(this.exportToken(), other.exportToken()) && Objects.equals(this.signingKeyIdentifier(), other.signingKeyIdentifier()) && Objects.equals(this.signingKeyCertificate(), other.signingKeyCertificate()) && Objects.equals(this.keyBlockFormatAsString(), other.keyBlockFormatAsString()) && Objects.equals(this.randomNonce(), other.randomNonce()) && Objects.equals(this.keyBlockHeaders(), other.keyBlockHeaders());
    }

    public final String toString() {
        return ToString.builder((String)"ExportTr34KeyBlock").add("CertificateAuthorityPublicKeyIdentifier", (Object)this.certificateAuthorityPublicKeyIdentifier()).add("WrappingKeyCertificate", (Object)this.wrappingKeyCertificate()).add("ExportToken", (Object)this.exportToken()).add("SigningKeyIdentifier", (Object)this.signingKeyIdentifier()).add("SigningKeyCertificate", (Object)this.signingKeyCertificate()).add("KeyBlockFormat", (Object)this.keyBlockFormatAsString()).add("RandomNonce", (Object)this.randomNonce()).add("KeyBlockHeaders", (Object)this.keyBlockHeaders()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateAuthorityPublicKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.certificateAuthorityPublicKeyIdentifier()));
            }
            case "WrappingKeyCertificate": {
                return Optional.ofNullable(clazz.cast(this.wrappingKeyCertificate()));
            }
            case "ExportToken": {
                return Optional.ofNullable(clazz.cast(this.exportToken()));
            }
            case "SigningKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.signingKeyIdentifier()));
            }
            case "SigningKeyCertificate": {
                return Optional.ofNullable(clazz.cast(this.signingKeyCertificate()));
            }
            case "KeyBlockFormat": {
                return Optional.ofNullable(clazz.cast(this.keyBlockFormatAsString()));
            }
            case "RandomNonce": {
                return Optional.ofNullable(clazz.cast(this.randomNonce()));
            }
            case "KeyBlockHeaders": {
                return Optional.ofNullable(clazz.cast(this.keyBlockHeaders()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CertificateAuthorityPublicKeyIdentifier", CERTIFICATE_AUTHORITY_PUBLIC_KEY_IDENTIFIER_FIELD);
        map.put("WrappingKeyCertificate", WRAPPING_KEY_CERTIFICATE_FIELD);
        map.put("ExportToken", EXPORT_TOKEN_FIELD);
        map.put("SigningKeyIdentifier", SIGNING_KEY_IDENTIFIER_FIELD);
        map.put("SigningKeyCertificate", SIGNING_KEY_CERTIFICATE_FIELD);
        map.put("KeyBlockFormat", KEY_BLOCK_FORMAT_FIELD);
        map.put("RandomNonce", RANDOM_NONCE_FIELD);
        map.put("KeyBlockHeaders", KEY_BLOCK_HEADERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportTr34KeyBlock, T> g) {
        return obj -> g.apply((ExportTr34KeyBlock)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateAuthorityPublicKeyIdentifier;
        private String wrappingKeyCertificate;
        private String exportToken;
        private String signingKeyIdentifier;
        private String signingKeyCertificate;
        private String keyBlockFormat;
        private String randomNonce;
        private KeyBlockHeaders keyBlockHeaders;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportTr34KeyBlock model) {
            this.certificateAuthorityPublicKeyIdentifier(model.certificateAuthorityPublicKeyIdentifier);
            this.wrappingKeyCertificate(model.wrappingKeyCertificate);
            this.exportToken(model.exportToken);
            this.signingKeyIdentifier(model.signingKeyIdentifier);
            this.signingKeyCertificate(model.signingKeyCertificate);
            this.keyBlockFormat(model.keyBlockFormat);
            this.randomNonce(model.randomNonce);
            this.keyBlockHeaders(model.keyBlockHeaders);
        }

        public final String getCertificateAuthorityPublicKeyIdentifier() {
            return this.certificateAuthorityPublicKeyIdentifier;
        }

        public final void setCertificateAuthorityPublicKeyIdentifier(String certificateAuthorityPublicKeyIdentifier) {
            this.certificateAuthorityPublicKeyIdentifier = certificateAuthorityPublicKeyIdentifier;
        }

        @Override
        public final Builder certificateAuthorityPublicKeyIdentifier(String certificateAuthorityPublicKeyIdentifier) {
            this.certificateAuthorityPublicKeyIdentifier = certificateAuthorityPublicKeyIdentifier;
            return this;
        }

        public final String getWrappingKeyCertificate() {
            return this.wrappingKeyCertificate;
        }

        public final void setWrappingKeyCertificate(String wrappingKeyCertificate) {
            this.wrappingKeyCertificate = wrappingKeyCertificate;
        }

        @Override
        public final Builder wrappingKeyCertificate(String wrappingKeyCertificate) {
            this.wrappingKeyCertificate = wrappingKeyCertificate;
            return this;
        }

        public final String getExportToken() {
            return this.exportToken;
        }

        public final void setExportToken(String exportToken) {
            this.exportToken = exportToken;
        }

        @Override
        public final Builder exportToken(String exportToken) {
            this.exportToken = exportToken;
            return this;
        }

        public final String getSigningKeyIdentifier() {
            return this.signingKeyIdentifier;
        }

        public final void setSigningKeyIdentifier(String signingKeyIdentifier) {
            this.signingKeyIdentifier = signingKeyIdentifier;
        }

        @Override
        public final Builder signingKeyIdentifier(String signingKeyIdentifier) {
            this.signingKeyIdentifier = signingKeyIdentifier;
            return this;
        }

        public final String getSigningKeyCertificate() {
            return this.signingKeyCertificate;
        }

        public final void setSigningKeyCertificate(String signingKeyCertificate) {
            this.signingKeyCertificate = signingKeyCertificate;
        }

        @Override
        public final Builder signingKeyCertificate(String signingKeyCertificate) {
            this.signingKeyCertificate = signingKeyCertificate;
            return this;
        }

        public final String getKeyBlockFormat() {
            return this.keyBlockFormat;
        }

        public final void setKeyBlockFormat(String keyBlockFormat) {
            this.keyBlockFormat = keyBlockFormat;
        }

        @Override
        public final Builder keyBlockFormat(String keyBlockFormat) {
            this.keyBlockFormat = keyBlockFormat;
            return this;
        }

        @Override
        public final Builder keyBlockFormat(Tr34KeyBlockFormat keyBlockFormat) {
            this.keyBlockFormat(keyBlockFormat == null ? null : keyBlockFormat.toString());
            return this;
        }

        public final String getRandomNonce() {
            return this.randomNonce;
        }

        public final void setRandomNonce(String randomNonce) {
            this.randomNonce = randomNonce;
        }

        @Override
        public final Builder randomNonce(String randomNonce) {
            this.randomNonce = randomNonce;
            return this;
        }

        public final KeyBlockHeaders.Builder getKeyBlockHeaders() {
            return this.keyBlockHeaders != null ? this.keyBlockHeaders.toBuilder() : null;
        }

        public final void setKeyBlockHeaders(KeyBlockHeaders.BuilderImpl keyBlockHeaders) {
            this.keyBlockHeaders = keyBlockHeaders != null ? keyBlockHeaders.build() : null;
        }

        @Override
        public final Builder keyBlockHeaders(KeyBlockHeaders keyBlockHeaders) {
            this.keyBlockHeaders = keyBlockHeaders;
            return this;
        }

        public ExportTr34KeyBlock build() {
            return new ExportTr34KeyBlock(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportTr34KeyBlock> {
        public Builder certificateAuthorityPublicKeyIdentifier(String var1);

        public Builder wrappingKeyCertificate(String var1);

        public Builder exportToken(String var1);

        public Builder signingKeyIdentifier(String var1);

        public Builder signingKeyCertificate(String var1);

        public Builder keyBlockFormat(String var1);

        public Builder keyBlockFormat(Tr34KeyBlockFormat var1);

        public Builder randomNonce(String var1);

        public Builder keyBlockHeaders(KeyBlockHeaders var1);

        default public Builder keyBlockHeaders(Consumer<KeyBlockHeaders.Builder> keyBlockHeaders) {
            return this.keyBlockHeaders((KeyBlockHeaders)((KeyBlockHeaders.Builder)KeyBlockHeaders.builder().applyMutation(keyBlockHeaders)).build());
        }
    }
}

