/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptography.model.PaymentCryptographyResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPublicKeyCertificateResponse
extends PaymentCryptographyResponse
implements ToCopyableBuilder<Builder, GetPublicKeyCertificateResponse> {
    private static final SdkField<String> KEY_CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyCertificate").getter(GetPublicKeyCertificateResponse.getter(GetPublicKeyCertificateResponse::keyCertificate)).setter(GetPublicKeyCertificateResponse.setter(Builder::keyCertificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyCertificate").build()}).build();
    private static final SdkField<String> KEY_CERTIFICATE_CHAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyCertificateChain").getter(GetPublicKeyCertificateResponse.getter(GetPublicKeyCertificateResponse::keyCertificateChain)).setter(GetPublicKeyCertificateResponse.setter(Builder::keyCertificateChain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyCertificateChain").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_CERTIFICATE_FIELD, KEY_CERTIFICATE_CHAIN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetPublicKeyCertificateResponse.memberNameToFieldInitializer();
    private final String keyCertificate;
    private final String keyCertificateChain;

    private GetPublicKeyCertificateResponse(BuilderImpl builder) {
        super(builder);
        this.keyCertificate = builder.keyCertificate;
        this.keyCertificateChain = builder.keyCertificateChain;
    }

    public final String keyCertificate() {
        return this.keyCertificate;
    }

    public final String keyCertificateChain() {
        return this.keyCertificateChain;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyCertificateChain());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPublicKeyCertificateResponse)) {
            return false;
        }
        GetPublicKeyCertificateResponse other = (GetPublicKeyCertificateResponse)((Object)obj);
        return Objects.equals(this.keyCertificate(), other.keyCertificate()) && Objects.equals(this.keyCertificateChain(), other.keyCertificateChain());
    }

    public final String toString() {
        return ToString.builder((String)"GetPublicKeyCertificateResponse").add("KeyCertificate", (Object)(this.keyCertificate() == null ? null : "*** Sensitive Data Redacted ***")).add("KeyCertificateChain", (Object)(this.keyCertificateChain() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyCertificate": {
                return Optional.ofNullable(clazz.cast(this.keyCertificate()));
            }
            case "KeyCertificateChain": {
                return Optional.ofNullable(clazz.cast(this.keyCertificateChain()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("KeyCertificate", KEY_CERTIFICATE_FIELD);
        map.put("KeyCertificateChain", KEY_CERTIFICATE_CHAIN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPublicKeyCertificateResponse, T> g) {
        return obj -> g.apply((GetPublicKeyCertificateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PaymentCryptographyResponse.BuilderImpl
    implements Builder {
        private String keyCertificate;
        private String keyCertificateChain;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPublicKeyCertificateResponse model) {
            super(model);
            this.keyCertificate(model.keyCertificate);
            this.keyCertificateChain(model.keyCertificateChain);
        }

        public final String getKeyCertificate() {
            return this.keyCertificate;
        }

        public final void setKeyCertificate(String keyCertificate) {
            this.keyCertificate = keyCertificate;
        }

        @Override
        public final Builder keyCertificate(String keyCertificate) {
            this.keyCertificate = keyCertificate;
            return this;
        }

        public final String getKeyCertificateChain() {
            return this.keyCertificateChain;
        }

        public final void setKeyCertificateChain(String keyCertificateChain) {
            this.keyCertificateChain = keyCertificateChain;
        }

        @Override
        public final Builder keyCertificateChain(String keyCertificateChain) {
            this.keyCertificateChain = keyCertificateChain;
            return this;
        }

        @Override
        public GetPublicKeyCertificateResponse build() {
            return new GetPublicKeyCertificateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PaymentCryptographyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPublicKeyCertificateResponse> {
        public Builder keyCertificate(String var1);

        public Builder keyCertificateChain(String var1);
    }
}

