/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptography.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetParametersForExportResponse extends PaymentCryptographyResponse implements
        ToCopyableBuilder<GetParametersForExportResponse.Builder, GetParametersForExportResponse> {
    private static final SdkField<String> EXPORT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportToken").getter(getter(GetParametersForExportResponse::exportToken))
            .setter(setter(Builder::exportToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportToken").build()).build();

    private static final SdkField<Instant> PARAMETERS_VALID_UNTIL_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ParametersValidUntilTimestamp")
            .getter(getter(GetParametersForExportResponse::parametersValidUntilTimestamp))
            .setter(setter(Builder::parametersValidUntilTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParametersValidUntilTimestamp")
                    .build()).build();

    private static final SdkField<String> SIGNING_KEY_ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SigningKeyAlgorithm").getter(getter(GetParametersForExportResponse::signingKeyAlgorithmAsString))
            .setter(setter(Builder::signingKeyAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningKeyAlgorithm").build())
            .build();

    private static final SdkField<String> SIGNING_KEY_CERTIFICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SigningKeyCertificate").getter(getter(GetParametersForExportResponse::signingKeyCertificate))
            .setter(setter(Builder::signingKeyCertificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningKeyCertificate").build())
            .build();

    private static final SdkField<String> SIGNING_KEY_CERTIFICATE_CHAIN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SigningKeyCertificateChain")
            .getter(getter(GetParametersForExportResponse::signingKeyCertificateChain))
            .setter(setter(Builder::signingKeyCertificateChain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningKeyCertificateChain").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_TOKEN_FIELD,
            PARAMETERS_VALID_UNTIL_TIMESTAMP_FIELD, SIGNING_KEY_ALGORITHM_FIELD, SIGNING_KEY_CERTIFICATE_FIELD,
            SIGNING_KEY_CERTIFICATE_CHAIN_FIELD));

    private final String exportToken;

    private final Instant parametersValidUntilTimestamp;

    private final String signingKeyAlgorithm;

    private final String signingKeyCertificate;

    private final String signingKeyCertificateChain;

    private GetParametersForExportResponse(BuilderImpl builder) {
        super(builder);
        this.exportToken = builder.exportToken;
        this.parametersValidUntilTimestamp = builder.parametersValidUntilTimestamp;
        this.signingKeyAlgorithm = builder.signingKeyAlgorithm;
        this.signingKeyCertificate = builder.signingKeyCertificate;
        this.signingKeyCertificateChain = builder.signingKeyCertificateChain;
    }

    /**
     * <p>
     * The export token to initiate key export from Amazon Web Services Payment Cryptography. The export token expires
     * after 7 days. You can use the same export token to export multiple keys from the same service account.
     * </p>
     * 
     * @return The export token to initiate key export from Amazon Web Services Payment Cryptography. The export token
     *         expires after 7 days. You can use the same export token to export multiple keys from the same service
     *         account.
     */
    public final String exportToken() {
        return exportToken;
    }

    /**
     * <p>
     * The validity period of the export token.
     * </p>
     * 
     * @return The validity period of the export token.
     */
    public final Instant parametersValidUntilTimestamp() {
        return parametersValidUntilTimestamp;
    }

    /**
     * <p>
     * The algorithm of the signing key certificate for use in TR-34 key block generation. <code>RSA_2048</code> is the
     * only signing key algorithm allowed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #signingKeyAlgorithm} will return {@link KeyAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #signingKeyAlgorithmAsString}.
     * </p>
     * 
     * @return The algorithm of the signing key certificate for use in TR-34 key block generation. <code>RSA_2048</code>
     *         is the only signing key algorithm allowed.
     * @see KeyAlgorithm
     */
    public final KeyAlgorithm signingKeyAlgorithm() {
        return KeyAlgorithm.fromValue(signingKeyAlgorithm);
    }

    /**
     * <p>
     * The algorithm of the signing key certificate for use in TR-34 key block generation. <code>RSA_2048</code> is the
     * only signing key algorithm allowed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #signingKeyAlgorithm} will return {@link KeyAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #signingKeyAlgorithmAsString}.
     * </p>
     * 
     * @return The algorithm of the signing key certificate for use in TR-34 key block generation. <code>RSA_2048</code>
     *         is the only signing key algorithm allowed.
     * @see KeyAlgorithm
     */
    public final String signingKeyAlgorithmAsString() {
        return signingKeyAlgorithm;
    }

    /**
     * <p>
     * The signing key certificate of the public key for signature within the TR-34 key block cryptogram. The
     * certificate expires after 7 days.
     * </p>
     * 
     * @return The signing key certificate of the public key for signature within the TR-34 key block cryptogram. The
     *         certificate expires after 7 days.
     */
    public final String signingKeyCertificate() {
        return signingKeyCertificate;
    }

    /**
     * <p>
     * The certificate chain that signed the signing key certificate. This is the root certificate authority (CA) within
     * your service account.
     * </p>
     * 
     * @return The certificate chain that signed the signing key certificate. This is the root certificate authority
     *         (CA) within your service account.
     */
    public final String signingKeyCertificateChain() {
        return signingKeyCertificateChain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(exportToken());
        hashCode = 31 * hashCode + Objects.hashCode(parametersValidUntilTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(signingKeyAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(signingKeyCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(signingKeyCertificateChain());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParametersForExportResponse)) {
            return false;
        }
        GetParametersForExportResponse other = (GetParametersForExportResponse) obj;
        return Objects.equals(exportToken(), other.exportToken())
                && Objects.equals(parametersValidUntilTimestamp(), other.parametersValidUntilTimestamp())
                && Objects.equals(signingKeyAlgorithmAsString(), other.signingKeyAlgorithmAsString())
                && Objects.equals(signingKeyCertificate(), other.signingKeyCertificate())
                && Objects.equals(signingKeyCertificateChain(), other.signingKeyCertificateChain());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("GetParametersForExportResponse")
                .add("ExportToken", exportToken())
                .add("ParametersValidUntilTimestamp", parametersValidUntilTimestamp())
                .add("SigningKeyAlgorithm", signingKeyAlgorithmAsString())
                .add("SigningKeyCertificate", signingKeyCertificate() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SigningKeyCertificateChain",
                        signingKeyCertificateChain() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExportToken":
            return Optional.ofNullable(clazz.cast(exportToken()));
        case "ParametersValidUntilTimestamp":
            return Optional.ofNullable(clazz.cast(parametersValidUntilTimestamp()));
        case "SigningKeyAlgorithm":
            return Optional.ofNullable(clazz.cast(signingKeyAlgorithmAsString()));
        case "SigningKeyCertificate":
            return Optional.ofNullable(clazz.cast(signingKeyCertificate()));
        case "SigningKeyCertificateChain":
            return Optional.ofNullable(clazz.cast(signingKeyCertificateChain()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetParametersForExportResponse, T> g) {
        return obj -> g.apply((GetParametersForExportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PaymentCryptographyResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetParametersForExportResponse> {
        /**
         * <p>
         * The export token to initiate key export from Amazon Web Services Payment Cryptography. The export token
         * expires after 7 days. You can use the same export token to export multiple keys from the same service
         * account.
         * </p>
         * 
         * @param exportToken
         *        The export token to initiate key export from Amazon Web Services Payment Cryptography. The export
         *        token expires after 7 days. You can use the same export token to export multiple keys from the same
         *        service account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportToken(String exportToken);

        /**
         * <p>
         * The validity period of the export token.
         * </p>
         * 
         * @param parametersValidUntilTimestamp
         *        The validity period of the export token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parametersValidUntilTimestamp(Instant parametersValidUntilTimestamp);

        /**
         * <p>
         * The algorithm of the signing key certificate for use in TR-34 key block generation. <code>RSA_2048</code> is
         * the only signing key algorithm allowed.
         * </p>
         * 
         * @param signingKeyAlgorithm
         *        The algorithm of the signing key certificate for use in TR-34 key block generation.
         *        <code>RSA_2048</code> is the only signing key algorithm allowed.
         * @see KeyAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyAlgorithm
         */
        Builder signingKeyAlgorithm(String signingKeyAlgorithm);

        /**
         * <p>
         * The algorithm of the signing key certificate for use in TR-34 key block generation. <code>RSA_2048</code> is
         * the only signing key algorithm allowed.
         * </p>
         * 
         * @param signingKeyAlgorithm
         *        The algorithm of the signing key certificate for use in TR-34 key block generation.
         *        <code>RSA_2048</code> is the only signing key algorithm allowed.
         * @see KeyAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyAlgorithm
         */
        Builder signingKeyAlgorithm(KeyAlgorithm signingKeyAlgorithm);

        /**
         * <p>
         * The signing key certificate of the public key for signature within the TR-34 key block cryptogram. The
         * certificate expires after 7 days.
         * </p>
         * 
         * @param signingKeyCertificate
         *        The signing key certificate of the public key for signature within the TR-34 key block cryptogram. The
         *        certificate expires after 7 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingKeyCertificate(String signingKeyCertificate);

        /**
         * <p>
         * The certificate chain that signed the signing key certificate. This is the root certificate authority (CA)
         * within your service account.
         * </p>
         * 
         * @param signingKeyCertificateChain
         *        The certificate chain that signed the signing key certificate. This is the root certificate authority
         *        (CA) within your service account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingKeyCertificateChain(String signingKeyCertificateChain);
    }

    static final class BuilderImpl extends PaymentCryptographyResponse.BuilderImpl implements Builder {
        private String exportToken;

        private Instant parametersValidUntilTimestamp;

        private String signingKeyAlgorithm;

        private String signingKeyCertificate;

        private String signingKeyCertificateChain;

        private BuilderImpl() {
        }

        private BuilderImpl(GetParametersForExportResponse model) {
            super(model);
            exportToken(model.exportToken);
            parametersValidUntilTimestamp(model.parametersValidUntilTimestamp);
            signingKeyAlgorithm(model.signingKeyAlgorithm);
            signingKeyCertificate(model.signingKeyCertificate);
            signingKeyCertificateChain(model.signingKeyCertificateChain);
        }

        public final String getExportToken() {
            return exportToken;
        }

        public final void setExportToken(String exportToken) {
            this.exportToken = exportToken;
        }

        @Override
        public final Builder exportToken(String exportToken) {
            this.exportToken = exportToken;
            return this;
        }

        public final Instant getParametersValidUntilTimestamp() {
            return parametersValidUntilTimestamp;
        }

        public final void setParametersValidUntilTimestamp(Instant parametersValidUntilTimestamp) {
            this.parametersValidUntilTimestamp = parametersValidUntilTimestamp;
        }

        @Override
        public final Builder parametersValidUntilTimestamp(Instant parametersValidUntilTimestamp) {
            this.parametersValidUntilTimestamp = parametersValidUntilTimestamp;
            return this;
        }

        public final String getSigningKeyAlgorithm() {
            return signingKeyAlgorithm;
        }

        public final void setSigningKeyAlgorithm(String signingKeyAlgorithm) {
            this.signingKeyAlgorithm = signingKeyAlgorithm;
        }

        @Override
        public final Builder signingKeyAlgorithm(String signingKeyAlgorithm) {
            this.signingKeyAlgorithm = signingKeyAlgorithm;
            return this;
        }

        @Override
        public final Builder signingKeyAlgorithm(KeyAlgorithm signingKeyAlgorithm) {
            this.signingKeyAlgorithm(signingKeyAlgorithm == null ? null : signingKeyAlgorithm.toString());
            return this;
        }

        public final String getSigningKeyCertificate() {
            return signingKeyCertificate;
        }

        public final void setSigningKeyCertificate(String signingKeyCertificate) {
            this.signingKeyCertificate = signingKeyCertificate;
        }

        @Override
        public final Builder signingKeyCertificate(String signingKeyCertificate) {
            this.signingKeyCertificate = signingKeyCertificate;
            return this;
        }

        public final String getSigningKeyCertificateChain() {
            return signingKeyCertificateChain;
        }

        public final void setSigningKeyCertificateChain(String signingKeyCertificateChain) {
            this.signingKeyCertificateChain = signingKeyCertificateChain;
        }

        @Override
        public final Builder signingKeyCertificateChain(String signingKeyCertificateChain) {
            this.signingKeyCertificateChain = signingKeyCertificateChain;
            return this;
        }

        @Override
        public GetParametersForExportResponse build() {
            return new GetParametersForExportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
