/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralselling.model.AwsAccountListCopier;
import software.amazon.awssdk.services.partnercentralselling.model.EngagementContextType;
import software.amazon.awssdk.services.partnercentralselling.model.EngagementContextTypeListCopier;
import software.amazon.awssdk.services.partnercentralselling.model.EngagementIdentifiersCopier;
import software.amazon.awssdk.services.partnercentralselling.model.EngagementSort;
import software.amazon.awssdk.services.partnercentralselling.model.PartnerCentralSellingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEngagementsRequest
extends PartnerCentralSellingRequest
implements ToCopyableBuilder<Builder, ListEngagementsRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(ListEngagementsRequest.getter(ListEngagementsRequest::catalog)).setter(ListEngagementsRequest.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<List<String>> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CreatedBy").getter(ListEngagementsRequest.getter(ListEngagementsRequest::createdBy)).setter(ListEngagementsRequest.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUDE_CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludeCreatedBy").getter(ListEngagementsRequest.getter(ListEngagementsRequest::excludeCreatedBy)).setter(ListEngagementsRequest.setter(Builder::excludeCreatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeCreatedBy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CONTEXT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContextTypes").getter(ListEngagementsRequest.getter(ListEngagementsRequest::contextTypesAsStrings)).setter(ListEngagementsRequest.setter(Builder::contextTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUDE_CONTEXT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludeContextTypes").getter(ListEngagementsRequest.getter(ListEngagementsRequest::excludeContextTypesAsStrings)).setter(ListEngagementsRequest.setter(Builder::excludeContextTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeContextTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EngagementSort> SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Sort").getter(ListEngagementsRequest.getter(ListEngagementsRequest::sort)).setter(ListEngagementsRequest.setter(Builder::sort)).constructor(EngagementSort::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sort").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListEngagementsRequest.getter(ListEngagementsRequest::maxResults)).setter(ListEngagementsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListEngagementsRequest.getter(ListEngagementsRequest::nextToken)).setter(ListEngagementsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<String>> ENGAGEMENT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EngagementIdentifier").getter(ListEngagementsRequest.getter(ListEngagementsRequest::engagementIdentifier)).setter(ListEngagementsRequest.setter(Builder::engagementIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementIdentifier").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, CREATED_BY_FIELD, EXCLUDE_CREATED_BY_FIELD, CONTEXT_TYPES_FIELD, EXCLUDE_CONTEXT_TYPES_FIELD, SORT_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, ENGAGEMENT_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEngagementsRequest.memberNameToFieldInitializer();
    private final String catalog;
    private final List<String> createdBy;
    private final List<String> excludeCreatedBy;
    private final List<String> contextTypes;
    private final List<String> excludeContextTypes;
    private final EngagementSort sort;
    private final Integer maxResults;
    private final String nextToken;
    private final List<String> engagementIdentifier;

    private ListEngagementsRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.createdBy = builder.createdBy;
        this.excludeCreatedBy = builder.excludeCreatedBy;
        this.contextTypes = builder.contextTypes;
        this.excludeContextTypes = builder.excludeContextTypes;
        this.sort = builder.sort;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.engagementIdentifier = builder.engagementIdentifier;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final boolean hasCreatedBy() {
        return this.createdBy != null && !(this.createdBy instanceof SdkAutoConstructList);
    }

    public final List<String> createdBy() {
        return this.createdBy;
    }

    public final boolean hasExcludeCreatedBy() {
        return this.excludeCreatedBy != null && !(this.excludeCreatedBy instanceof SdkAutoConstructList);
    }

    public final List<String> excludeCreatedBy() {
        return this.excludeCreatedBy;
    }

    public final List<EngagementContextType> contextTypes() {
        return EngagementContextTypeListCopier.copyStringToEnum(this.contextTypes);
    }

    public final boolean hasContextTypes() {
        return this.contextTypes != null && !(this.contextTypes instanceof SdkAutoConstructList);
    }

    public final List<String> contextTypesAsStrings() {
        return this.contextTypes;
    }

    public final List<EngagementContextType> excludeContextTypes() {
        return EngagementContextTypeListCopier.copyStringToEnum(this.excludeContextTypes);
    }

    public final boolean hasExcludeContextTypes() {
        return this.excludeContextTypes != null && !(this.excludeContextTypes instanceof SdkAutoConstructList);
    }

    public final List<String> excludeContextTypesAsStrings() {
        return this.excludeContextTypes;
    }

    public final EngagementSort sort() {
        return this.sort;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasEngagementIdentifier() {
        return this.engagementIdentifier != null && !(this.engagementIdentifier instanceof SdkAutoConstructList);
    }

    public final List<String> engagementIdentifier() {
        return this.engagementIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCreatedBy() ? this.createdBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludeCreatedBy() ? this.excludeCreatedBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContextTypes() ? this.contextTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludeContextTypes() ? this.excludeContextTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sort());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEngagementIdentifier() ? this.engagementIdentifier() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEngagementsRequest)) {
            return false;
        }
        ListEngagementsRequest other = (ListEngagementsRequest)((Object)obj);
        return Objects.equals(this.catalog(), other.catalog()) && this.hasCreatedBy() == other.hasCreatedBy() && Objects.equals(this.createdBy(), other.createdBy()) && this.hasExcludeCreatedBy() == other.hasExcludeCreatedBy() && Objects.equals(this.excludeCreatedBy(), other.excludeCreatedBy()) && this.hasContextTypes() == other.hasContextTypes() && Objects.equals(this.contextTypesAsStrings(), other.contextTypesAsStrings()) && this.hasExcludeContextTypes() == other.hasExcludeContextTypes() && Objects.equals(this.excludeContextTypesAsStrings(), other.excludeContextTypesAsStrings()) && Objects.equals(this.sort(), other.sort()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasEngagementIdentifier() == other.hasEngagementIdentifier() && Objects.equals(this.engagementIdentifier(), other.engagementIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"ListEngagementsRequest").add("Catalog", (Object)this.catalog()).add("CreatedBy", (Object)(this.createdBy() == null ? null : "*** Sensitive Data Redacted ***")).add("ExcludeCreatedBy", (Object)(this.excludeCreatedBy() == null ? null : "*** Sensitive Data Redacted ***")).add("ContextTypes", this.hasContextTypes() ? this.contextTypesAsStrings() : null).add("ExcludeContextTypes", this.hasExcludeContextTypes() ? this.excludeContextTypesAsStrings() : null).add("Sort", (Object)this.sort()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("EngagementIdentifier", this.hasEngagementIdentifier() ? this.engagementIdentifier() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "ExcludeCreatedBy": {
                return Optional.ofNullable(clazz.cast(this.excludeCreatedBy()));
            }
            case "ContextTypes": {
                return Optional.ofNullable(clazz.cast(this.contextTypesAsStrings()));
            }
            case "ExcludeContextTypes": {
                return Optional.ofNullable(clazz.cast(this.excludeContextTypesAsStrings()));
            }
            case "Sort": {
                return Optional.ofNullable(clazz.cast(this.sort()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "EngagementIdentifier": {
                return Optional.ofNullable(clazz.cast(this.engagementIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("ExcludeCreatedBy", EXCLUDE_CREATED_BY_FIELD);
        map.put("ContextTypes", CONTEXT_TYPES_FIELD);
        map.put("ExcludeContextTypes", EXCLUDE_CONTEXT_TYPES_FIELD);
        map.put("Sort", SORT_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("EngagementIdentifier", ENGAGEMENT_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEngagementsRequest, T> g) {
        return obj -> g.apply((ListEngagementsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralSellingRequest.BuilderImpl
    implements Builder {
        private String catalog;
        private List<String> createdBy = DefaultSdkAutoConstructList.getInstance();
        private List<String> excludeCreatedBy = DefaultSdkAutoConstructList.getInstance();
        private List<String> contextTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> excludeContextTypes = DefaultSdkAutoConstructList.getInstance();
        private EngagementSort sort;
        private Integer maxResults;
        private String nextToken;
        private List<String> engagementIdentifier = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEngagementsRequest model) {
            super(model);
            this.catalog(model.catalog);
            this.createdBy(model.createdBy);
            this.excludeCreatedBy(model.excludeCreatedBy);
            this.contextTypesWithStrings(model.contextTypes);
            this.excludeContextTypesWithStrings(model.excludeContextTypes);
            this.sort(model.sort);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.engagementIdentifier(model.engagementIdentifier);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final Collection<String> getCreatedBy() {
            if (this.createdBy instanceof SdkAutoConstructList) {
                return null;
            }
            return this.createdBy;
        }

        public final void setCreatedBy(Collection<String> createdBy) {
            this.createdBy = AwsAccountListCopier.copy(createdBy);
        }

        @Override
        public final Builder createdBy(Collection<String> createdBy) {
            this.createdBy = AwsAccountListCopier.copy(createdBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createdBy(String ... createdBy) {
            this.createdBy(Arrays.asList(createdBy));
            return this;
        }

        public final Collection<String> getExcludeCreatedBy() {
            if (this.excludeCreatedBy instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludeCreatedBy;
        }

        public final void setExcludeCreatedBy(Collection<String> excludeCreatedBy) {
            this.excludeCreatedBy = AwsAccountListCopier.copy(excludeCreatedBy);
        }

        @Override
        public final Builder excludeCreatedBy(Collection<String> excludeCreatedBy) {
            this.excludeCreatedBy = AwsAccountListCopier.copy(excludeCreatedBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeCreatedBy(String ... excludeCreatedBy) {
            this.excludeCreatedBy(Arrays.asList(excludeCreatedBy));
            return this;
        }

        public final Collection<String> getContextTypes() {
            if (this.contextTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.contextTypes;
        }

        public final void setContextTypes(Collection<String> contextTypes) {
            this.contextTypes = EngagementContextTypeListCopier.copy(contextTypes);
        }

        @Override
        public final Builder contextTypesWithStrings(Collection<String> contextTypes) {
            this.contextTypes = EngagementContextTypeListCopier.copy(contextTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contextTypesWithStrings(String ... contextTypes) {
            this.contextTypesWithStrings(Arrays.asList(contextTypes));
            return this;
        }

        @Override
        public final Builder contextTypes(Collection<EngagementContextType> contextTypes) {
            this.contextTypes = EngagementContextTypeListCopier.copyEnumToString(contextTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contextTypes(EngagementContextType ... contextTypes) {
            this.contextTypes(Arrays.asList(contextTypes));
            return this;
        }

        public final Collection<String> getExcludeContextTypes() {
            if (this.excludeContextTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludeContextTypes;
        }

        public final void setExcludeContextTypes(Collection<String> excludeContextTypes) {
            this.excludeContextTypes = EngagementContextTypeListCopier.copy(excludeContextTypes);
        }

        @Override
        public final Builder excludeContextTypesWithStrings(Collection<String> excludeContextTypes) {
            this.excludeContextTypes = EngagementContextTypeListCopier.copy(excludeContextTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeContextTypesWithStrings(String ... excludeContextTypes) {
            this.excludeContextTypesWithStrings(Arrays.asList(excludeContextTypes));
            return this;
        }

        @Override
        public final Builder excludeContextTypes(Collection<EngagementContextType> excludeContextTypes) {
            this.excludeContextTypes = EngagementContextTypeListCopier.copyEnumToString(excludeContextTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeContextTypes(EngagementContextType ... excludeContextTypes) {
            this.excludeContextTypes(Arrays.asList(excludeContextTypes));
            return this;
        }

        public final EngagementSort.Builder getSort() {
            return this.sort != null ? this.sort.toBuilder() : null;
        }

        public final void setSort(EngagementSort.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        public final Builder sort(EngagementSort sort) {
            this.sort = sort;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getEngagementIdentifier() {
            if (this.engagementIdentifier instanceof SdkAutoConstructList) {
                return null;
            }
            return this.engagementIdentifier;
        }

        public final void setEngagementIdentifier(Collection<String> engagementIdentifier) {
            this.engagementIdentifier = EngagementIdentifiersCopier.copy(engagementIdentifier);
        }

        @Override
        public final Builder engagementIdentifier(Collection<String> engagementIdentifier) {
            this.engagementIdentifier = EngagementIdentifiersCopier.copy(engagementIdentifier);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engagementIdentifier(String ... engagementIdentifier) {
            this.engagementIdentifier(Arrays.asList(engagementIdentifier));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEngagementsRequest build() {
            return new ListEngagementsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralSellingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEngagementsRequest> {
        public Builder catalog(String var1);

        public Builder createdBy(Collection<String> var1);

        public Builder createdBy(String ... var1);

        public Builder excludeCreatedBy(Collection<String> var1);

        public Builder excludeCreatedBy(String ... var1);

        public Builder contextTypesWithStrings(Collection<String> var1);

        public Builder contextTypesWithStrings(String ... var1);

        public Builder contextTypes(Collection<EngagementContextType> var1);

        public Builder contextTypes(EngagementContextType ... var1);

        public Builder excludeContextTypesWithStrings(Collection<String> var1);

        public Builder excludeContextTypesWithStrings(String ... var1);

        public Builder excludeContextTypes(Collection<EngagementContextType> var1);

        public Builder excludeContextTypes(EngagementContextType ... var1);

        public Builder sort(EngagementSort var1);

        default public Builder sort(Consumer<EngagementSort.Builder> sort) {
            return this.sort((EngagementSort)((EngagementSort.Builder)EngagementSort.builder().applyMutation(sort)).build());
        }

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder engagementIdentifier(Collection<String> var1);

        public Builder engagementIdentifier(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

