/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralselling.model.EngagementContextType;
import software.amazon.awssdk.services.partnercentralselling.model.EngagementContextTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EngagementSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EngagementSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(EngagementSummary.getter(EngagementSummary::arn)).setter(EngagementSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(EngagementSummary.getter(EngagementSummary::id)).setter(EngagementSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(EngagementSummary.getter(EngagementSummary::title)).setter(EngagementSummary.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(EngagementSummary.getter(EngagementSummary::createdAt)).setter(EngagementSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedBy").getter(EngagementSummary.getter(EngagementSummary::createdBy)).setter(EngagementSummary.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<Integer> MEMBER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MemberCount").getter(EngagementSummary.getter(EngagementSummary::memberCount)).setter(EngagementSummary.setter(Builder::memberCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberCount").build()}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ModifiedAt").getter(EngagementSummary.getter(EngagementSummary::modifiedAt)).setter(EngagementSummary.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModifiedBy").getter(EngagementSummary.getter(EngagementSummary::modifiedBy)).setter(EngagementSummary.setter(Builder::modifiedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedBy").build()}).build();
    private static final SdkField<List<String>> CONTEXT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContextTypes").getter(EngagementSummary.getter(EngagementSummary::contextTypesAsStrings)).setter(EngagementSummary.setter(Builder::contextTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD, TITLE_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, MEMBER_COUNT_FIELD, MODIFIED_AT_FIELD, MODIFIED_BY_FIELD, CONTEXT_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EngagementSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String id;
    private final String title;
    private final Instant createdAt;
    private final String createdBy;
    private final Integer memberCount;
    private final Instant modifiedAt;
    private final String modifiedBy;
    private final List<String> contextTypes;

    private EngagementSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.title = builder.title;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.memberCount = builder.memberCount;
        this.modifiedAt = builder.modifiedAt;
        this.modifiedBy = builder.modifiedBy;
        this.contextTypes = builder.contextTypes;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final String title() {
        return this.title;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final Integer memberCount() {
        return this.memberCount;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public final String modifiedBy() {
        return this.modifiedBy;
    }

    public final List<EngagementContextType> contextTypes() {
        return EngagementContextTypeListCopier.copyStringToEnum(this.contextTypes);
    }

    public final boolean hasContextTypes() {
        return this.contextTypes != null && !(this.contextTypes instanceof SdkAutoConstructList);
    }

    public final List<String> contextTypesAsStrings() {
        return this.contextTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContextTypes() ? this.contextTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EngagementSummary)) {
            return false;
        }
        EngagementSummary other = (EngagementSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.memberCount(), other.memberCount()) && Objects.equals(this.modifiedAt(), other.modifiedAt()) && Objects.equals(this.modifiedBy(), other.modifiedBy()) && this.hasContextTypes() == other.hasContextTypes() && Objects.equals(this.contextTypesAsStrings(), other.contextTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"EngagementSummary").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("Title", (Object)this.title()).add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)(this.createdBy() == null ? null : "*** Sensitive Data Redacted ***")).add("MemberCount", (Object)this.memberCount()).add("ModifiedAt", (Object)this.modifiedAt()).add("ModifiedBy", (Object)(this.modifiedBy() == null ? null : "*** Sensitive Data Redacted ***")).add("ContextTypes", this.hasContextTypes() ? this.contextTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "MemberCount": {
                return Optional.ofNullable(clazz.cast(this.memberCount()));
            }
            case "ModifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
            case "ModifiedBy": {
                return Optional.ofNullable(clazz.cast(this.modifiedBy()));
            }
            case "ContextTypes": {
                return Optional.ofNullable(clazz.cast(this.contextTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("MemberCount", MEMBER_COUNT_FIELD);
        map.put("ModifiedAt", MODIFIED_AT_FIELD);
        map.put("ModifiedBy", MODIFIED_BY_FIELD);
        map.put("ContextTypes", CONTEXT_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EngagementSummary, T> g) {
        return obj -> g.apply((EngagementSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private String title;
        private Instant createdAt;
        private String createdBy;
        private Integer memberCount;
        private Instant modifiedAt;
        private String modifiedBy;
        private List<String> contextTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EngagementSummary model) {
            this.arn(model.arn);
            this.id(model.id);
            this.title(model.title);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.memberCount(model.memberCount);
            this.modifiedAt(model.modifiedAt);
            this.modifiedBy(model.modifiedBy);
            this.contextTypesWithStrings(model.contextTypes);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Integer getMemberCount() {
            return this.memberCount;
        }

        public final void setMemberCount(Integer memberCount) {
            this.memberCount = memberCount;
        }

        @Override
        public final Builder memberCount(Integer memberCount) {
            this.memberCount = memberCount;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final String getModifiedBy() {
            return this.modifiedBy;
        }

        public final void setModifiedBy(String modifiedBy) {
            this.modifiedBy = modifiedBy;
        }

        @Override
        public final Builder modifiedBy(String modifiedBy) {
            this.modifiedBy = modifiedBy;
            return this;
        }

        public final Collection<String> getContextTypes() {
            if (this.contextTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.contextTypes;
        }

        public final void setContextTypes(Collection<String> contextTypes) {
            this.contextTypes = EngagementContextTypeListCopier.copy(contextTypes);
        }

        @Override
        public final Builder contextTypesWithStrings(Collection<String> contextTypes) {
            this.contextTypes = EngagementContextTypeListCopier.copy(contextTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contextTypesWithStrings(String ... contextTypes) {
            this.contextTypesWithStrings(Arrays.asList(contextTypes));
            return this;
        }

        @Override
        public final Builder contextTypes(Collection<EngagementContextType> contextTypes) {
            this.contextTypes = EngagementContextTypeListCopier.copyEnumToString(contextTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contextTypes(EngagementContextType ... contextTypes) {
            this.contextTypes(Arrays.asList(contextTypes));
            return this;
        }

        public EngagementSummary build() {
            return new EngagementSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EngagementSummary> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder title(String var1);

        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder memberCount(Integer var1);

        public Builder modifiedAt(Instant var1);

        public Builder modifiedBy(String var1);

        public Builder contextTypesWithStrings(Collection<String> var1);

        public Builder contextTypesWithStrings(String ... var1);

        public Builder contextTypes(Collection<EngagementContextType> var1);

        public Builder contextTypes(EngagementContextType ... var1);
    }
}

