/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.partnercentralselling.model.AccountReceiver;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Receiver
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Receiver> {
    private static final SdkField<AccountReceiver> ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Account").getter(Receiver.getter(Receiver::account)).setter(Receiver.setter(Builder::account)).constructor(AccountReceiver::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Account").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Receiver.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AccountReceiver account;
    private final Type type;

    private Receiver(BuilderImpl builder) {
        this.account = builder.account;
        this.type = builder.type;
    }

    public final AccountReceiver account() {
        return this.account;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.account());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Receiver)) {
            return false;
        }
        Receiver other = (Receiver)obj;
        return Objects.equals(this.account(), other.account());
    }

    public final String toString() {
        return ToString.builder((String)"Receiver").add("Account", (Object)this.account()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Account": {
                return Optional.ofNullable(clazz.cast(this.account()));
            }
        }
        return Optional.empty();
    }

    public static Receiver fromAccount(AccountReceiver account) {
        return (Receiver)Receiver.builder().account(account).build();
    }

    public static Receiver fromAccount(Consumer<AccountReceiver.Builder> account) {
        AccountReceiver.Builder builder = AccountReceiver.builder();
        account.accept(builder);
        return Receiver.fromAccount((AccountReceiver)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<AccountReceiver>> map = new HashMap<String, SdkField<AccountReceiver>>();
        map.put("Account", ACCOUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Receiver, T> g) {
        return obj -> g.apply((Receiver)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ACCOUNT,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private AccountReceiver account;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Receiver model) {
            this.account(model.account);
        }

        public final AccountReceiver.Builder getAccount() {
            return this.account != null ? this.account.toBuilder() : null;
        }

        public final void setAccount(AccountReceiver.BuilderImpl account) {
            AccountReceiver oldValue = this.account;
            this.account = account != null ? account.build() : null;
            this.handleUnionValueChange(Type.ACCOUNT, oldValue, this.account);
        }

        @Override
        public final Builder account(AccountReceiver account) {
            AccountReceiver oldValue = this.account;
            this.account = account;
            this.handleUnionValueChange(Type.ACCOUNT, oldValue, this.account);
            return this;
        }

        public Receiver build() {
            return new Receiver(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Receiver> {
        public Builder account(AccountReceiver var1);

        default public Builder account(Consumer<AccountReceiver.Builder> account) {
            return this.account((AccountReceiver)((AccountReceiver.Builder)AccountReceiver.builder().applyMutation(account)).build());
        }
    }
}

