/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralselling.model.PartnerCentralSellingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutSellingSystemSettingsResponse
extends PartnerCentralSellingResponse
implements ToCopyableBuilder<Builder, PutSellingSystemSettingsResponse> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(PutSellingSystemSettingsResponse.getter(PutSellingSystemSettingsResponse::catalog)).setter(PutSellingSystemSettingsResponse.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<String> RESOURCE_SNAPSHOT_JOB_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceSnapshotJobRoleArn").getter(PutSellingSystemSettingsResponse.getter(PutSellingSystemSettingsResponse::resourceSnapshotJobRoleArn)).setter(PutSellingSystemSettingsResponse.setter(Builder::resourceSnapshotJobRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSnapshotJobRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, RESOURCE_SNAPSHOT_JOB_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutSellingSystemSettingsResponse.memberNameToFieldInitializer();
    private final String catalog;
    private final String resourceSnapshotJobRoleArn;

    private PutSellingSystemSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.resourceSnapshotJobRoleArn = builder.resourceSnapshotJobRoleArn;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final String resourceSnapshotJobRoleArn() {
        return this.resourceSnapshotJobRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSnapshotJobRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSellingSystemSettingsResponse)) {
            return false;
        }
        PutSellingSystemSettingsResponse other = (PutSellingSystemSettingsResponse)((Object)obj);
        return Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.resourceSnapshotJobRoleArn(), other.resourceSnapshotJobRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"PutSellingSystemSettingsResponse").add("Catalog", (Object)this.catalog()).add("ResourceSnapshotJobRoleArn", (Object)this.resourceSnapshotJobRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "ResourceSnapshotJobRoleArn": {
                return Optional.ofNullable(clazz.cast(this.resourceSnapshotJobRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("ResourceSnapshotJobRoleArn", RESOURCE_SNAPSHOT_JOB_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutSellingSystemSettingsResponse, T> g) {
        return obj -> g.apply((PutSellingSystemSettingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralSellingResponse.BuilderImpl
    implements Builder {
        private String catalog;
        private String resourceSnapshotJobRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSellingSystemSettingsResponse model) {
            super(model);
            this.catalog(model.catalog);
            this.resourceSnapshotJobRoleArn(model.resourceSnapshotJobRoleArn);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getResourceSnapshotJobRoleArn() {
            return this.resourceSnapshotJobRoleArn;
        }

        public final void setResourceSnapshotJobRoleArn(String resourceSnapshotJobRoleArn) {
            this.resourceSnapshotJobRoleArn = resourceSnapshotJobRoleArn;
        }

        @Override
        public final Builder resourceSnapshotJobRoleArn(String resourceSnapshotJobRoleArn) {
            this.resourceSnapshotJobRoleArn = resourceSnapshotJobRoleArn;
            return this;
        }

        @Override
        public PutSellingSystemSettingsResponse build() {
            return new PutSellingSystemSettingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PartnerCentralSellingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutSellingSystemSettingsResponse> {
        public Builder catalog(String var1);

        public Builder resourceSnapshotJobRoleArn(String var1);
    }
}

