/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralselling.model.AwsOpportunityCustomer;
import software.amazon.awssdk.services.partnercentralselling.model.AwsOpportunityInsights;
import software.amazon.awssdk.services.partnercentralselling.model.AwsOpportunityLifeCycle;
import software.amazon.awssdk.services.partnercentralselling.model.AwsOpportunityProject;
import software.amazon.awssdk.services.partnercentralselling.model.AwsOpportunityRelatedEntities;
import software.amazon.awssdk.services.partnercentralselling.model.AwsOpportunityTeamMembersListCopier;
import software.amazon.awssdk.services.partnercentralselling.model.AwsTeamMember;
import software.amazon.awssdk.services.partnercentralselling.model.InvolvementTypeChangeReason;
import software.amazon.awssdk.services.partnercentralselling.model.OpportunityOrigin;
import software.amazon.awssdk.services.partnercentralselling.model.PartnerCentralSellingResponse;
import software.amazon.awssdk.services.partnercentralselling.model.SalesInvolvementType;
import software.amazon.awssdk.services.partnercentralselling.model.Visibility;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAwsOpportunitySummaryResponse
extends PartnerCentralSellingResponse
implements ToCopyableBuilder<Builder, GetAwsOpportunitySummaryResponse> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(GetAwsOpportunitySummaryResponse.getter(GetAwsOpportunitySummaryResponse::catalog)).setter(GetAwsOpportunitySummaryResponse.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<AwsOpportunityCustomer> CUSTOMER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Customer").getter(GetAwsOpportunitySummaryResponse.getter(GetAwsOpportunitySummaryResponse::customer)).setter(GetAwsOpportunitySummaryResponse.setter(Builder::customer)).constructor(AwsOpportunityCustomer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Customer").build()}).build();
    private static final SdkField<AwsOpportunityInsights> INSIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Insights").getter(GetAwsOpportunitySummaryResponse.getter(GetAwsOpportunitySummaryResponse::insights)).setter(GetAwsOpportunitySummaryResponse.setter(Builder::insights)).constructor(AwsOpportunityInsights::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Insights").build()}).build();
    private static final SdkField<String> INVOLVEMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InvolvementType").getter(GetAwsOpportunitySummaryResponse.getter(GetAwsOpportunitySummaryResponse::involvementTypeAsString)).setter(GetAwsOpportunitySummaryResponse.setter(Builder::involvementType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvolvementType").build()}).build();
    private static final SdkField<String> INVOLVEMENT_TYPE_CHANGE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InvolvementTypeChangeReason").getter(GetAwsOpportunitySummaryResponse.getter(GetAwsOpportunitySummaryResponse::involvementTypeChangeReasonAsString)).setter(GetAwsOpportunitySummaryResponse.setter(Builder::involvementTypeChangeReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvolvementTypeChangeReason").build()}).build();
    private static final SdkField<AwsOpportunityLifeCycle> LIFE_CYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LifeCycle").getter(GetAwsOpportunitySummaryResponse.getter(GetAwsOpportunitySummaryResponse::lifeCycle)).setter(GetAwsOpportunitySummaryResponse.setter(Builder::lifeCycle)).constructor(AwsOpportunityLifeCycle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifeCycle").build()}).build();
    private static final SdkField<List<AwsTeamMember>> OPPORTUNITY_TEAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OpportunityTeam").getter(GetAwsOpportunitySummaryResponse.getter(GetAwsOpportunitySummaryResponse::opportunityTeam)).setter(GetAwsOpportunitySummaryResponse.setter(Builder::opportunityTeam)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpportunityTeam").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsTeamMember::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Origin").getter(GetAwsOpportunitySummaryResponse.getter(GetAwsOpportunitySummaryResponse::originAsString)).setter(GetAwsOpportunitySummaryResponse.setter(Builder::origin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origin").build()}).build();
    private static final SdkField<AwsOpportunityProject> PROJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Project").getter(GetAwsOpportunitySummaryResponse.getter(GetAwsOpportunitySummaryResponse::project)).setter(GetAwsOpportunitySummaryResponse.setter(Builder::project)).constructor(AwsOpportunityProject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Project").build()}).build();
    private static final SdkField<AwsOpportunityRelatedEntities> RELATED_ENTITY_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RelatedEntityIds").getter(GetAwsOpportunitySummaryResponse.getter(GetAwsOpportunitySummaryResponse::relatedEntityIds)).setter(GetAwsOpportunitySummaryResponse.setter(Builder::relatedEntityIds)).constructor(AwsOpportunityRelatedEntities::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedEntityIds").build()}).build();
    private static final SdkField<String> RELATED_OPPORTUNITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelatedOpportunityId").getter(GetAwsOpportunitySummaryResponse.getter(GetAwsOpportunitySummaryResponse::relatedOpportunityId)).setter(GetAwsOpportunitySummaryResponse.setter(Builder::relatedOpportunityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedOpportunityId").build()}).build();
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Visibility").getter(GetAwsOpportunitySummaryResponse.getter(GetAwsOpportunitySummaryResponse::visibilityAsString)).setter(GetAwsOpportunitySummaryResponse.setter(Builder::visibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, CUSTOMER_FIELD, INSIGHTS_FIELD, INVOLVEMENT_TYPE_FIELD, INVOLVEMENT_TYPE_CHANGE_REASON_FIELD, LIFE_CYCLE_FIELD, OPPORTUNITY_TEAM_FIELD, ORIGIN_FIELD, PROJECT_FIELD, RELATED_ENTITY_IDS_FIELD, RELATED_OPPORTUNITY_ID_FIELD, VISIBILITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAwsOpportunitySummaryResponse.memberNameToFieldInitializer();
    private final String catalog;
    private final AwsOpportunityCustomer customer;
    private final AwsOpportunityInsights insights;
    private final String involvementType;
    private final String involvementTypeChangeReason;
    private final AwsOpportunityLifeCycle lifeCycle;
    private final List<AwsTeamMember> opportunityTeam;
    private final String origin;
    private final AwsOpportunityProject project;
    private final AwsOpportunityRelatedEntities relatedEntityIds;
    private final String relatedOpportunityId;
    private final String visibility;

    private GetAwsOpportunitySummaryResponse(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.customer = builder.customer;
        this.insights = builder.insights;
        this.involvementType = builder.involvementType;
        this.involvementTypeChangeReason = builder.involvementTypeChangeReason;
        this.lifeCycle = builder.lifeCycle;
        this.opportunityTeam = builder.opportunityTeam;
        this.origin = builder.origin;
        this.project = builder.project;
        this.relatedEntityIds = builder.relatedEntityIds;
        this.relatedOpportunityId = builder.relatedOpportunityId;
        this.visibility = builder.visibility;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final AwsOpportunityCustomer customer() {
        return this.customer;
    }

    public final AwsOpportunityInsights insights() {
        return this.insights;
    }

    public final SalesInvolvementType involvementType() {
        return SalesInvolvementType.fromValue(this.involvementType);
    }

    public final String involvementTypeAsString() {
        return this.involvementType;
    }

    public final InvolvementTypeChangeReason involvementTypeChangeReason() {
        return InvolvementTypeChangeReason.fromValue(this.involvementTypeChangeReason);
    }

    public final String involvementTypeChangeReasonAsString() {
        return this.involvementTypeChangeReason;
    }

    public final AwsOpportunityLifeCycle lifeCycle() {
        return this.lifeCycle;
    }

    public final boolean hasOpportunityTeam() {
        return this.opportunityTeam != null && !(this.opportunityTeam instanceof SdkAutoConstructList);
    }

    public final List<AwsTeamMember> opportunityTeam() {
        return this.opportunityTeam;
    }

    public final OpportunityOrigin origin() {
        return OpportunityOrigin.fromValue(this.origin);
    }

    public final String originAsString() {
        return this.origin;
    }

    public final AwsOpportunityProject project() {
        return this.project;
    }

    public final AwsOpportunityRelatedEntities relatedEntityIds() {
        return this.relatedEntityIds;
    }

    public final String relatedOpportunityId() {
        return this.relatedOpportunityId;
    }

    public final Visibility visibility() {
        return Visibility.fromValue(this.visibility);
    }

    public final String visibilityAsString() {
        return this.visibility;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.customer());
        hashCode = 31 * hashCode + Objects.hashCode(this.insights());
        hashCode = 31 * hashCode + Objects.hashCode(this.involvementTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.involvementTypeChangeReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifeCycle());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOpportunityTeam() ? this.opportunityTeam() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.originAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.project());
        hashCode = 31 * hashCode + Objects.hashCode(this.relatedEntityIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.relatedOpportunityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAwsOpportunitySummaryResponse)) {
            return false;
        }
        GetAwsOpportunitySummaryResponse other = (GetAwsOpportunitySummaryResponse)((Object)obj);
        return Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.customer(), other.customer()) && Objects.equals(this.insights(), other.insights()) && Objects.equals(this.involvementTypeAsString(), other.involvementTypeAsString()) && Objects.equals(this.involvementTypeChangeReasonAsString(), other.involvementTypeChangeReasonAsString()) && Objects.equals(this.lifeCycle(), other.lifeCycle()) && this.hasOpportunityTeam() == other.hasOpportunityTeam() && Objects.equals(this.opportunityTeam(), other.opportunityTeam()) && Objects.equals(this.originAsString(), other.originAsString()) && Objects.equals(this.project(), other.project()) && Objects.equals(this.relatedEntityIds(), other.relatedEntityIds()) && Objects.equals(this.relatedOpportunityId(), other.relatedOpportunityId()) && Objects.equals(this.visibilityAsString(), other.visibilityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetAwsOpportunitySummaryResponse").add("Catalog", (Object)this.catalog()).add("Customer", (Object)this.customer()).add("Insights", (Object)this.insights()).add("InvolvementType", (Object)this.involvementTypeAsString()).add("InvolvementTypeChangeReason", (Object)this.involvementTypeChangeReasonAsString()).add("LifeCycle", (Object)this.lifeCycle()).add("OpportunityTeam", this.hasOpportunityTeam() ? this.opportunityTeam() : null).add("Origin", (Object)this.originAsString()).add("Project", (Object)this.project()).add("RelatedEntityIds", (Object)this.relatedEntityIds()).add("RelatedOpportunityId", (Object)this.relatedOpportunityId()).add("Visibility", (Object)this.visibilityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "Customer": {
                return Optional.ofNullable(clazz.cast(this.customer()));
            }
            case "Insights": {
                return Optional.ofNullable(clazz.cast(this.insights()));
            }
            case "InvolvementType": {
                return Optional.ofNullable(clazz.cast(this.involvementTypeAsString()));
            }
            case "InvolvementTypeChangeReason": {
                return Optional.ofNullable(clazz.cast(this.involvementTypeChangeReasonAsString()));
            }
            case "LifeCycle": {
                return Optional.ofNullable(clazz.cast(this.lifeCycle()));
            }
            case "OpportunityTeam": {
                return Optional.ofNullable(clazz.cast(this.opportunityTeam()));
            }
            case "Origin": {
                return Optional.ofNullable(clazz.cast(this.originAsString()));
            }
            case "Project": {
                return Optional.ofNullable(clazz.cast(this.project()));
            }
            case "RelatedEntityIds": {
                return Optional.ofNullable(clazz.cast(this.relatedEntityIds()));
            }
            case "RelatedOpportunityId": {
                return Optional.ofNullable(clazz.cast(this.relatedOpportunityId()));
            }
            case "Visibility": {
                return Optional.ofNullable(clazz.cast(this.visibilityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("Customer", CUSTOMER_FIELD);
        map.put("Insights", INSIGHTS_FIELD);
        map.put("InvolvementType", INVOLVEMENT_TYPE_FIELD);
        map.put("InvolvementTypeChangeReason", INVOLVEMENT_TYPE_CHANGE_REASON_FIELD);
        map.put("LifeCycle", LIFE_CYCLE_FIELD);
        map.put("OpportunityTeam", OPPORTUNITY_TEAM_FIELD);
        map.put("Origin", ORIGIN_FIELD);
        map.put("Project", PROJECT_FIELD);
        map.put("RelatedEntityIds", RELATED_ENTITY_IDS_FIELD);
        map.put("RelatedOpportunityId", RELATED_OPPORTUNITY_ID_FIELD);
        map.put("Visibility", VISIBILITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAwsOpportunitySummaryResponse, T> g) {
        return obj -> g.apply((GetAwsOpportunitySummaryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralSellingResponse.BuilderImpl
    implements Builder {
        private String catalog;
        private AwsOpportunityCustomer customer;
        private AwsOpportunityInsights insights;
        private String involvementType;
        private String involvementTypeChangeReason;
        private AwsOpportunityLifeCycle lifeCycle;
        private List<AwsTeamMember> opportunityTeam = DefaultSdkAutoConstructList.getInstance();
        private String origin;
        private AwsOpportunityProject project;
        private AwsOpportunityRelatedEntities relatedEntityIds;
        private String relatedOpportunityId;
        private String visibility;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAwsOpportunitySummaryResponse model) {
            super(model);
            this.catalog(model.catalog);
            this.customer(model.customer);
            this.insights(model.insights);
            this.involvementType(model.involvementType);
            this.involvementTypeChangeReason(model.involvementTypeChangeReason);
            this.lifeCycle(model.lifeCycle);
            this.opportunityTeam(model.opportunityTeam);
            this.origin(model.origin);
            this.project(model.project);
            this.relatedEntityIds(model.relatedEntityIds);
            this.relatedOpportunityId(model.relatedOpportunityId);
            this.visibility(model.visibility);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final AwsOpportunityCustomer.Builder getCustomer() {
            return this.customer != null ? this.customer.toBuilder() : null;
        }

        public final void setCustomer(AwsOpportunityCustomer.BuilderImpl customer) {
            this.customer = customer != null ? customer.build() : null;
        }

        @Override
        public final Builder customer(AwsOpportunityCustomer customer) {
            this.customer = customer;
            return this;
        }

        public final AwsOpportunityInsights.Builder getInsights() {
            return this.insights != null ? this.insights.toBuilder() : null;
        }

        public final void setInsights(AwsOpportunityInsights.BuilderImpl insights) {
            this.insights = insights != null ? insights.build() : null;
        }

        @Override
        public final Builder insights(AwsOpportunityInsights insights) {
            this.insights = insights;
            return this;
        }

        public final String getInvolvementType() {
            return this.involvementType;
        }

        public final void setInvolvementType(String involvementType) {
            this.involvementType = involvementType;
        }

        @Override
        public final Builder involvementType(String involvementType) {
            this.involvementType = involvementType;
            return this;
        }

        @Override
        public final Builder involvementType(SalesInvolvementType involvementType) {
            this.involvementType(involvementType == null ? null : involvementType.toString());
            return this;
        }

        public final String getInvolvementTypeChangeReason() {
            return this.involvementTypeChangeReason;
        }

        public final void setInvolvementTypeChangeReason(String involvementTypeChangeReason) {
            this.involvementTypeChangeReason = involvementTypeChangeReason;
        }

        @Override
        public final Builder involvementTypeChangeReason(String involvementTypeChangeReason) {
            this.involvementTypeChangeReason = involvementTypeChangeReason;
            return this;
        }

        @Override
        public final Builder involvementTypeChangeReason(InvolvementTypeChangeReason involvementTypeChangeReason) {
            this.involvementTypeChangeReason(involvementTypeChangeReason == null ? null : involvementTypeChangeReason.toString());
            return this;
        }

        public final AwsOpportunityLifeCycle.Builder getLifeCycle() {
            return this.lifeCycle != null ? this.lifeCycle.toBuilder() : null;
        }

        public final void setLifeCycle(AwsOpportunityLifeCycle.BuilderImpl lifeCycle) {
            this.lifeCycle = lifeCycle != null ? lifeCycle.build() : null;
        }

        @Override
        public final Builder lifeCycle(AwsOpportunityLifeCycle lifeCycle) {
            this.lifeCycle = lifeCycle;
            return this;
        }

        public final List<AwsTeamMember.Builder> getOpportunityTeam() {
            List<AwsTeamMember.Builder> result = AwsOpportunityTeamMembersListCopier.copyToBuilder(this.opportunityTeam);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOpportunityTeam(Collection<AwsTeamMember.BuilderImpl> opportunityTeam) {
            this.opportunityTeam = AwsOpportunityTeamMembersListCopier.copyFromBuilder(opportunityTeam);
        }

        @Override
        public final Builder opportunityTeam(Collection<AwsTeamMember> opportunityTeam) {
            this.opportunityTeam = AwsOpportunityTeamMembersListCopier.copy(opportunityTeam);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder opportunityTeam(AwsTeamMember ... opportunityTeam) {
            this.opportunityTeam(Arrays.asList(opportunityTeam));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder opportunityTeam(Consumer<AwsTeamMember.Builder> ... opportunityTeam) {
            this.opportunityTeam(Stream.of(opportunityTeam).map(c -> (AwsTeamMember)((AwsTeamMember.Builder)AwsTeamMember.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOrigin() {
            return this.origin;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Override
        public final Builder origin(OpportunityOrigin origin) {
            this.origin(origin == null ? null : origin.toString());
            return this;
        }

        public final AwsOpportunityProject.Builder getProject() {
            return this.project != null ? this.project.toBuilder() : null;
        }

        public final void setProject(AwsOpportunityProject.BuilderImpl project) {
            this.project = project != null ? project.build() : null;
        }

        @Override
        public final Builder project(AwsOpportunityProject project) {
            this.project = project;
            return this;
        }

        public final AwsOpportunityRelatedEntities.Builder getRelatedEntityIds() {
            return this.relatedEntityIds != null ? this.relatedEntityIds.toBuilder() : null;
        }

        public final void setRelatedEntityIds(AwsOpportunityRelatedEntities.BuilderImpl relatedEntityIds) {
            this.relatedEntityIds = relatedEntityIds != null ? relatedEntityIds.build() : null;
        }

        @Override
        public final Builder relatedEntityIds(AwsOpportunityRelatedEntities relatedEntityIds) {
            this.relatedEntityIds = relatedEntityIds;
            return this;
        }

        public final String getRelatedOpportunityId() {
            return this.relatedOpportunityId;
        }

        public final void setRelatedOpportunityId(String relatedOpportunityId) {
            this.relatedOpportunityId = relatedOpportunityId;
        }

        @Override
        public final Builder relatedOpportunityId(String relatedOpportunityId) {
            this.relatedOpportunityId = relatedOpportunityId;
            return this;
        }

        public final String getVisibility() {
            return this.visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        @Override
        public GetAwsOpportunitySummaryResponse build() {
            return new GetAwsOpportunitySummaryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralSellingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAwsOpportunitySummaryResponse> {
        public Builder catalog(String var1);

        public Builder customer(AwsOpportunityCustomer var1);

        default public Builder customer(Consumer<AwsOpportunityCustomer.Builder> customer) {
            return this.customer((AwsOpportunityCustomer)((AwsOpportunityCustomer.Builder)AwsOpportunityCustomer.builder().applyMutation(customer)).build());
        }

        public Builder insights(AwsOpportunityInsights var1);

        default public Builder insights(Consumer<AwsOpportunityInsights.Builder> insights) {
            return this.insights((AwsOpportunityInsights)((AwsOpportunityInsights.Builder)AwsOpportunityInsights.builder().applyMutation(insights)).build());
        }

        public Builder involvementType(String var1);

        public Builder involvementType(SalesInvolvementType var1);

        public Builder involvementTypeChangeReason(String var1);

        public Builder involvementTypeChangeReason(InvolvementTypeChangeReason var1);

        public Builder lifeCycle(AwsOpportunityLifeCycle var1);

        default public Builder lifeCycle(Consumer<AwsOpportunityLifeCycle.Builder> lifeCycle) {
            return this.lifeCycle((AwsOpportunityLifeCycle)((AwsOpportunityLifeCycle.Builder)AwsOpportunityLifeCycle.builder().applyMutation(lifeCycle)).build());
        }

        public Builder opportunityTeam(Collection<AwsTeamMember> var1);

        public Builder opportunityTeam(AwsTeamMember ... var1);

        public Builder opportunityTeam(Consumer<AwsTeamMember.Builder> ... var1);

        public Builder origin(String var1);

        public Builder origin(OpportunityOrigin var1);

        public Builder project(AwsOpportunityProject var1);

        default public Builder project(Consumer<AwsOpportunityProject.Builder> project) {
            return this.project((AwsOpportunityProject)((AwsOpportunityProject.Builder)AwsOpportunityProject.builder().applyMutation(project)).build());
        }

        public Builder relatedEntityIds(AwsOpportunityRelatedEntities var1);

        default public Builder relatedEntityIds(Consumer<AwsOpportunityRelatedEntities.Builder> relatedEntityIds) {
            return this.relatedEntityIds((AwsOpportunityRelatedEntities)((AwsOpportunityRelatedEntities.Builder)AwsOpportunityRelatedEntities.builder().applyMutation(relatedEntityIds)).build());
        }

        public Builder relatedOpportunityId(String var1);

        public Builder visibility(String var1);

        public Builder visibility(Visibility var1);
    }
}

