/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralselling.model.AwsProductIdentifiersCopier;
import software.amazon.awssdk.services.partnercentralselling.model.SolutionIdentifiersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsOpportunityRelatedEntities
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsOpportunityRelatedEntities> {
    private static final SdkField<List<String>> AWS_PRODUCTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AwsProducts").getter(AwsOpportunityRelatedEntities.getter(AwsOpportunityRelatedEntities::awsProducts)).setter(AwsOpportunityRelatedEntities.setter(Builder::awsProducts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsProducts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SOLUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Solutions").getter(AwsOpportunityRelatedEntities.getter(AwsOpportunityRelatedEntities::solutions)).setter(AwsOpportunityRelatedEntities.setter(Builder::solutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Solutions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_PRODUCTS_FIELD, SOLUTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsOpportunityRelatedEntities.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> awsProducts;
    private final List<String> solutions;

    private AwsOpportunityRelatedEntities(BuilderImpl builder) {
        this.awsProducts = builder.awsProducts;
        this.solutions = builder.solutions;
    }

    public final boolean hasAwsProducts() {
        return this.awsProducts != null && !(this.awsProducts instanceof SdkAutoConstructList);
    }

    public final List<String> awsProducts() {
        return this.awsProducts;
    }

    public final boolean hasSolutions() {
        return this.solutions != null && !(this.solutions instanceof SdkAutoConstructList);
    }

    public final List<String> solutions() {
        return this.solutions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAwsProducts() ? this.awsProducts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSolutions() ? this.solutions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsOpportunityRelatedEntities)) {
            return false;
        }
        AwsOpportunityRelatedEntities other = (AwsOpportunityRelatedEntities)obj;
        return this.hasAwsProducts() == other.hasAwsProducts() && Objects.equals(this.awsProducts(), other.awsProducts()) && this.hasSolutions() == other.hasSolutions() && Objects.equals(this.solutions(), other.solutions());
    }

    public final String toString() {
        return ToString.builder((String)"AwsOpportunityRelatedEntities").add("AwsProducts", this.hasAwsProducts() ? this.awsProducts() : null).add("Solutions", this.hasSolutions() ? this.solutions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsProducts": {
                return Optional.ofNullable(clazz.cast(this.awsProducts()));
            }
            case "Solutions": {
                return Optional.ofNullable(clazz.cast(this.solutions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("AwsProducts", AWS_PRODUCTS_FIELD);
        map.put("Solutions", SOLUTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsOpportunityRelatedEntities, T> g) {
        return obj -> g.apply((AwsOpportunityRelatedEntities)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> awsProducts = DefaultSdkAutoConstructList.getInstance();
        private List<String> solutions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsOpportunityRelatedEntities model) {
            this.awsProducts(model.awsProducts);
            this.solutions(model.solutions);
        }

        public final Collection<String> getAwsProducts() {
            if (this.awsProducts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.awsProducts;
        }

        public final void setAwsProducts(Collection<String> awsProducts) {
            this.awsProducts = AwsProductIdentifiersCopier.copy(awsProducts);
        }

        @Override
        public final Builder awsProducts(Collection<String> awsProducts) {
            this.awsProducts = AwsProductIdentifiersCopier.copy(awsProducts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsProducts(String ... awsProducts) {
            this.awsProducts(Arrays.asList(awsProducts));
            return this;
        }

        public final Collection<String> getSolutions() {
            if (this.solutions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.solutions;
        }

        public final void setSolutions(Collection<String> solutions) {
            this.solutions = SolutionIdentifiersCopier.copy(solutions);
        }

        @Override
        public final Builder solutions(Collection<String> solutions) {
            this.solutions = SolutionIdentifiersCopier.copy(solutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder solutions(String ... solutions) {
            this.solutions(Arrays.asList(solutions));
            return this;
        }

        public AwsOpportunityRelatedEntities build() {
            return new AwsOpportunityRelatedEntities(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsOpportunityRelatedEntities> {
        public Builder awsProducts(Collection<String> var1);

        public Builder awsProducts(String ... var1);

        public Builder solutions(Collection<String> var1);

        public Builder solutions(String ... var1);
    }
}

