/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.partnercentralselling.PartnerCentralSellingAsyncClient;
import software.amazon.awssdk.services.partnercentralselling.internal.UserAgentUtils;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementFromOpportunityTaskSummary;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementFromOpportunityTasksRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementFromOpportunityTasksResponse;

public class ListEngagementFromOpportunityTasksPublisher
implements SdkPublisher<ListEngagementFromOpportunityTasksResponse> {
    private final PartnerCentralSellingAsyncClient client;
    private final ListEngagementFromOpportunityTasksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEngagementFromOpportunityTasksPublisher(PartnerCentralSellingAsyncClient client, ListEngagementFromOpportunityTasksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEngagementFromOpportunityTasksPublisher(PartnerCentralSellingAsyncClient client, ListEngagementFromOpportunityTasksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEngagementFromOpportunityTasksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEngagementFromOpportunityTasksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListEngagementFromOpportunityTaskSummary> taskSummaries() {
        Function<ListEngagementFromOpportunityTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.taskSummaries() != null) {
                return response.taskSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEngagementFromOpportunityTasksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEngagementFromOpportunityTasksResponseFetcher
    implements AsyncPageFetcher<ListEngagementFromOpportunityTasksResponse> {
        private ListEngagementFromOpportunityTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListEngagementFromOpportunityTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEngagementFromOpportunityTasksResponse> nextPage(ListEngagementFromOpportunityTasksResponse previousPage) {
            if (previousPage == null) {
                return ListEngagementFromOpportunityTasksPublisher.this.client.listEngagementFromOpportunityTasks(ListEngagementFromOpportunityTasksPublisher.this.firstRequest);
            }
            return ListEngagementFromOpportunityTasksPublisher.this.client.listEngagementFromOpportunityTasks((ListEngagementFromOpportunityTasksRequest)((Object)ListEngagementFromOpportunityTasksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

