/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Channel {
    AWS_MARKETING_CENTRAL("AWS Marketing Central"),
    CONTENT_SYNDICATION("Content Syndication"),
    DISPLAY("Display"),
    EMAIL("Email"),
    LIVE_EVENT("Live Event"),
    OUT_OF_HOME_OOH("Out Of Home (OOH)"),
    PRINT("Print"),
    SEARCH("Search"),
    SOCIAL("Social"),
    TELEMARKETING("Telemarketing"),
    TV("TV"),
    VIDEO("Video"),
    VIRTUAL_EVENT("Virtual Event"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Channel> VALUE_MAP;
    private final String value;

    private Channel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Channel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Channel> knownValues() {
        EnumSet<Channel> knownValues = EnumSet.allOf(Channel.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Channel.class, Channel::toString);
    }
}

