/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.partnercentralselling.PartnerCentralSellingClient;
import software.amazon.awssdk.services.partnercentralselling.internal.UserAgentUtils;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementFromOpportunityTaskSummary;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementFromOpportunityTasksRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementFromOpportunityTasksResponse;

public class ListEngagementFromOpportunityTasksIterable
implements SdkIterable<ListEngagementFromOpportunityTasksResponse> {
    private final PartnerCentralSellingClient client;
    private final ListEngagementFromOpportunityTasksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEngagementFromOpportunityTasksIterable(PartnerCentralSellingClient client, ListEngagementFromOpportunityTasksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEngagementFromOpportunityTasksResponseFetcher();
    }

    public Iterator<ListEngagementFromOpportunityTasksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListEngagementFromOpportunityTaskSummary> taskSummaries() {
        Function<ListEngagementFromOpportunityTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.taskSummaries() != null) {
                return response.taskSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEngagementFromOpportunityTasksResponseFetcher
    implements SyncPageFetcher<ListEngagementFromOpportunityTasksResponse> {
        private ListEngagementFromOpportunityTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListEngagementFromOpportunityTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEngagementFromOpportunityTasksResponse nextPage(ListEngagementFromOpportunityTasksResponse previousPage) {
            if (previousPage == null) {
                return ListEngagementFromOpportunityTasksIterable.this.client.listEngagementFromOpportunityTasks(ListEngagementFromOpportunityTasksIterable.this.firstRequest);
            }
            return ListEngagementFromOpportunityTasksIterable.this.client.listEngagementFromOpportunityTasks((ListEngagementFromOpportunityTasksRequest)((Object)ListEngagementFromOpportunityTasksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

