/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OpportunityType {
    NET_NEW_BUSINESS("Net New Business"),
    FLAT_RENEWAL("Flat Renewal"),
    EXPANSION("Expansion"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OpportunityType> VALUE_MAP;
    private final String value;

    private OpportunityType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OpportunityType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OpportunityType> knownValues() {
        EnumSet<OpportunityType> knownValues = EnumSet.allOf(OpportunityType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OpportunityType.class, OpportunityType::toString);
    }
}

