/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralselling.model.AwsMemberBusinessTitle;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsTeamMember
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsTeamMember> {
    private static final SdkField<String> BUSINESS_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BusinessTitle").getter(AwsTeamMember.getter(AwsTeamMember::businessTitleAsString)).setter(AwsTeamMember.setter(Builder::businessTitle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BusinessTitle").build()}).build();
    private static final SdkField<String> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Email").getter(AwsTeamMember.getter(AwsTeamMember::email)).setter(AwsTeamMember.setter(Builder::email)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()}).build();
    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirstName").getter(AwsTeamMember.getter(AwsTeamMember::firstName)).setter(AwsTeamMember.setter(Builder::firstName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstName").build()}).build();
    private static final SdkField<String> LAST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastName").getter(AwsTeamMember.getter(AwsTeamMember::lastName)).setter(AwsTeamMember.setter(Builder::lastName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUSINESS_TITLE_FIELD, EMAIL_FIELD, FIRST_NAME_FIELD, LAST_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsTeamMember.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String businessTitle;
    private final String email;
    private final String firstName;
    private final String lastName;

    private AwsTeamMember(BuilderImpl builder) {
        this.businessTitle = builder.businessTitle;
        this.email = builder.email;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
    }

    public final AwsMemberBusinessTitle businessTitle() {
        return AwsMemberBusinessTitle.fromValue(this.businessTitle);
    }

    public final String businessTitleAsString() {
        return this.businessTitle;
    }

    public final String email() {
        return this.email;
    }

    public final String firstName() {
        return this.firstName;
    }

    public final String lastName() {
        return this.lastName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.businessTitleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsTeamMember)) {
            return false;
        }
        AwsTeamMember other = (AwsTeamMember)obj;
        return Objects.equals(this.businessTitleAsString(), other.businessTitleAsString()) && Objects.equals(this.email(), other.email()) && Objects.equals(this.firstName(), other.firstName()) && Objects.equals(this.lastName(), other.lastName());
    }

    public final String toString() {
        return ToString.builder((String)"AwsTeamMember").add("BusinessTitle", (Object)this.businessTitleAsString()).add("Email", (Object)(this.email() == null ? null : "*** Sensitive Data Redacted ***")).add("FirstName", (Object)(this.firstName() == null ? null : "*** Sensitive Data Redacted ***")).add("LastName", (Object)(this.lastName() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BusinessTitle": {
                return Optional.ofNullable(clazz.cast(this.businessTitleAsString()));
            }
            case "Email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
            case "FirstName": {
                return Optional.ofNullable(clazz.cast(this.firstName()));
            }
            case "LastName": {
                return Optional.ofNullable(clazz.cast(this.lastName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("BusinessTitle", BUSINESS_TITLE_FIELD);
        map.put("Email", EMAIL_FIELD);
        map.put("FirstName", FIRST_NAME_FIELD);
        map.put("LastName", LAST_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsTeamMember, T> g) {
        return obj -> g.apply((AwsTeamMember)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String businessTitle;
        private String email;
        private String firstName;
        private String lastName;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsTeamMember model) {
            this.businessTitle(model.businessTitle);
            this.email(model.email);
            this.firstName(model.firstName);
            this.lastName(model.lastName);
        }

        public final String getBusinessTitle() {
            return this.businessTitle;
        }

        public final void setBusinessTitle(String businessTitle) {
            this.businessTitle = businessTitle;
        }

        @Override
        public final Builder businessTitle(String businessTitle) {
            this.businessTitle = businessTitle;
            return this;
        }

        @Override
        public final Builder businessTitle(AwsMemberBusinessTitle businessTitle) {
            this.businessTitle(businessTitle == null ? null : businessTitle.toString());
            return this;
        }

        public final String getEmail() {
            return this.email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final String getFirstName() {
            return this.firstName;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final String getLastName() {
            return this.lastName;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public AwsTeamMember build() {
            return new AwsTeamMember(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsTeamMember> {
        public Builder businessTitle(String var1);

        public Builder businessTitle(AwsMemberBusinessTitle var1);

        public Builder email(String var1);

        public Builder firstName(String var1);

        public Builder lastName(String var1);
    }
}

