/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralselling.model.EngagementIdentifiersCopier;
import software.amazon.awssdk.services.partnercentralselling.model.ListTasksSortBase;
import software.amazon.awssdk.services.partnercentralselling.model.OpportunityIdentifiersCopier;
import software.amazon.awssdk.services.partnercentralselling.model.PartnerCentralSellingRequest;
import software.amazon.awssdk.services.partnercentralselling.model.TaskIdentifiersCopier;
import software.amazon.awssdk.services.partnercentralselling.model.TaskStatus;
import software.amazon.awssdk.services.partnercentralselling.model.TaskStatusesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEngagementFromOpportunityTasksRequest
extends PartnerCentralSellingRequest
implements ToCopyableBuilder<Builder, ListEngagementFromOpportunityTasksRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(ListEngagementFromOpportunityTasksRequest.getter(ListEngagementFromOpportunityTasksRequest::catalog)).setter(ListEngagementFromOpportunityTasksRequest.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<List<String>> ENGAGEMENT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EngagementIdentifier").getter(ListEngagementFromOpportunityTasksRequest.getter(ListEngagementFromOpportunityTasksRequest::engagementIdentifier)).setter(ListEngagementFromOpportunityTasksRequest.setter(Builder::engagementIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementIdentifier").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListEngagementFromOpportunityTasksRequest.getter(ListEngagementFromOpportunityTasksRequest::maxResults)).setter(ListEngagementFromOpportunityTasksRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListEngagementFromOpportunityTasksRequest.getter(ListEngagementFromOpportunityTasksRequest::nextToken)).setter(ListEngagementFromOpportunityTasksRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<String>> OPPORTUNITY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OpportunityIdentifier").getter(ListEngagementFromOpportunityTasksRequest.getter(ListEngagementFromOpportunityTasksRequest::opportunityIdentifier)).setter(ListEngagementFromOpportunityTasksRequest.setter(Builder::opportunityIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpportunityIdentifier").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ListTasksSortBase> SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Sort").getter(ListEngagementFromOpportunityTasksRequest.getter(ListEngagementFromOpportunityTasksRequest::sort)).setter(ListEngagementFromOpportunityTasksRequest.setter(Builder::sort)).constructor(ListTasksSortBase::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sort").build()}).build();
    private static final SdkField<List<String>> TASK_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TaskIdentifier").getter(ListEngagementFromOpportunityTasksRequest.getter(ListEngagementFromOpportunityTasksRequest::taskIdentifier)).setter(ListEngagementFromOpportunityTasksRequest.setter(Builder::taskIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskIdentifier").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TASK_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TaskStatus").getter(ListEngagementFromOpportunityTasksRequest.getter(ListEngagementFromOpportunityTasksRequest::taskStatusAsStrings)).setter(ListEngagementFromOpportunityTasksRequest.setter(Builder::taskStatusWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskStatus").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, ENGAGEMENT_IDENTIFIER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, OPPORTUNITY_IDENTIFIER_FIELD, SORT_FIELD, TASK_IDENTIFIER_FIELD, TASK_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEngagementFromOpportunityTasksRequest.memberNameToFieldInitializer();
    private final String catalog;
    private final List<String> engagementIdentifier;
    private final Integer maxResults;
    private final String nextToken;
    private final List<String> opportunityIdentifier;
    private final ListTasksSortBase sort;
    private final List<String> taskIdentifier;
    private final List<String> taskStatus;

    private ListEngagementFromOpportunityTasksRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.engagementIdentifier = builder.engagementIdentifier;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.opportunityIdentifier = builder.opportunityIdentifier;
        this.sort = builder.sort;
        this.taskIdentifier = builder.taskIdentifier;
        this.taskStatus = builder.taskStatus;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final boolean hasEngagementIdentifier() {
        return this.engagementIdentifier != null && !(this.engagementIdentifier instanceof SdkAutoConstructList);
    }

    public final List<String> engagementIdentifier() {
        return this.engagementIdentifier;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasOpportunityIdentifier() {
        return this.opportunityIdentifier != null && !(this.opportunityIdentifier instanceof SdkAutoConstructList);
    }

    public final List<String> opportunityIdentifier() {
        return this.opportunityIdentifier;
    }

    public final ListTasksSortBase sort() {
        return this.sort;
    }

    public final boolean hasTaskIdentifier() {
        return this.taskIdentifier != null && !(this.taskIdentifier instanceof SdkAutoConstructList);
    }

    public final List<String> taskIdentifier() {
        return this.taskIdentifier;
    }

    public final List<TaskStatus> taskStatus() {
        return TaskStatusesCopier.copyStringToEnum(this.taskStatus);
    }

    public final boolean hasTaskStatus() {
        return this.taskStatus != null && !(this.taskStatus instanceof SdkAutoConstructList);
    }

    public final List<String> taskStatusAsStrings() {
        return this.taskStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEngagementIdentifier() ? this.engagementIdentifier() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOpportunityIdentifier() ? this.opportunityIdentifier() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sort());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaskIdentifier() ? this.taskIdentifier() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaskStatus() ? this.taskStatusAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEngagementFromOpportunityTasksRequest)) {
            return false;
        }
        ListEngagementFromOpportunityTasksRequest other = (ListEngagementFromOpportunityTasksRequest)((Object)obj);
        return Objects.equals(this.catalog(), other.catalog()) && this.hasEngagementIdentifier() == other.hasEngagementIdentifier() && Objects.equals(this.engagementIdentifier(), other.engagementIdentifier()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasOpportunityIdentifier() == other.hasOpportunityIdentifier() && Objects.equals(this.opportunityIdentifier(), other.opportunityIdentifier()) && Objects.equals(this.sort(), other.sort()) && this.hasTaskIdentifier() == other.hasTaskIdentifier() && Objects.equals(this.taskIdentifier(), other.taskIdentifier()) && this.hasTaskStatus() == other.hasTaskStatus() && Objects.equals(this.taskStatusAsStrings(), other.taskStatusAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ListEngagementFromOpportunityTasksRequest").add("Catalog", (Object)this.catalog()).add("EngagementIdentifier", this.hasEngagementIdentifier() ? this.engagementIdentifier() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("OpportunityIdentifier", this.hasOpportunityIdentifier() ? this.opportunityIdentifier() : null).add("Sort", (Object)this.sort()).add("TaskIdentifier", this.hasTaskIdentifier() ? this.taskIdentifier() : null).add("TaskStatus", this.hasTaskStatus() ? this.taskStatusAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "EngagementIdentifier": {
                return Optional.ofNullable(clazz.cast(this.engagementIdentifier()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "OpportunityIdentifier": {
                return Optional.ofNullable(clazz.cast(this.opportunityIdentifier()));
            }
            case "Sort": {
                return Optional.ofNullable(clazz.cast(this.sort()));
            }
            case "TaskIdentifier": {
                return Optional.ofNullable(clazz.cast(this.taskIdentifier()));
            }
            case "TaskStatus": {
                return Optional.ofNullable(clazz.cast(this.taskStatusAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("EngagementIdentifier", ENGAGEMENT_IDENTIFIER_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("OpportunityIdentifier", OPPORTUNITY_IDENTIFIER_FIELD);
        map.put("Sort", SORT_FIELD);
        map.put("TaskIdentifier", TASK_IDENTIFIER_FIELD);
        map.put("TaskStatus", TASK_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEngagementFromOpportunityTasksRequest, T> g) {
        return obj -> g.apply((ListEngagementFromOpportunityTasksRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralSellingRequest.BuilderImpl
    implements Builder {
        private String catalog;
        private List<String> engagementIdentifier = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;
        private List<String> opportunityIdentifier = DefaultSdkAutoConstructList.getInstance();
        private ListTasksSortBase sort;
        private List<String> taskIdentifier = DefaultSdkAutoConstructList.getInstance();
        private List<String> taskStatus = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEngagementFromOpportunityTasksRequest model) {
            super(model);
            this.catalog(model.catalog);
            this.engagementIdentifier(model.engagementIdentifier);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.opportunityIdentifier(model.opportunityIdentifier);
            this.sort(model.sort);
            this.taskIdentifier(model.taskIdentifier);
            this.taskStatusWithStrings(model.taskStatus);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final Collection<String> getEngagementIdentifier() {
            if (this.engagementIdentifier instanceof SdkAutoConstructList) {
                return null;
            }
            return this.engagementIdentifier;
        }

        public final void setEngagementIdentifier(Collection<String> engagementIdentifier) {
            this.engagementIdentifier = EngagementIdentifiersCopier.copy(engagementIdentifier);
        }

        @Override
        public final Builder engagementIdentifier(Collection<String> engagementIdentifier) {
            this.engagementIdentifier = EngagementIdentifiersCopier.copy(engagementIdentifier);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engagementIdentifier(String ... engagementIdentifier) {
            this.engagementIdentifier(Arrays.asList(engagementIdentifier));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getOpportunityIdentifier() {
            if (this.opportunityIdentifier instanceof SdkAutoConstructList) {
                return null;
            }
            return this.opportunityIdentifier;
        }

        public final void setOpportunityIdentifier(Collection<String> opportunityIdentifier) {
            this.opportunityIdentifier = OpportunityIdentifiersCopier.copy(opportunityIdentifier);
        }

        @Override
        public final Builder opportunityIdentifier(Collection<String> opportunityIdentifier) {
            this.opportunityIdentifier = OpportunityIdentifiersCopier.copy(opportunityIdentifier);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder opportunityIdentifier(String ... opportunityIdentifier) {
            this.opportunityIdentifier(Arrays.asList(opportunityIdentifier));
            return this;
        }

        public final ListTasksSortBase.Builder getSort() {
            return this.sort != null ? this.sort.toBuilder() : null;
        }

        public final void setSort(ListTasksSortBase.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        public final Builder sort(ListTasksSortBase sort) {
            this.sort = sort;
            return this;
        }

        public final Collection<String> getTaskIdentifier() {
            if (this.taskIdentifier instanceof SdkAutoConstructList) {
                return null;
            }
            return this.taskIdentifier;
        }

        public final void setTaskIdentifier(Collection<String> taskIdentifier) {
            this.taskIdentifier = TaskIdentifiersCopier.copy(taskIdentifier);
        }

        @Override
        public final Builder taskIdentifier(Collection<String> taskIdentifier) {
            this.taskIdentifier = TaskIdentifiersCopier.copy(taskIdentifier);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskIdentifier(String ... taskIdentifier) {
            this.taskIdentifier(Arrays.asList(taskIdentifier));
            return this;
        }

        public final Collection<String> getTaskStatus() {
            if (this.taskStatus instanceof SdkAutoConstructList) {
                return null;
            }
            return this.taskStatus;
        }

        public final void setTaskStatus(Collection<String> taskStatus) {
            this.taskStatus = TaskStatusesCopier.copy(taskStatus);
        }

        @Override
        public final Builder taskStatusWithStrings(Collection<String> taskStatus) {
            this.taskStatus = TaskStatusesCopier.copy(taskStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskStatusWithStrings(String ... taskStatus) {
            this.taskStatusWithStrings(Arrays.asList(taskStatus));
            return this;
        }

        @Override
        public final Builder taskStatus(Collection<TaskStatus> taskStatus) {
            this.taskStatus = TaskStatusesCopier.copyEnumToString(taskStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskStatus(TaskStatus ... taskStatus) {
            this.taskStatus(Arrays.asList(taskStatus));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEngagementFromOpportunityTasksRequest build() {
            return new ListEngagementFromOpportunityTasksRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PartnerCentralSellingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEngagementFromOpportunityTasksRequest> {
        public Builder catalog(String var1);

        public Builder engagementIdentifier(Collection<String> var1);

        public Builder engagementIdentifier(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder opportunityIdentifier(Collection<String> var1);

        public Builder opportunityIdentifier(String ... var1);

        public Builder sort(ListTasksSortBase var1);

        default public Builder sort(Consumer<ListTasksSortBase.Builder> sort) {
            return this.sort((ListTasksSortBase)((ListTasksSortBase.Builder)ListTasksSortBase.builder().applyMutation(sort)).build());
        }

        public Builder taskIdentifier(Collection<String> var1);

        public Builder taskIdentifier(String ... var1);

        public Builder taskStatusWithStrings(Collection<String> var1);

        public Builder taskStatusWithStrings(String ... var1);

        public Builder taskStatus(Collection<TaskStatus> var1);

        public Builder taskStatus(TaskStatus ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

