/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.partnercentralselling.PartnerCentralSellingAsyncClient;
import software.amazon.awssdk.services.partnercentralselling.internal.UserAgentUtils;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementByAcceptingInvitationTaskSummary;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementByAcceptingInvitationTasksRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementByAcceptingInvitationTasksResponse;

public class ListEngagementByAcceptingInvitationTasksPublisher
implements SdkPublisher<ListEngagementByAcceptingInvitationTasksResponse> {
    private final PartnerCentralSellingAsyncClient client;
    private final ListEngagementByAcceptingInvitationTasksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEngagementByAcceptingInvitationTasksPublisher(PartnerCentralSellingAsyncClient client, ListEngagementByAcceptingInvitationTasksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEngagementByAcceptingInvitationTasksPublisher(PartnerCentralSellingAsyncClient client, ListEngagementByAcceptingInvitationTasksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEngagementByAcceptingInvitationTasksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEngagementByAcceptingInvitationTasksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListEngagementByAcceptingInvitationTaskSummary> taskSummaries() {
        Function<ListEngagementByAcceptingInvitationTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.taskSummaries() != null) {
                return response.taskSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEngagementByAcceptingInvitationTasksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEngagementByAcceptingInvitationTasksResponseFetcher
    implements AsyncPageFetcher<ListEngagementByAcceptingInvitationTasksResponse> {
        private ListEngagementByAcceptingInvitationTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListEngagementByAcceptingInvitationTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEngagementByAcceptingInvitationTasksResponse> nextPage(ListEngagementByAcceptingInvitationTasksResponse previousPage) {
            if (previousPage == null) {
                return ListEngagementByAcceptingInvitationTasksPublisher.this.client.listEngagementByAcceptingInvitationTasks(ListEngagementByAcceptingInvitationTasksPublisher.this.firstRequest);
            }
            return ListEngagementByAcceptingInvitationTasksPublisher.this.client.listEngagementByAcceptingInvitationTasks((ListEngagementByAcceptingInvitationTasksRequest)((Object)ListEngagementByAcceptingInvitationTasksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

