/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ReasonCode {
    INVITATION_ACCESS_DENIED("InvitationAccessDenied"),
    INVITATION_VALIDATION_FAILED("InvitationValidationFailed"),
    ENGAGEMENT_ACCESS_DENIED("EngagementAccessDenied"),
    OPPORTUNITY_ACCESS_DENIED("OpportunityAccessDenied"),
    RESOURCE_SNAPSHOT_JOB_ACCESS_DENIED("ResourceSnapshotJobAccessDenied"),
    RESOURCE_SNAPSHOT_JOB_VALIDATION_FAILED("ResourceSnapshotJobValidationFailed"),
    RESOURCE_SNAPSHOT_JOB_CONFLICT("ResourceSnapshotJobConflict"),
    ENGAGEMENT_VALIDATION_FAILED("EngagementValidationFailed"),
    ENGAGEMENT_CONFLICT("EngagementConflict"),
    OPPORTUNITY_SUBMISSION_FAILED("OpportunitySubmissionFailed"),
    ENGAGEMENT_INVITATION_CONFLICT("EngagementInvitationConflict"),
    OPPORTUNITY_VALIDATION_FAILED("OpportunityValidationFailed"),
    OPPORTUNITY_CONFLICT("OpportunityConflict"),
    RESOURCE_SNAPSHOT_ACCESS_DENIED("ResourceSnapshotAccessDenied"),
    RESOURCE_SNAPSHOT_VALIDATION_FAILED("ResourceSnapshotValidationFailed"),
    RESOURCE_SNAPSHOT_CONFLICT("ResourceSnapshotConflict"),
    INTERNAL_ERROR("InternalError"),
    SERVICE_QUOTA_EXCEEDED("ServiceQuotaExceeded"),
    REQUEST_THROTTLED("RequestThrottled"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ReasonCode> VALUE_MAP;
    private final String value;

    private ReasonCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReasonCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReasonCode> knownValues() {
        EnumSet<ReasonCode> knownValues = EnumSet.allOf(ReasonCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ReasonCode.class, ReasonCode::toString);
    }
}

