/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.partnercentralselling.PartnerCentralSellingAsyncClient;
import software.amazon.awssdk.services.partnercentralselling.internal.UserAgentUtils;
import software.amazon.awssdk.services.partnercentralselling.model.EngagementResourceAssociationSummary;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementResourceAssociationsRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementResourceAssociationsResponse;

public class ListEngagementResourceAssociationsPublisher
implements SdkPublisher<ListEngagementResourceAssociationsResponse> {
    private final PartnerCentralSellingAsyncClient client;
    private final ListEngagementResourceAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEngagementResourceAssociationsPublisher(PartnerCentralSellingAsyncClient client, ListEngagementResourceAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEngagementResourceAssociationsPublisher(PartnerCentralSellingAsyncClient client, ListEngagementResourceAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEngagementResourceAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEngagementResourceAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EngagementResourceAssociationSummary> engagementResourceAssociationSummaries() {
        Function<ListEngagementResourceAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.engagementResourceAssociationSummaries() != null) {
                return response.engagementResourceAssociationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEngagementResourceAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEngagementResourceAssociationsResponseFetcher
    implements AsyncPageFetcher<ListEngagementResourceAssociationsResponse> {
        private ListEngagementResourceAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListEngagementResourceAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEngagementResourceAssociationsResponse> nextPage(ListEngagementResourceAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListEngagementResourceAssociationsPublisher.this.client.listEngagementResourceAssociations(ListEngagementResourceAssociationsPublisher.this.firstRequest);
            }
            return ListEngagementResourceAssociationsPublisher.this.client.listEngagementResourceAssociations((ListEngagementResourceAssociationsRequest)((Object)ListEngagementResourceAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

