/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralselling.model.EngagementInvitationIdentifiersCopier;
import software.amazon.awssdk.services.partnercentralselling.model.ListTasksSortBase;
import software.amazon.awssdk.services.partnercentralselling.model.OpportunityIdentifiersCopier;
import software.amazon.awssdk.services.partnercentralselling.model.PartnerCentralSellingRequest;
import software.amazon.awssdk.services.partnercentralselling.model.TaskIdentifiersCopier;
import software.amazon.awssdk.services.partnercentralselling.model.TaskStatus;
import software.amazon.awssdk.services.partnercentralselling.model.TaskStatusesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEngagementByAcceptingInvitationTasksRequest
extends PartnerCentralSellingRequest
implements ToCopyableBuilder<Builder, ListEngagementByAcceptingInvitationTasksRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(ListEngagementByAcceptingInvitationTasksRequest.getter(ListEngagementByAcceptingInvitationTasksRequest::catalog)).setter(ListEngagementByAcceptingInvitationTasksRequest.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<List<String>> ENGAGEMENT_INVITATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EngagementInvitationIdentifier").getter(ListEngagementByAcceptingInvitationTasksRequest.getter(ListEngagementByAcceptingInvitationTasksRequest::engagementInvitationIdentifier)).setter(ListEngagementByAcceptingInvitationTasksRequest.setter(Builder::engagementInvitationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementInvitationIdentifier").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListEngagementByAcceptingInvitationTasksRequest.getter(ListEngagementByAcceptingInvitationTasksRequest::maxResults)).setter(ListEngagementByAcceptingInvitationTasksRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListEngagementByAcceptingInvitationTasksRequest.getter(ListEngagementByAcceptingInvitationTasksRequest::nextToken)).setter(ListEngagementByAcceptingInvitationTasksRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<String>> OPPORTUNITY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OpportunityIdentifier").getter(ListEngagementByAcceptingInvitationTasksRequest.getter(ListEngagementByAcceptingInvitationTasksRequest::opportunityIdentifier)).setter(ListEngagementByAcceptingInvitationTasksRequest.setter(Builder::opportunityIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpportunityIdentifier").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ListTasksSortBase> SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Sort").getter(ListEngagementByAcceptingInvitationTasksRequest.getter(ListEngagementByAcceptingInvitationTasksRequest::sort)).setter(ListEngagementByAcceptingInvitationTasksRequest.setter(Builder::sort)).constructor(ListTasksSortBase::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sort").build()}).build();
    private static final SdkField<List<String>> TASK_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TaskIdentifier").getter(ListEngagementByAcceptingInvitationTasksRequest.getter(ListEngagementByAcceptingInvitationTasksRequest::taskIdentifier)).setter(ListEngagementByAcceptingInvitationTasksRequest.setter(Builder::taskIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskIdentifier").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TASK_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TaskStatus").getter(ListEngagementByAcceptingInvitationTasksRequest.getter(ListEngagementByAcceptingInvitationTasksRequest::taskStatusAsStrings)).setter(ListEngagementByAcceptingInvitationTasksRequest.setter(Builder::taskStatusWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskStatus").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, ENGAGEMENT_INVITATION_IDENTIFIER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, OPPORTUNITY_IDENTIFIER_FIELD, SORT_FIELD, TASK_IDENTIFIER_FIELD, TASK_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Catalog", CATALOG_FIELD);
            this.put("EngagementInvitationIdentifier", ENGAGEMENT_INVITATION_IDENTIFIER_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("OpportunityIdentifier", OPPORTUNITY_IDENTIFIER_FIELD);
            this.put("Sort", SORT_FIELD);
            this.put("TaskIdentifier", TASK_IDENTIFIER_FIELD);
            this.put("TaskStatus", TASK_STATUS_FIELD);
        }
    });
    private final String catalog;
    private final List<String> engagementInvitationIdentifier;
    private final Integer maxResults;
    private final String nextToken;
    private final List<String> opportunityIdentifier;
    private final ListTasksSortBase sort;
    private final List<String> taskIdentifier;
    private final List<String> taskStatus;

    private ListEngagementByAcceptingInvitationTasksRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.engagementInvitationIdentifier = builder.engagementInvitationIdentifier;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.opportunityIdentifier = builder.opportunityIdentifier;
        this.sort = builder.sort;
        this.taskIdentifier = builder.taskIdentifier;
        this.taskStatus = builder.taskStatus;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final boolean hasEngagementInvitationIdentifier() {
        return this.engagementInvitationIdentifier != null && !(this.engagementInvitationIdentifier instanceof SdkAutoConstructList);
    }

    public final List<String> engagementInvitationIdentifier() {
        return this.engagementInvitationIdentifier;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasOpportunityIdentifier() {
        return this.opportunityIdentifier != null && !(this.opportunityIdentifier instanceof SdkAutoConstructList);
    }

    public final List<String> opportunityIdentifier() {
        return this.opportunityIdentifier;
    }

    public final ListTasksSortBase sort() {
        return this.sort;
    }

    public final boolean hasTaskIdentifier() {
        return this.taskIdentifier != null && !(this.taskIdentifier instanceof SdkAutoConstructList);
    }

    public final List<String> taskIdentifier() {
        return this.taskIdentifier;
    }

    public final List<TaskStatus> taskStatus() {
        return TaskStatusesCopier.copyStringToEnum(this.taskStatus);
    }

    public final boolean hasTaskStatus() {
        return this.taskStatus != null && !(this.taskStatus instanceof SdkAutoConstructList);
    }

    public final List<String> taskStatusAsStrings() {
        return this.taskStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEngagementInvitationIdentifier() ? this.engagementInvitationIdentifier() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOpportunityIdentifier() ? this.opportunityIdentifier() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sort());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaskIdentifier() ? this.taskIdentifier() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaskStatus() ? this.taskStatusAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEngagementByAcceptingInvitationTasksRequest)) {
            return false;
        }
        ListEngagementByAcceptingInvitationTasksRequest other = (ListEngagementByAcceptingInvitationTasksRequest)((Object)obj);
        return Objects.equals(this.catalog(), other.catalog()) && this.hasEngagementInvitationIdentifier() == other.hasEngagementInvitationIdentifier() && Objects.equals(this.engagementInvitationIdentifier(), other.engagementInvitationIdentifier()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasOpportunityIdentifier() == other.hasOpportunityIdentifier() && Objects.equals(this.opportunityIdentifier(), other.opportunityIdentifier()) && Objects.equals(this.sort(), other.sort()) && this.hasTaskIdentifier() == other.hasTaskIdentifier() && Objects.equals(this.taskIdentifier(), other.taskIdentifier()) && this.hasTaskStatus() == other.hasTaskStatus() && Objects.equals(this.taskStatusAsStrings(), other.taskStatusAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ListEngagementByAcceptingInvitationTasksRequest").add("Catalog", (Object)this.catalog()).add("EngagementInvitationIdentifier", this.hasEngagementInvitationIdentifier() ? this.engagementInvitationIdentifier() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("OpportunityIdentifier", this.hasOpportunityIdentifier() ? this.opportunityIdentifier() : null).add("Sort", (Object)this.sort()).add("TaskIdentifier", this.hasTaskIdentifier() ? this.taskIdentifier() : null).add("TaskStatus", this.hasTaskStatus() ? this.taskStatusAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "EngagementInvitationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.engagementInvitationIdentifier()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "OpportunityIdentifier": {
                return Optional.ofNullable(clazz.cast(this.opportunityIdentifier()));
            }
            case "Sort": {
                return Optional.ofNullable(clazz.cast(this.sort()));
            }
            case "TaskIdentifier": {
                return Optional.ofNullable(clazz.cast(this.taskIdentifier()));
            }
            case "TaskStatus": {
                return Optional.ofNullable(clazz.cast(this.taskStatusAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListEngagementByAcceptingInvitationTasksRequest, T> g) {
        return obj -> g.apply((ListEngagementByAcceptingInvitationTasksRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralSellingRequest.BuilderImpl
    implements Builder {
        private String catalog;
        private List<String> engagementInvitationIdentifier = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;
        private List<String> opportunityIdentifier = DefaultSdkAutoConstructList.getInstance();
        private ListTasksSortBase sort;
        private List<String> taskIdentifier = DefaultSdkAutoConstructList.getInstance();
        private List<String> taskStatus = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEngagementByAcceptingInvitationTasksRequest model) {
            super(model);
            this.catalog(model.catalog);
            this.engagementInvitationIdentifier(model.engagementInvitationIdentifier);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.opportunityIdentifier(model.opportunityIdentifier);
            this.sort(model.sort);
            this.taskIdentifier(model.taskIdentifier);
            this.taskStatusWithStrings(model.taskStatus);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final Collection<String> getEngagementInvitationIdentifier() {
            if (this.engagementInvitationIdentifier instanceof SdkAutoConstructList) {
                return null;
            }
            return this.engagementInvitationIdentifier;
        }

        public final void setEngagementInvitationIdentifier(Collection<String> engagementInvitationIdentifier) {
            this.engagementInvitationIdentifier = EngagementInvitationIdentifiersCopier.copy(engagementInvitationIdentifier);
        }

        @Override
        public final Builder engagementInvitationIdentifier(Collection<String> engagementInvitationIdentifier) {
            this.engagementInvitationIdentifier = EngagementInvitationIdentifiersCopier.copy(engagementInvitationIdentifier);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engagementInvitationIdentifier(String ... engagementInvitationIdentifier) {
            this.engagementInvitationIdentifier(Arrays.asList(engagementInvitationIdentifier));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getOpportunityIdentifier() {
            if (this.opportunityIdentifier instanceof SdkAutoConstructList) {
                return null;
            }
            return this.opportunityIdentifier;
        }

        public final void setOpportunityIdentifier(Collection<String> opportunityIdentifier) {
            this.opportunityIdentifier = OpportunityIdentifiersCopier.copy(opportunityIdentifier);
        }

        @Override
        public final Builder opportunityIdentifier(Collection<String> opportunityIdentifier) {
            this.opportunityIdentifier = OpportunityIdentifiersCopier.copy(opportunityIdentifier);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder opportunityIdentifier(String ... opportunityIdentifier) {
            this.opportunityIdentifier(Arrays.asList(opportunityIdentifier));
            return this;
        }

        public final ListTasksSortBase.Builder getSort() {
            return this.sort != null ? this.sort.toBuilder() : null;
        }

        public final void setSort(ListTasksSortBase.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        public final Builder sort(ListTasksSortBase sort) {
            this.sort = sort;
            return this;
        }

        public final Collection<String> getTaskIdentifier() {
            if (this.taskIdentifier instanceof SdkAutoConstructList) {
                return null;
            }
            return this.taskIdentifier;
        }

        public final void setTaskIdentifier(Collection<String> taskIdentifier) {
            this.taskIdentifier = TaskIdentifiersCopier.copy(taskIdentifier);
        }

        @Override
        public final Builder taskIdentifier(Collection<String> taskIdentifier) {
            this.taskIdentifier = TaskIdentifiersCopier.copy(taskIdentifier);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskIdentifier(String ... taskIdentifier) {
            this.taskIdentifier(Arrays.asList(taskIdentifier));
            return this;
        }

        public final Collection<String> getTaskStatus() {
            if (this.taskStatus instanceof SdkAutoConstructList) {
                return null;
            }
            return this.taskStatus;
        }

        public final void setTaskStatus(Collection<String> taskStatus) {
            this.taskStatus = TaskStatusesCopier.copy(taskStatus);
        }

        @Override
        public final Builder taskStatusWithStrings(Collection<String> taskStatus) {
            this.taskStatus = TaskStatusesCopier.copy(taskStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskStatusWithStrings(String ... taskStatus) {
            this.taskStatusWithStrings(Arrays.asList(taskStatus));
            return this;
        }

        @Override
        public final Builder taskStatus(Collection<TaskStatus> taskStatus) {
            this.taskStatus = TaskStatusesCopier.copyEnumToString(taskStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskStatus(TaskStatus ... taskStatus) {
            this.taskStatus(Arrays.asList(taskStatus));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEngagementByAcceptingInvitationTasksRequest build() {
            return new ListEngagementByAcceptingInvitationTasksRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PartnerCentralSellingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEngagementByAcceptingInvitationTasksRequest> {
        public Builder catalog(String var1);

        public Builder engagementInvitationIdentifier(Collection<String> var1);

        public Builder engagementInvitationIdentifier(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder opportunityIdentifier(Collection<String> var1);

        public Builder opportunityIdentifier(String ... var1);

        public Builder sort(ListTasksSortBase var1);

        default public Builder sort(Consumer<ListTasksSortBase.Builder> sort) {
            return this.sort((ListTasksSortBase)((ListTasksSortBase.Builder)ListTasksSortBase.builder().applyMutation(sort)).build());
        }

        public Builder taskIdentifier(Collection<String> var1);

        public Builder taskIdentifier(String ... var1);

        public Builder taskStatusWithStrings(Collection<String> var1);

        public Builder taskStatusWithStrings(String ... var1);

        public Builder taskStatus(Collection<TaskStatus> var1);

        public Builder taskStatus(TaskStatus ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

