/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralselling.model.PartnerCentralSellingResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ResourceSnapshotJobStatus;
import software.amazon.awssdk.services.partnercentralselling.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourceSnapshotJobResponse
extends PartnerCentralSellingResponse
implements ToCopyableBuilder<Builder, GetResourceSnapshotJobResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetResourceSnapshotJobResponse.getter(GetResourceSnapshotJobResponse::arn)).setter(GetResourceSnapshotJobResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(GetResourceSnapshotJobResponse.getter(GetResourceSnapshotJobResponse::catalog)).setter(GetResourceSnapshotJobResponse.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(GetResourceSnapshotJobResponse.getter(GetResourceSnapshotJobResponse::createdAt)).setter(GetResourceSnapshotJobResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> ENGAGEMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngagementId").getter(GetResourceSnapshotJobResponse.getter(GetResourceSnapshotJobResponse::engagementId)).setter(GetResourceSnapshotJobResponse.setter(Builder::engagementId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(GetResourceSnapshotJobResponse.getter(GetResourceSnapshotJobResponse::id)).setter(GetResourceSnapshotJobResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> LAST_FAILURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastFailure").getter(GetResourceSnapshotJobResponse.getter(GetResourceSnapshotJobResponse::lastFailure)).setter(GetResourceSnapshotJobResponse.setter(Builder::lastFailure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastFailure").build()}).build();
    private static final SdkField<Instant> LAST_SUCCESSFUL_EXECUTION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastSuccessfulExecutionDate").getter(GetResourceSnapshotJobResponse.getter(GetResourceSnapshotJobResponse::lastSuccessfulExecutionDate)).setter(GetResourceSnapshotJobResponse.setter(Builder::lastSuccessfulExecutionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSuccessfulExecutionDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(GetResourceSnapshotJobResponse.getter(GetResourceSnapshotJobResponse::resourceArn)).setter(GetResourceSnapshotJobResponse.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(GetResourceSnapshotJobResponse.getter(GetResourceSnapshotJobResponse::resourceId)).setter(GetResourceSnapshotJobResponse.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> RESOURCE_SNAPSHOT_TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceSnapshotTemplateName").getter(GetResourceSnapshotJobResponse.getter(GetResourceSnapshotJobResponse::resourceSnapshotTemplateName)).setter(GetResourceSnapshotJobResponse.setter(Builder::resourceSnapshotTemplateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSnapshotTemplateName").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(GetResourceSnapshotJobResponse.getter(GetResourceSnapshotJobResponse::resourceTypeAsString)).setter(GetResourceSnapshotJobResponse.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetResourceSnapshotJobResponse.getter(GetResourceSnapshotJobResponse::statusAsString)).setter(GetResourceSnapshotJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CATALOG_FIELD, CREATED_AT_FIELD, ENGAGEMENT_ID_FIELD, ID_FIELD, LAST_FAILURE_FIELD, LAST_SUCCESSFUL_EXECUTION_DATE_FIELD, RESOURCE_ARN_FIELD, RESOURCE_ID_FIELD, RESOURCE_SNAPSHOT_TEMPLATE_NAME_FIELD, RESOURCE_TYPE_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Arn", ARN_FIELD);
            this.put("Catalog", CATALOG_FIELD);
            this.put("CreatedAt", CREATED_AT_FIELD);
            this.put("EngagementId", ENGAGEMENT_ID_FIELD);
            this.put("Id", ID_FIELD);
            this.put("LastFailure", LAST_FAILURE_FIELD);
            this.put("LastSuccessfulExecutionDate", LAST_SUCCESSFUL_EXECUTION_DATE_FIELD);
            this.put("ResourceArn", RESOURCE_ARN_FIELD);
            this.put("ResourceId", RESOURCE_ID_FIELD);
            this.put("ResourceSnapshotTemplateName", RESOURCE_SNAPSHOT_TEMPLATE_NAME_FIELD);
            this.put("ResourceType", RESOURCE_TYPE_FIELD);
            this.put("Status", STATUS_FIELD);
        }
    });
    private final String arn;
    private final String catalog;
    private final Instant createdAt;
    private final String engagementId;
    private final String id;
    private final String lastFailure;
    private final Instant lastSuccessfulExecutionDate;
    private final String resourceArn;
    private final String resourceId;
    private final String resourceSnapshotTemplateName;
    private final String resourceType;
    private final String status;

    private GetResourceSnapshotJobResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.catalog = builder.catalog;
        this.createdAt = builder.createdAt;
        this.engagementId = builder.engagementId;
        this.id = builder.id;
        this.lastFailure = builder.lastFailure;
        this.lastSuccessfulExecutionDate = builder.lastSuccessfulExecutionDate;
        this.resourceArn = builder.resourceArn;
        this.resourceId = builder.resourceId;
        this.resourceSnapshotTemplateName = builder.resourceSnapshotTemplateName;
        this.resourceType = builder.resourceType;
        this.status = builder.status;
    }

    public final String arn() {
        return this.arn;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String engagementId() {
        return this.engagementId;
    }

    public final String id() {
        return this.id;
    }

    public final String lastFailure() {
        return this.lastFailure;
    }

    public final Instant lastSuccessfulExecutionDate() {
        return this.lastSuccessfulExecutionDate;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String resourceSnapshotTemplateName() {
        return this.resourceSnapshotTemplateName;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final ResourceSnapshotJobStatus status() {
        return ResourceSnapshotJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.engagementId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastFailure());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSuccessfulExecutionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSnapshotTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceSnapshotJobResponse)) {
            return false;
        }
        GetResourceSnapshotJobResponse other = (GetResourceSnapshotJobResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.engagementId(), other.engagementId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lastFailure(), other.lastFailure()) && Objects.equals(this.lastSuccessfulExecutionDate(), other.lastSuccessfulExecutionDate()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceSnapshotTemplateName(), other.resourceSnapshotTemplateName()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourceSnapshotJobResponse").add("Arn", (Object)this.arn()).add("Catalog", (Object)this.catalog()).add("CreatedAt", (Object)this.createdAt()).add("EngagementId", (Object)this.engagementId()).add("Id", (Object)this.id()).add("LastFailure", (Object)this.lastFailure()).add("LastSuccessfulExecutionDate", (Object)this.lastSuccessfulExecutionDate()).add("ResourceArn", (Object)this.resourceArn()).add("ResourceId", (Object)this.resourceId()).add("ResourceSnapshotTemplateName", (Object)this.resourceSnapshotTemplateName()).add("ResourceType", (Object)this.resourceTypeAsString()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "EngagementId": {
                return Optional.ofNullable(clazz.cast(this.engagementId()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "LastFailure": {
                return Optional.ofNullable(clazz.cast(this.lastFailure()));
            }
            case "LastSuccessfulExecutionDate": {
                return Optional.ofNullable(clazz.cast(this.lastSuccessfulExecutionDate()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ResourceSnapshotTemplateName": {
                return Optional.ofNullable(clazz.cast(this.resourceSnapshotTemplateName()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceSnapshotJobResponse, T> g) {
        return obj -> g.apply((GetResourceSnapshotJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralSellingResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String catalog;
        private Instant createdAt;
        private String engagementId;
        private String id;
        private String lastFailure;
        private Instant lastSuccessfulExecutionDate;
        private String resourceArn;
        private String resourceId;
        private String resourceSnapshotTemplateName;
        private String resourceType;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceSnapshotJobResponse model) {
            super(model);
            this.arn(model.arn);
            this.catalog(model.catalog);
            this.createdAt(model.createdAt);
            this.engagementId(model.engagementId);
            this.id(model.id);
            this.lastFailure(model.lastFailure);
            this.lastSuccessfulExecutionDate(model.lastSuccessfulExecutionDate);
            this.resourceArn(model.resourceArn);
            this.resourceId(model.resourceId);
            this.resourceSnapshotTemplateName(model.resourceSnapshotTemplateName);
            this.resourceType(model.resourceType);
            this.status(model.status);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getEngagementId() {
            return this.engagementId;
        }

        public final void setEngagementId(String engagementId) {
            this.engagementId = engagementId;
        }

        @Override
        public final Builder engagementId(String engagementId) {
            this.engagementId = engagementId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getLastFailure() {
            return this.lastFailure;
        }

        public final void setLastFailure(String lastFailure) {
            this.lastFailure = lastFailure;
        }

        @Override
        public final Builder lastFailure(String lastFailure) {
            this.lastFailure = lastFailure;
            return this;
        }

        public final Instant getLastSuccessfulExecutionDate() {
            return this.lastSuccessfulExecutionDate;
        }

        public final void setLastSuccessfulExecutionDate(Instant lastSuccessfulExecutionDate) {
            this.lastSuccessfulExecutionDate = lastSuccessfulExecutionDate;
        }

        @Override
        public final Builder lastSuccessfulExecutionDate(Instant lastSuccessfulExecutionDate) {
            this.lastSuccessfulExecutionDate = lastSuccessfulExecutionDate;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceSnapshotTemplateName() {
            return this.resourceSnapshotTemplateName;
        }

        public final void setResourceSnapshotTemplateName(String resourceSnapshotTemplateName) {
            this.resourceSnapshotTemplateName = resourceSnapshotTemplateName;
        }

        @Override
        public final Builder resourceSnapshotTemplateName(String resourceSnapshotTemplateName) {
            this.resourceSnapshotTemplateName = resourceSnapshotTemplateName;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceSnapshotJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetResourceSnapshotJobResponse build() {
            return new GetResourceSnapshotJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PartnerCentralSellingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourceSnapshotJobResponse> {
        public Builder arn(String var1);

        public Builder catalog(String var1);

        public Builder createdAt(Instant var1);

        public Builder engagementId(String var1);

        public Builder id(String var1);

        public Builder lastFailure(String var1);

        public Builder lastSuccessfulExecutionDate(Instant var1);

        public Builder resourceArn(String var1);

        public Builder resourceId(String var1);

        public Builder resourceSnapshotTemplateName(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder status(String var1);

        public Builder status(ResourceSnapshotJobStatus var1);
    }
}

