/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.partnercentralselling.PartnerCentralSellingClient;
import software.amazon.awssdk.services.partnercentralselling.PartnerCentralSellingServiceClientConfiguration;
import software.amazon.awssdk.services.partnercentralselling.internal.PartnerCentralSellingServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.partnercentralselling.model.AccessDeniedException;
import software.amazon.awssdk.services.partnercentralselling.model.AssignOpportunityRequest;
import software.amazon.awssdk.services.partnercentralselling.model.AssignOpportunityResponse;
import software.amazon.awssdk.services.partnercentralselling.model.AssociateOpportunityRequest;
import software.amazon.awssdk.services.partnercentralselling.model.AssociateOpportunityResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ConflictException;
import software.amazon.awssdk.services.partnercentralselling.model.CreateOpportunityRequest;
import software.amazon.awssdk.services.partnercentralselling.model.CreateOpportunityResponse;
import software.amazon.awssdk.services.partnercentralselling.model.DisassociateOpportunityRequest;
import software.amazon.awssdk.services.partnercentralselling.model.DisassociateOpportunityResponse;
import software.amazon.awssdk.services.partnercentralselling.model.GetAwsOpportunitySummaryRequest;
import software.amazon.awssdk.services.partnercentralselling.model.GetAwsOpportunitySummaryResponse;
import software.amazon.awssdk.services.partnercentralselling.model.GetEngagementInvitationRequest;
import software.amazon.awssdk.services.partnercentralselling.model.GetEngagementInvitationResponse;
import software.amazon.awssdk.services.partnercentralselling.model.GetOpportunityRequest;
import software.amazon.awssdk.services.partnercentralselling.model.GetOpportunityResponse;
import software.amazon.awssdk.services.partnercentralselling.model.InternalServerException;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementInvitationsRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementInvitationsResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ListOpportunitiesRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListOpportunitiesResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ListSolutionsRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListSolutionsResponse;
import software.amazon.awssdk.services.partnercentralselling.model.PartnerCentralSellingException;
import software.amazon.awssdk.services.partnercentralselling.model.RejectEngagementInvitationRequest;
import software.amazon.awssdk.services.partnercentralselling.model.RejectEngagementInvitationResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ResourceNotFoundException;
import software.amazon.awssdk.services.partnercentralselling.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.partnercentralselling.model.StartEngagementByAcceptingInvitationTaskRequest;
import software.amazon.awssdk.services.partnercentralselling.model.StartEngagementByAcceptingInvitationTaskResponse;
import software.amazon.awssdk.services.partnercentralselling.model.StartEngagementFromOpportunityTaskRequest;
import software.amazon.awssdk.services.partnercentralselling.model.StartEngagementFromOpportunityTaskResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ThrottlingException;
import software.amazon.awssdk.services.partnercentralselling.model.UpdateOpportunityRequest;
import software.amazon.awssdk.services.partnercentralselling.model.UpdateOpportunityResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ValidationException;
import software.amazon.awssdk.services.partnercentralselling.transform.AssignOpportunityRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.AssociateOpportunityRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.CreateOpportunityRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.DisassociateOpportunityRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.GetAwsOpportunitySummaryRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.GetEngagementInvitationRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.GetOpportunityRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.ListEngagementInvitationsRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.ListOpportunitiesRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.ListSolutionsRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.RejectEngagementInvitationRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.StartEngagementByAcceptingInvitationTaskRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.StartEngagementFromOpportunityTaskRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.UpdateOpportunityRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultPartnerCentralSellingClient
implements PartnerCentralSellingClient {
    private static final Logger log = Logger.loggerFor(DefaultPartnerCentralSellingClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultPartnerCentralSellingClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssignOpportunityResponse assignOpportunity(AssignOpportunityRequest assignOpportunityRequest) throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssignOpportunityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)assignOpportunityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPartnerCentralSellingClient.resolveMetricPublishers(clientConfiguration, assignOpportunityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssignOpportunity");
            AssignOpportunityResponse assignOpportunityResponse = (AssignOpportunityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssignOpportunity").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)assignOpportunityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssignOpportunityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return assignOpportunityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPartnerCentralSellingClient.lambda$assignOpportunity$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateOpportunityResponse associateOpportunity(AssociateOpportunityRequest associateOpportunityRequest) throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateOpportunityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateOpportunityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPartnerCentralSellingClient.resolveMetricPublishers(clientConfiguration, associateOpportunityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateOpportunity");
            AssociateOpportunityResponse associateOpportunityResponse = (AssociateOpportunityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateOpportunity").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)associateOpportunityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateOpportunityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateOpportunityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPartnerCentralSellingClient.lambda$associateOpportunity$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateOpportunityResponse createOpportunity(CreateOpportunityRequest createOpportunityRequest) throws ThrottlingException, ConflictException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateOpportunityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createOpportunityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPartnerCentralSellingClient.resolveMetricPublishers(clientConfiguration, createOpportunityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateOpportunity");
            CreateOpportunityResponse createOpportunityResponse = (CreateOpportunityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateOpportunity").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createOpportunityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateOpportunityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createOpportunityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPartnerCentralSellingClient.lambda$createOpportunity$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateOpportunityResponse disassociateOpportunity(DisassociateOpportunityRequest disassociateOpportunityRequest) throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateOpportunityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociateOpportunityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPartnerCentralSellingClient.resolveMetricPublishers(clientConfiguration, disassociateOpportunityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateOpportunity");
            DisassociateOpportunityResponse disassociateOpportunityResponse = (DisassociateOpportunityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateOpportunity").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disassociateOpportunityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateOpportunityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateOpportunityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPartnerCentralSellingClient.lambda$disassociateOpportunity$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAwsOpportunitySummaryResponse getAwsOpportunitySummary(GetAwsOpportunitySummaryRequest getAwsOpportunitySummaryRequest) throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAwsOpportunitySummaryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAwsOpportunitySummaryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPartnerCentralSellingClient.resolveMetricPublishers(clientConfiguration, getAwsOpportunitySummaryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAwsOpportunitySummary");
            GetAwsOpportunitySummaryResponse getAwsOpportunitySummaryResponse = (GetAwsOpportunitySummaryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAwsOpportunitySummary").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAwsOpportunitySummaryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAwsOpportunitySummaryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAwsOpportunitySummaryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPartnerCentralSellingClient.lambda$getAwsOpportunitySummary$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEngagementInvitationResponse getEngagementInvitation(GetEngagementInvitationRequest getEngagementInvitationRequest) throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEngagementInvitationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getEngagementInvitationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPartnerCentralSellingClient.resolveMetricPublishers(clientConfiguration, getEngagementInvitationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEngagementInvitation");
            GetEngagementInvitationResponse getEngagementInvitationResponse = (GetEngagementInvitationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEngagementInvitation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getEngagementInvitationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetEngagementInvitationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getEngagementInvitationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPartnerCentralSellingClient.lambda$getEngagementInvitation$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetOpportunityResponse getOpportunity(GetOpportunityRequest getOpportunityRequest) throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetOpportunityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getOpportunityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPartnerCentralSellingClient.resolveMetricPublishers(clientConfiguration, getOpportunityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetOpportunity");
            GetOpportunityResponse getOpportunityResponse = (GetOpportunityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetOpportunity").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getOpportunityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetOpportunityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getOpportunityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPartnerCentralSellingClient.lambda$getOpportunity$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEngagementInvitationsResponse listEngagementInvitations(ListEngagementInvitationsRequest listEngagementInvitationsRequest) throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEngagementInvitationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listEngagementInvitationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPartnerCentralSellingClient.resolveMetricPublishers(clientConfiguration, listEngagementInvitationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEngagementInvitations");
            ListEngagementInvitationsResponse listEngagementInvitationsResponse = (ListEngagementInvitationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEngagementInvitations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listEngagementInvitationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEngagementInvitationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEngagementInvitationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPartnerCentralSellingClient.lambda$listEngagementInvitations$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListOpportunitiesResponse listOpportunities(ListOpportunitiesRequest listOpportunitiesRequest) throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListOpportunitiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listOpportunitiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPartnerCentralSellingClient.resolveMetricPublishers(clientConfiguration, listOpportunitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListOpportunities");
            ListOpportunitiesResponse listOpportunitiesResponse = (ListOpportunitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListOpportunities").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listOpportunitiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListOpportunitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listOpportunitiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPartnerCentralSellingClient.lambda$listOpportunities$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSolutionsResponse listSolutions(ListSolutionsRequest listSolutionsRequest) throws AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSolutionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSolutionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPartnerCentralSellingClient.resolveMetricPublishers(clientConfiguration, listSolutionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSolutions");
            ListSolutionsResponse listSolutionsResponse = (ListSolutionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSolutions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listSolutionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSolutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSolutionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPartnerCentralSellingClient.lambda$listSolutions$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RejectEngagementInvitationResponse rejectEngagementInvitation(RejectEngagementInvitationRequest rejectEngagementInvitationRequest) throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RejectEngagementInvitationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)rejectEngagementInvitationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPartnerCentralSellingClient.resolveMetricPublishers(clientConfiguration, rejectEngagementInvitationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RejectEngagementInvitation");
            RejectEngagementInvitationResponse rejectEngagementInvitationResponse = (RejectEngagementInvitationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RejectEngagementInvitation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)rejectEngagementInvitationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RejectEngagementInvitationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return rejectEngagementInvitationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPartnerCentralSellingClient.lambda$rejectEngagementInvitation$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartEngagementByAcceptingInvitationTaskResponse startEngagementByAcceptingInvitationTask(StartEngagementByAcceptingInvitationTaskRequest startEngagementByAcceptingInvitationTaskRequest) throws ThrottlingException, ConflictException, AccessDeniedException, InternalServerException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartEngagementByAcceptingInvitationTaskResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startEngagementByAcceptingInvitationTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPartnerCentralSellingClient.resolveMetricPublishers(clientConfiguration, startEngagementByAcceptingInvitationTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartEngagementByAcceptingInvitationTask");
            StartEngagementByAcceptingInvitationTaskResponse startEngagementByAcceptingInvitationTaskResponse = (StartEngagementByAcceptingInvitationTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartEngagementByAcceptingInvitationTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startEngagementByAcceptingInvitationTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartEngagementByAcceptingInvitationTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startEngagementByAcceptingInvitationTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPartnerCentralSellingClient.lambda$startEngagementByAcceptingInvitationTask$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartEngagementFromOpportunityTaskResponse startEngagementFromOpportunityTask(StartEngagementFromOpportunityTaskRequest startEngagementFromOpportunityTaskRequest) throws ThrottlingException, ConflictException, AccessDeniedException, InternalServerException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartEngagementFromOpportunityTaskResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startEngagementFromOpportunityTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPartnerCentralSellingClient.resolveMetricPublishers(clientConfiguration, startEngagementFromOpportunityTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartEngagementFromOpportunityTask");
            StartEngagementFromOpportunityTaskResponse startEngagementFromOpportunityTaskResponse = (StartEngagementFromOpportunityTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartEngagementFromOpportunityTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startEngagementFromOpportunityTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartEngagementFromOpportunityTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startEngagementFromOpportunityTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPartnerCentralSellingClient.lambda$startEngagementFromOpportunityTask$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateOpportunityResponse updateOpportunity(UpdateOpportunityRequest updateOpportunityRequest) throws ThrottlingException, ConflictException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateOpportunityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateOpportunityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPartnerCentralSellingClient.resolveMetricPublishers(clientConfiguration, updateOpportunityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateOpportunity");
            UpdateOpportunityResponse updateOpportunityResponse = (UpdateOpportunityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateOpportunity").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateOpportunityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateOpportunityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateOpportunityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPartnerCentralSellingClient.lambda$updateOpportunity$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "partnercentral-selling";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        PartnerCentralSellingServiceClientConfigurationBuilder serviceConfigBuilder = new PartnerCentralSellingServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(PartnerCentralSellingException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.0").registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    @Override
    public final PartnerCentralSellingServiceClientConfiguration serviceClientConfiguration() {
        return new PartnerCentralSellingServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateOpportunity$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startEngagementFromOpportunityTask$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startEngagementByAcceptingInvitationTask$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rejectEngagementInvitation$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSolutions$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listOpportunities$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEngagementInvitations$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getOpportunity$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEngagementInvitation$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAwsOpportunitySummary$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateOpportunity$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createOpportunity$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateOpportunity$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$assignOpportunity$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

