/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralselling.model.EngagementInvitationPayloadType;
import software.amazon.awssdk.services.partnercentralselling.model.InvitationStatus;
import software.amazon.awssdk.services.partnercentralselling.model.PartnerCentralSellingResponse;
import software.amazon.awssdk.services.partnercentralselling.model.Payload;
import software.amazon.awssdk.services.partnercentralselling.model.Receiver;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEngagementInvitationResponse
extends PartnerCentralSellingResponse
implements ToCopyableBuilder<Builder, GetEngagementInvitationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetEngagementInvitationResponse.getter(GetEngagementInvitationResponse::arn)).setter(GetEngagementInvitationResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(GetEngagementInvitationResponse.getter(GetEngagementInvitationResponse::catalog)).setter(GetEngagementInvitationResponse.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<String> ENGAGEMENT_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngagementTitle").getter(GetEngagementInvitationResponse.getter(GetEngagementInvitationResponse::engagementTitle)).setter(GetEngagementInvitationResponse.setter(Builder::engagementTitle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementTitle").build()}).build();
    private static final SdkField<Instant> EXPIRATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpirationDate").getter(GetEngagementInvitationResponse.getter(GetEngagementInvitationResponse::expirationDate)).setter(GetEngagementInvitationResponse.setter(Builder::expirationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(GetEngagementInvitationResponse.getter(GetEngagementInvitationResponse::id)).setter(GetEngagementInvitationResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<Instant> INVITATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("InvitationDate").getter(GetEngagementInvitationResponse.getter(GetEngagementInvitationResponse::invitationDate)).setter(GetEngagementInvitationResponse.setter(Builder::invitationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvitationDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Payload> PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Payload").getter(GetEngagementInvitationResponse.getter(GetEngagementInvitationResponse::payload)).setter(GetEngagementInvitationResponse.setter(Builder::payload)).constructor(Payload::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Payload").build()}).build();
    private static final SdkField<String> PAYLOAD_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PayloadType").getter(GetEngagementInvitationResponse.getter(GetEngagementInvitationResponse::payloadTypeAsString)).setter(GetEngagementInvitationResponse.setter(Builder::payloadType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PayloadType").build()}).build();
    private static final SdkField<Receiver> RECEIVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Receiver").getter(GetEngagementInvitationResponse.getter(GetEngagementInvitationResponse::receiver)).setter(GetEngagementInvitationResponse.setter(Builder::receiver)).constructor(Receiver::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Receiver").build()}).build();
    private static final SdkField<String> REJECTION_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RejectionReason").getter(GetEngagementInvitationResponse.getter(GetEngagementInvitationResponse::rejectionReason)).setter(GetEngagementInvitationResponse.setter(Builder::rejectionReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RejectionReason").build()}).build();
    private static final SdkField<String> SENDER_AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SenderAwsAccountId").getter(GetEngagementInvitationResponse.getter(GetEngagementInvitationResponse::senderAwsAccountId)).setter(GetEngagementInvitationResponse.setter(Builder::senderAwsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderAwsAccountId").build()}).build();
    private static final SdkField<String> SENDER_COMPANY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SenderCompanyName").getter(GetEngagementInvitationResponse.getter(GetEngagementInvitationResponse::senderCompanyName)).setter(GetEngagementInvitationResponse.setter(Builder::senderCompanyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderCompanyName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetEngagementInvitationResponse.getter(GetEngagementInvitationResponse::statusAsString)).setter(GetEngagementInvitationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CATALOG_FIELD, ENGAGEMENT_TITLE_FIELD, EXPIRATION_DATE_FIELD, ID_FIELD, INVITATION_DATE_FIELD, PAYLOAD_FIELD, PAYLOAD_TYPE_FIELD, RECEIVER_FIELD, REJECTION_REASON_FIELD, SENDER_AWS_ACCOUNT_ID_FIELD, SENDER_COMPANY_NAME_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Arn", ARN_FIELD);
            this.put("Catalog", CATALOG_FIELD);
            this.put("EngagementTitle", ENGAGEMENT_TITLE_FIELD);
            this.put("ExpirationDate", EXPIRATION_DATE_FIELD);
            this.put("Id", ID_FIELD);
            this.put("InvitationDate", INVITATION_DATE_FIELD);
            this.put("Payload", PAYLOAD_FIELD);
            this.put("PayloadType", PAYLOAD_TYPE_FIELD);
            this.put("Receiver", RECEIVER_FIELD);
            this.put("RejectionReason", REJECTION_REASON_FIELD);
            this.put("SenderAwsAccountId", SENDER_AWS_ACCOUNT_ID_FIELD);
            this.put("SenderCompanyName", SENDER_COMPANY_NAME_FIELD);
            this.put("Status", STATUS_FIELD);
        }
    });
    private final String arn;
    private final String catalog;
    private final String engagementTitle;
    private final Instant expirationDate;
    private final String id;
    private final Instant invitationDate;
    private final Payload payload;
    private final String payloadType;
    private final Receiver receiver;
    private final String rejectionReason;
    private final String senderAwsAccountId;
    private final String senderCompanyName;
    private final String status;

    private GetEngagementInvitationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.catalog = builder.catalog;
        this.engagementTitle = builder.engagementTitle;
        this.expirationDate = builder.expirationDate;
        this.id = builder.id;
        this.invitationDate = builder.invitationDate;
        this.payload = builder.payload;
        this.payloadType = builder.payloadType;
        this.receiver = builder.receiver;
        this.rejectionReason = builder.rejectionReason;
        this.senderAwsAccountId = builder.senderAwsAccountId;
        this.senderCompanyName = builder.senderCompanyName;
        this.status = builder.status;
    }

    public final String arn() {
        return this.arn;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final String engagementTitle() {
        return this.engagementTitle;
    }

    public final Instant expirationDate() {
        return this.expirationDate;
    }

    public final String id() {
        return this.id;
    }

    public final Instant invitationDate() {
        return this.invitationDate;
    }

    public final Payload payload() {
        return this.payload;
    }

    public final EngagementInvitationPayloadType payloadType() {
        return EngagementInvitationPayloadType.fromValue(this.payloadType);
    }

    public final String payloadTypeAsString() {
        return this.payloadType;
    }

    public final Receiver receiver() {
        return this.receiver;
    }

    public final String rejectionReason() {
        return this.rejectionReason;
    }

    public final String senderAwsAccountId() {
        return this.senderAwsAccountId;
    }

    public final String senderCompanyName() {
        return this.senderCompanyName;
    }

    public final InvitationStatus status() {
        return InvitationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.engagementTitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.invitationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        hashCode = 31 * hashCode + Objects.hashCode(this.payloadTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.receiver());
        hashCode = 31 * hashCode + Objects.hashCode(this.rejectionReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.senderAwsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.senderCompanyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEngagementInvitationResponse)) {
            return false;
        }
        GetEngagementInvitationResponse other = (GetEngagementInvitationResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.engagementTitle(), other.engagementTitle()) && Objects.equals(this.expirationDate(), other.expirationDate()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.invitationDate(), other.invitationDate()) && Objects.equals(this.payload(), other.payload()) && Objects.equals(this.payloadTypeAsString(), other.payloadTypeAsString()) && Objects.equals(this.receiver(), other.receiver()) && Objects.equals(this.rejectionReason(), other.rejectionReason()) && Objects.equals(this.senderAwsAccountId(), other.senderAwsAccountId()) && Objects.equals(this.senderCompanyName(), other.senderCompanyName()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetEngagementInvitationResponse").add("Arn", (Object)this.arn()).add("Catalog", (Object)this.catalog()).add("EngagementTitle", (Object)this.engagementTitle()).add("ExpirationDate", (Object)this.expirationDate()).add("Id", (Object)this.id()).add("InvitationDate", (Object)this.invitationDate()).add("Payload", (Object)this.payload()).add("PayloadType", (Object)this.payloadTypeAsString()).add("Receiver", (Object)this.receiver()).add("RejectionReason", (Object)this.rejectionReason()).add("SenderAwsAccountId", (Object)(this.senderAwsAccountId() == null ? null : "*** Sensitive Data Redacted ***")).add("SenderCompanyName", (Object)this.senderCompanyName()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "EngagementTitle": {
                return Optional.ofNullable(clazz.cast(this.engagementTitle()));
            }
            case "ExpirationDate": {
                return Optional.ofNullable(clazz.cast(this.expirationDate()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "InvitationDate": {
                return Optional.ofNullable(clazz.cast(this.invitationDate()));
            }
            case "Payload": {
                return Optional.ofNullable(clazz.cast(this.payload()));
            }
            case "PayloadType": {
                return Optional.ofNullable(clazz.cast(this.payloadTypeAsString()));
            }
            case "Receiver": {
                return Optional.ofNullable(clazz.cast(this.receiver()));
            }
            case "RejectionReason": {
                return Optional.ofNullable(clazz.cast(this.rejectionReason()));
            }
            case "SenderAwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.senderAwsAccountId()));
            }
            case "SenderCompanyName": {
                return Optional.ofNullable(clazz.cast(this.senderCompanyName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetEngagementInvitationResponse, T> g) {
        return obj -> g.apply((GetEngagementInvitationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralSellingResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String catalog;
        private String engagementTitle;
        private Instant expirationDate;
        private String id;
        private Instant invitationDate;
        private Payload payload;
        private String payloadType;
        private Receiver receiver;
        private String rejectionReason;
        private String senderAwsAccountId;
        private String senderCompanyName;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEngagementInvitationResponse model) {
            super(model);
            this.arn(model.arn);
            this.catalog(model.catalog);
            this.engagementTitle(model.engagementTitle);
            this.expirationDate(model.expirationDate);
            this.id(model.id);
            this.invitationDate(model.invitationDate);
            this.payload(model.payload);
            this.payloadType(model.payloadType);
            this.receiver(model.receiver);
            this.rejectionReason(model.rejectionReason);
            this.senderAwsAccountId(model.senderAwsAccountId);
            this.senderCompanyName(model.senderCompanyName);
            this.status(model.status);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getEngagementTitle() {
            return this.engagementTitle;
        }

        public final void setEngagementTitle(String engagementTitle) {
            this.engagementTitle = engagementTitle;
        }

        @Override
        public final Builder engagementTitle(String engagementTitle) {
            this.engagementTitle = engagementTitle;
            return this;
        }

        public final Instant getExpirationDate() {
            return this.expirationDate;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getInvitationDate() {
            return this.invitationDate;
        }

        public final void setInvitationDate(Instant invitationDate) {
            this.invitationDate = invitationDate;
        }

        @Override
        public final Builder invitationDate(Instant invitationDate) {
            this.invitationDate = invitationDate;
            return this;
        }

        public final Payload.Builder getPayload() {
            return this.payload != null ? this.payload.toBuilder() : null;
        }

        public final void setPayload(Payload.BuilderImpl payload) {
            this.payload = payload != null ? payload.build() : null;
        }

        @Override
        public final Builder payload(Payload payload) {
            this.payload = payload;
            return this;
        }

        public final String getPayloadType() {
            return this.payloadType;
        }

        public final void setPayloadType(String payloadType) {
            this.payloadType = payloadType;
        }

        @Override
        public final Builder payloadType(String payloadType) {
            this.payloadType = payloadType;
            return this;
        }

        @Override
        public final Builder payloadType(EngagementInvitationPayloadType payloadType) {
            this.payloadType(payloadType == null ? null : payloadType.toString());
            return this;
        }

        public final Receiver.Builder getReceiver() {
            return this.receiver != null ? this.receiver.toBuilder() : null;
        }

        public final void setReceiver(Receiver.BuilderImpl receiver) {
            this.receiver = receiver != null ? receiver.build() : null;
        }

        @Override
        public final Builder receiver(Receiver receiver) {
            this.receiver = receiver;
            return this;
        }

        public final String getRejectionReason() {
            return this.rejectionReason;
        }

        public final void setRejectionReason(String rejectionReason) {
            this.rejectionReason = rejectionReason;
        }

        @Override
        public final Builder rejectionReason(String rejectionReason) {
            this.rejectionReason = rejectionReason;
            return this;
        }

        public final String getSenderAwsAccountId() {
            return this.senderAwsAccountId;
        }

        public final void setSenderAwsAccountId(String senderAwsAccountId) {
            this.senderAwsAccountId = senderAwsAccountId;
        }

        @Override
        public final Builder senderAwsAccountId(String senderAwsAccountId) {
            this.senderAwsAccountId = senderAwsAccountId;
            return this;
        }

        public final String getSenderCompanyName() {
            return this.senderCompanyName;
        }

        public final void setSenderCompanyName(String senderCompanyName) {
            this.senderCompanyName = senderCompanyName;
        }

        @Override
        public final Builder senderCompanyName(String senderCompanyName) {
            this.senderCompanyName = senderCompanyName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InvitationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetEngagementInvitationResponse build() {
            return new GetEngagementInvitationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PartnerCentralSellingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEngagementInvitationResponse> {
        public Builder arn(String var1);

        public Builder catalog(String var1);

        public Builder engagementTitle(String var1);

        public Builder expirationDate(Instant var1);

        public Builder id(String var1);

        public Builder invitationDate(Instant var1);

        public Builder payload(Payload var1);

        default public Builder payload(Consumer<Payload.Builder> payload) {
            return this.payload((Payload)((Payload.Builder)Payload.builder().applyMutation(payload)).build());
        }

        public Builder payloadType(String var1);

        public Builder payloadType(EngagementInvitationPayloadType var1);

        public Builder receiver(Receiver var1);

        default public Builder receiver(Consumer<Receiver.Builder> receiver) {
            return this.receiver((Receiver)((Receiver.Builder)Receiver.builder().applyMutation(receiver)).build());
        }

        public Builder rejectionReason(String var1);

        public Builder senderAwsAccountId(String var1);

        public Builder senderCompanyName(String var1);

        public Builder status(String var1);

        public Builder status(InvitationStatus var1);
    }
}

