/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralselling.model.MonetaryValue;
import software.amazon.awssdk.services.partnercentralselling.model.RevenueModel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SoftwareRevenue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SoftwareRevenue> {
    private static final SdkField<String> DELIVERY_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeliveryModel").getter(SoftwareRevenue.getter(SoftwareRevenue::deliveryModelAsString)).setter(SoftwareRevenue.setter(Builder::deliveryModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryModel").build()}).build();
    private static final SdkField<String> EFFECTIVE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EffectiveDate").getter(SoftwareRevenue.getter(SoftwareRevenue::effectiveDate)).setter(SoftwareRevenue.setter(Builder::effectiveDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveDate").build()}).build();
    private static final SdkField<String> EXPIRATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExpirationDate").getter(SoftwareRevenue.getter(SoftwareRevenue::expirationDate)).setter(SoftwareRevenue.setter(Builder::expirationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationDate").build()}).build();
    private static final SdkField<MonetaryValue> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Value").getter(SoftwareRevenue.getter(SoftwareRevenue::value)).setter(SoftwareRevenue.setter(Builder::value)).constructor(MonetaryValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_MODEL_FIELD, EFFECTIVE_DATE_FIELD, EXPIRATION_DATE_FIELD, VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DeliveryModel", DELIVERY_MODEL_FIELD);
            this.put("EffectiveDate", EFFECTIVE_DATE_FIELD);
            this.put("ExpirationDate", EXPIRATION_DATE_FIELD);
            this.put("Value", VALUE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String deliveryModel;
    private final String effectiveDate;
    private final String expirationDate;
    private final MonetaryValue value;

    private SoftwareRevenue(BuilderImpl builder) {
        this.deliveryModel = builder.deliveryModel;
        this.effectiveDate = builder.effectiveDate;
        this.expirationDate = builder.expirationDate;
        this.value = builder.value;
    }

    public final RevenueModel deliveryModel() {
        return RevenueModel.fromValue(this.deliveryModel);
    }

    public final String deliveryModelAsString() {
        return this.deliveryModel;
    }

    public final String effectiveDate() {
        return this.effectiveDate;
    }

    public final String expirationDate() {
        return this.expirationDate;
    }

    public final MonetaryValue value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectiveDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SoftwareRevenue)) {
            return false;
        }
        SoftwareRevenue other = (SoftwareRevenue)obj;
        return Objects.equals(this.deliveryModelAsString(), other.deliveryModelAsString()) && Objects.equals(this.effectiveDate(), other.effectiveDate()) && Objects.equals(this.expirationDate(), other.expirationDate()) && Objects.equals(this.value(), other.value());
    }

    public final String toString() {
        return ToString.builder((String)"SoftwareRevenue").add("DeliveryModel", (Object)this.deliveryModelAsString()).add("EffectiveDate", (Object)this.effectiveDate()).add("ExpirationDate", (Object)this.expirationDate()).add("Value", (Object)this.value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeliveryModel": {
                return Optional.ofNullable(clazz.cast(this.deliveryModelAsString()));
            }
            case "EffectiveDate": {
                return Optional.ofNullable(clazz.cast(this.effectiveDate()));
            }
            case "ExpirationDate": {
                return Optional.ofNullable(clazz.cast(this.expirationDate()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SoftwareRevenue, T> g) {
        return obj -> g.apply((SoftwareRevenue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deliveryModel;
        private String effectiveDate;
        private String expirationDate;
        private MonetaryValue value;

        private BuilderImpl() {
        }

        private BuilderImpl(SoftwareRevenue model) {
            this.deliveryModel(model.deliveryModel);
            this.effectiveDate(model.effectiveDate);
            this.expirationDate(model.expirationDate);
            this.value(model.value);
        }

        public final String getDeliveryModel() {
            return this.deliveryModel;
        }

        public final void setDeliveryModel(String deliveryModel) {
            this.deliveryModel = deliveryModel;
        }

        @Override
        public final Builder deliveryModel(String deliveryModel) {
            this.deliveryModel = deliveryModel;
            return this;
        }

        @Override
        public final Builder deliveryModel(RevenueModel deliveryModel) {
            this.deliveryModel(deliveryModel == null ? null : deliveryModel.toString());
            return this;
        }

        public final String getEffectiveDate() {
            return this.effectiveDate;
        }

        public final void setEffectiveDate(String effectiveDate) {
            this.effectiveDate = effectiveDate;
        }

        @Override
        public final Builder effectiveDate(String effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }

        public final String getExpirationDate() {
            return this.expirationDate;
        }

        public final void setExpirationDate(String expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Override
        public final Builder expirationDate(String expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final MonetaryValue.Builder getValue() {
            return this.value != null ? this.value.toBuilder() : null;
        }

        public final void setValue(MonetaryValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(MonetaryValue value) {
            this.value = value;
            return this;
        }

        public SoftwareRevenue build() {
            return new SoftwareRevenue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SoftwareRevenue> {
        public Builder deliveryModel(String var1);

        public Builder deliveryModel(RevenueModel var1);

        public Builder effectiveDate(String var1);

        public Builder expirationDate(String var1);

        public Builder value(MonetaryValue var1);

        default public Builder value(Consumer<MonetaryValue.Builder> value) {
            return this.value((MonetaryValue)((MonetaryValue.Builder)MonetaryValue.builder().applyMutation(value)).build());
        }
    }
}

