/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralchannel.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HandshakeType {
    START_SERVICE_PERIOD("START_SERVICE_PERIOD"),
    REVOKE_SERVICE_PERIOD("REVOKE_SERVICE_PERIOD"),
    PROGRAM_MANAGEMENT_ACCOUNT("PROGRAM_MANAGEMENT_ACCOUNT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HandshakeType> VALUE_MAP;
    private final String value;

    private HandshakeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HandshakeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HandshakeType> knownValues() {
        EnumSet<HandshakeType> knownValues = EnumSet.allOf(HandshakeType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HandshakeType.class, HandshakeType::toString);
    }
}

