/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralchannel.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Sector {
    COMMERCIAL("COMMERCIAL"),
    GOVERNMENT("GOVERNMENT"),
    GOVERNMENT_EXCEPTION("GOVERNMENT_EXCEPTION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Sector> VALUE_MAP;
    private final String value;

    private Sector(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Sector fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Sector> knownValues() {
        EnumSet<Sector> knownValues = EnumSet.allOf(Sector.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Sector.class, Sector::toString);
    }
}

