/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralchannel.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralchannel.model.Coverage;
import software.amazon.awssdk.services.partnercentralchannel.model.Provider;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PartnerLedSupport
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PartnerLedSupport> {
    private static final SdkField<String> COVERAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("coverage").getter(PartnerLedSupport.getter(PartnerLedSupport::coverageAsString)).setter(PartnerLedSupport.setter(Builder::coverage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("coverage").build()}).build();
    private static final SdkField<String> PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("provider").getter(PartnerLedSupport.getter(PartnerLedSupport::providerAsString)).setter(PartnerLedSupport.setter(Builder::provider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provider").build()}).build();
    private static final SdkField<String> TAM_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tamLocation").getter(PartnerLedSupport.getter(PartnerLedSupport::tamLocation)).setter(PartnerLedSupport.setter(Builder::tamLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tamLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COVERAGE_FIELD, PROVIDER_FIELD, TAM_LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PartnerLedSupport.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String coverage;
    private final String provider;
    private final String tamLocation;

    private PartnerLedSupport(BuilderImpl builder) {
        this.coverage = builder.coverage;
        this.provider = builder.provider;
        this.tamLocation = builder.tamLocation;
    }

    public final Coverage coverage() {
        return Coverage.fromValue(this.coverage);
    }

    public final String coverageAsString() {
        return this.coverage;
    }

    public final Provider provider() {
        return Provider.fromValue(this.provider);
    }

    public final String providerAsString() {
        return this.provider;
    }

    public final String tamLocation() {
        return this.tamLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.coverageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tamLocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartnerLedSupport)) {
            return false;
        }
        PartnerLedSupport other = (PartnerLedSupport)obj;
        return Objects.equals(this.coverageAsString(), other.coverageAsString()) && Objects.equals(this.providerAsString(), other.providerAsString()) && Objects.equals(this.tamLocation(), other.tamLocation());
    }

    public final String toString() {
        return ToString.builder((String)"PartnerLedSupport").add("Coverage", (Object)this.coverageAsString()).add("Provider", (Object)this.providerAsString()).add("TamLocation", (Object)this.tamLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "coverage": {
                return Optional.ofNullable(clazz.cast(this.coverageAsString()));
            }
            case "provider": {
                return Optional.ofNullable(clazz.cast(this.providerAsString()));
            }
            case "tamLocation": {
                return Optional.ofNullable(clazz.cast(this.tamLocation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("coverage", COVERAGE_FIELD);
        map.put("provider", PROVIDER_FIELD);
        map.put("tamLocation", TAM_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PartnerLedSupport, T> g) {
        return obj -> g.apply((PartnerLedSupport)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String coverage;
        private String provider;
        private String tamLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(PartnerLedSupport model) {
            this.coverage(model.coverage);
            this.provider(model.provider);
            this.tamLocation(model.tamLocation);
        }

        public final String getCoverage() {
            return this.coverage;
        }

        public final void setCoverage(String coverage) {
            this.coverage = coverage;
        }

        @Override
        public final Builder coverage(String coverage) {
            this.coverage = coverage;
            return this;
        }

        @Override
        public final Builder coverage(Coverage coverage) {
            this.coverage(coverage == null ? null : coverage.toString());
            return this;
        }

        public final String getProvider() {
            return this.provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        @Override
        public final Builder provider(Provider provider) {
            this.provider(provider == null ? null : provider.toString());
            return this;
        }

        public final String getTamLocation() {
            return this.tamLocation;
        }

        public final void setTamLocation(String tamLocation) {
            this.tamLocation = tamLocation;
        }

        @Override
        public final Builder tamLocation(String tamLocation) {
            this.tamLocation = tamLocation;
            return this;
        }

        public PartnerLedSupport build() {
            return new PartnerLedSupport(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PartnerLedSupport> {
        public Builder coverage(String var1);

        public Builder coverage(Coverage var1);

        public Builder provider(String var1);

        public Builder provider(Provider var1);

        public Builder tamLocation(String var1);
    }
}

