/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralchannel.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.partnercentralchannel.PartnerCentralChannelAsyncClient;
import software.amazon.awssdk.services.partnercentralchannel.internal.UserAgentUtils;
import software.amazon.awssdk.services.partnercentralchannel.model.ListRelationshipsRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.ListRelationshipsResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.RelationshipSummary;

public class ListRelationshipsPublisher
implements SdkPublisher<ListRelationshipsResponse> {
    private final PartnerCentralChannelAsyncClient client;
    private final ListRelationshipsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRelationshipsPublisher(PartnerCentralChannelAsyncClient client, ListRelationshipsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRelationshipsPublisher(PartnerCentralChannelAsyncClient client, ListRelationshipsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRelationshipsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRelationshipsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RelationshipSummary> items() {
        Function<ListRelationshipsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRelationshipsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRelationshipsResponseFetcher
    implements AsyncPageFetcher<ListRelationshipsResponse> {
        private ListRelationshipsResponseFetcher() {
        }

        public boolean hasNextPage(ListRelationshipsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRelationshipsResponse> nextPage(ListRelationshipsResponse previousPage) {
            if (previousPage == null) {
                return ListRelationshipsPublisher.this.client.listRelationships(ListRelationshipsPublisher.this.firstRequest);
            }
            return ListRelationshipsPublisher.this.client.listRelationships((ListRelationshipsRequest)((Object)ListRelationshipsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

