/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralchannel.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProgramManagementAccountResponse extends PartnerCentralChannelResponse implements
        ToCopyableBuilder<UpdateProgramManagementAccountResponse.Builder, UpdateProgramManagementAccountResponse> {
    private static final SdkField<UpdateProgramManagementAccountDetail> PROGRAM_MANAGEMENT_ACCOUNT_DETAIL_FIELD = SdkField
            .<UpdateProgramManagementAccountDetail> builder(MarshallingType.SDK_POJO)
            .memberName("programManagementAccountDetail")
            .getter(getter(UpdateProgramManagementAccountResponse::programManagementAccountDetail))
            .setter(setter(Builder::programManagementAccountDetail))
            .constructor(UpdateProgramManagementAccountDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programManagementAccountDetail")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PROGRAM_MANAGEMENT_ACCOUNT_DETAIL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final UpdateProgramManagementAccountDetail programManagementAccountDetail;

    private UpdateProgramManagementAccountResponse(BuilderImpl builder) {
        super(builder);
        this.programManagementAccountDetail = builder.programManagementAccountDetail;
    }

    /**
     * <p>
     * Details of the updated program management account.
     * </p>
     * 
     * @return Details of the updated program management account.
     */
    public final UpdateProgramManagementAccountDetail programManagementAccountDetail() {
        return programManagementAccountDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(programManagementAccountDetail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProgramManagementAccountResponse)) {
            return false;
        }
        UpdateProgramManagementAccountResponse other = (UpdateProgramManagementAccountResponse) obj;
        return Objects.equals(programManagementAccountDetail(), other.programManagementAccountDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProgramManagementAccountResponse")
                .add("ProgramManagementAccountDetail", programManagementAccountDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "programManagementAccountDetail":
            return Optional.ofNullable(clazz.cast(programManagementAccountDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("programManagementAccountDetail", PROGRAM_MANAGEMENT_ACCOUNT_DETAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProgramManagementAccountResponse, T> g) {
        return obj -> g.apply((UpdateProgramManagementAccountResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PartnerCentralChannelResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateProgramManagementAccountResponse> {
        /**
         * <p>
         * Details of the updated program management account.
         * </p>
         * 
         * @param programManagementAccountDetail
         *        Details of the updated program management account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programManagementAccountDetail(UpdateProgramManagementAccountDetail programManagementAccountDetail);

        /**
         * <p>
         * Details of the updated program management account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdateProgramManagementAccountDetail.Builder} avoiding the need to create one manually via
         * {@link UpdateProgramManagementAccountDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateProgramManagementAccountDetail.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #programManagementAccountDetail(UpdateProgramManagementAccountDetail)}.
         * 
         * @param programManagementAccountDetail
         *        a consumer that will call methods on {@link UpdateProgramManagementAccountDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #programManagementAccountDetail(UpdateProgramManagementAccountDetail)
         */
        default Builder programManagementAccountDetail(
                Consumer<UpdateProgramManagementAccountDetail.Builder> programManagementAccountDetail) {
            return programManagementAccountDetail(UpdateProgramManagementAccountDetail.builder()
                    .applyMutation(programManagementAccountDetail).build());
        }
    }

    static final class BuilderImpl extends PartnerCentralChannelResponse.BuilderImpl implements Builder {
        private UpdateProgramManagementAccountDetail programManagementAccountDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProgramManagementAccountResponse model) {
            super(model);
            programManagementAccountDetail(model.programManagementAccountDetail);
        }

        public final UpdateProgramManagementAccountDetail.Builder getProgramManagementAccountDetail() {
            return programManagementAccountDetail != null ? programManagementAccountDetail.toBuilder() : null;
        }

        public final void setProgramManagementAccountDetail(
                UpdateProgramManagementAccountDetail.BuilderImpl programManagementAccountDetail) {
            this.programManagementAccountDetail = programManagementAccountDetail != null ? programManagementAccountDetail.build()
                    : null;
        }

        @Override
        public final Builder programManagementAccountDetail(UpdateProgramManagementAccountDetail programManagementAccountDetail) {
            this.programManagementAccountDetail = programManagementAccountDetail;
            return this;
        }

        @Override
        public UpdateProgramManagementAccountResponse build() {
            return new UpdateProgramManagementAccountResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
