/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralchannel.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Payload for start service period handshake requests.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartServicePeriodPayload implements SdkPojo, Serializable,
        ToCopyableBuilder<StartServicePeriodPayload.Builder, StartServicePeriodPayload> {
    private static final SdkField<String> PROGRAM_MANAGEMENT_ACCOUNT_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("programManagementAccountIdentifier")
            .getter(getter(StartServicePeriodPayload::programManagementAccountIdentifier))
            .setter(setter(Builder::programManagementAccountIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programManagementAccountIdentifier")
                    .build()).build();

    private static final SdkField<String> NOTE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("note")
            .getter(getter(StartServicePeriodPayload::note)).setter(setter(Builder::note))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("note").build()).build();

    private static final SdkField<String> SERVICE_PERIOD_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("servicePeriodType").getter(getter(StartServicePeriodPayload::servicePeriodTypeAsString))
            .setter(setter(Builder::servicePeriodType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("servicePeriodType").build()).build();

    private static final SdkField<String> MINIMUM_NOTICE_DAYS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("minimumNoticeDays").getter(getter(StartServicePeriodPayload::minimumNoticeDays))
            .setter(setter(Builder::minimumNoticeDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumNoticeDays").build()).build();

    private static final SdkField<Instant> END_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endDate")
            .getter(getter(StartServicePeriodPayload::endDate))
            .setter(setter(Builder::endDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PROGRAM_MANAGEMENT_ACCOUNT_IDENTIFIER_FIELD, NOTE_FIELD, SERVICE_PERIOD_TYPE_FIELD, MINIMUM_NOTICE_DAYS_FIELD,
            END_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String programManagementAccountIdentifier;

    private final String note;

    private final String servicePeriodType;

    private final String minimumNoticeDays;

    private final Instant endDate;

    private StartServicePeriodPayload(BuilderImpl builder) {
        this.programManagementAccountIdentifier = builder.programManagementAccountIdentifier;
        this.note = builder.note;
        this.servicePeriodType = builder.servicePeriodType;
        this.minimumNoticeDays = builder.minimumNoticeDays;
        this.endDate = builder.endDate;
    }

    /**
     * <p>
     * The identifier of the program management account.
     * </p>
     * 
     * @return The identifier of the program management account.
     */
    public final String programManagementAccountIdentifier() {
        return programManagementAccountIdentifier;
    }

    /**
     * <p>
     * A note providing additional information about the service period.
     * </p>
     * 
     * @return A note providing additional information about the service period.
     */
    public final String note() {
        return note;
    }

    /**
     * <p>
     * The type of service period being started.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #servicePeriodType}
     * will return {@link ServicePeriodType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #servicePeriodTypeAsString}.
     * </p>
     * 
     * @return The type of service period being started.
     * @see ServicePeriodType
     */
    public final ServicePeriodType servicePeriodType() {
        return ServicePeriodType.fromValue(servicePeriodType);
    }

    /**
     * <p>
     * The type of service period being started.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #servicePeriodType}
     * will return {@link ServicePeriodType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #servicePeriodTypeAsString}.
     * </p>
     * 
     * @return The type of service period being started.
     * @see ServicePeriodType
     */
    public final String servicePeriodTypeAsString() {
        return servicePeriodType;
    }

    /**
     * <p>
     * The minimum number of days notice required for changes.
     * </p>
     * 
     * @return The minimum number of days notice required for changes.
     */
    public final String minimumNoticeDays() {
        return minimumNoticeDays;
    }

    /**
     * <p>
     * The end date of the service period.
     * </p>
     * 
     * @return The end date of the service period.
     */
    public final Instant endDate() {
        return endDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(programManagementAccountIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(note());
        hashCode = 31 * hashCode + Objects.hashCode(servicePeriodTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(minimumNoticeDays());
        hashCode = 31 * hashCode + Objects.hashCode(endDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartServicePeriodPayload)) {
            return false;
        }
        StartServicePeriodPayload other = (StartServicePeriodPayload) obj;
        return Objects.equals(programManagementAccountIdentifier(), other.programManagementAccountIdentifier())
                && Objects.equals(note(), other.note())
                && Objects.equals(servicePeriodTypeAsString(), other.servicePeriodTypeAsString())
                && Objects.equals(minimumNoticeDays(), other.minimumNoticeDays()) && Objects.equals(endDate(), other.endDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartServicePeriodPayload")
                .add("ProgramManagementAccountIdentifier", programManagementAccountIdentifier()).add("Note", note())
                .add("ServicePeriodType", servicePeriodTypeAsString()).add("MinimumNoticeDays", minimumNoticeDays())
                .add("EndDate", endDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "programManagementAccountIdentifier":
            return Optional.ofNullable(clazz.cast(programManagementAccountIdentifier()));
        case "note":
            return Optional.ofNullable(clazz.cast(note()));
        case "servicePeriodType":
            return Optional.ofNullable(clazz.cast(servicePeriodTypeAsString()));
        case "minimumNoticeDays":
            return Optional.ofNullable(clazz.cast(minimumNoticeDays()));
        case "endDate":
            return Optional.ofNullable(clazz.cast(endDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("programManagementAccountIdentifier", PROGRAM_MANAGEMENT_ACCOUNT_IDENTIFIER_FIELD);
        map.put("note", NOTE_FIELD);
        map.put("servicePeriodType", SERVICE_PERIOD_TYPE_FIELD);
        map.put("minimumNoticeDays", MINIMUM_NOTICE_DAYS_FIELD);
        map.put("endDate", END_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartServicePeriodPayload, T> g) {
        return obj -> g.apply((StartServicePeriodPayload) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StartServicePeriodPayload> {
        /**
         * <p>
         * The identifier of the program management account.
         * </p>
         * 
         * @param programManagementAccountIdentifier
         *        The identifier of the program management account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programManagementAccountIdentifier(String programManagementAccountIdentifier);

        /**
         * <p>
         * A note providing additional information about the service period.
         * </p>
         * 
         * @param note
         *        A note providing additional information about the service period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder note(String note);

        /**
         * <p>
         * The type of service period being started.
         * </p>
         * 
         * @param servicePeriodType
         *        The type of service period being started.
         * @see ServicePeriodType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServicePeriodType
         */
        Builder servicePeriodType(String servicePeriodType);

        /**
         * <p>
         * The type of service period being started.
         * </p>
         * 
         * @param servicePeriodType
         *        The type of service period being started.
         * @see ServicePeriodType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServicePeriodType
         */
        Builder servicePeriodType(ServicePeriodType servicePeriodType);

        /**
         * <p>
         * The minimum number of days notice required for changes.
         * </p>
         * 
         * @param minimumNoticeDays
         *        The minimum number of days notice required for changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumNoticeDays(String minimumNoticeDays);

        /**
         * <p>
         * The end date of the service period.
         * </p>
         * 
         * @param endDate
         *        The end date of the service period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDate(Instant endDate);
    }

    static final class BuilderImpl implements Builder {
        private String programManagementAccountIdentifier;

        private String note;

        private String servicePeriodType;

        private String minimumNoticeDays;

        private Instant endDate;

        private BuilderImpl() {
        }

        private BuilderImpl(StartServicePeriodPayload model) {
            programManagementAccountIdentifier(model.programManagementAccountIdentifier);
            note(model.note);
            servicePeriodType(model.servicePeriodType);
            minimumNoticeDays(model.minimumNoticeDays);
            endDate(model.endDate);
        }

        public final String getProgramManagementAccountIdentifier() {
            return programManagementAccountIdentifier;
        }

        public final void setProgramManagementAccountIdentifier(String programManagementAccountIdentifier) {
            this.programManagementAccountIdentifier = programManagementAccountIdentifier;
        }

        @Override
        public final Builder programManagementAccountIdentifier(String programManagementAccountIdentifier) {
            this.programManagementAccountIdentifier = programManagementAccountIdentifier;
            return this;
        }

        public final String getNote() {
            return note;
        }

        public final void setNote(String note) {
            this.note = note;
        }

        @Override
        public final Builder note(String note) {
            this.note = note;
            return this;
        }

        public final String getServicePeriodType() {
            return servicePeriodType;
        }

        public final void setServicePeriodType(String servicePeriodType) {
            this.servicePeriodType = servicePeriodType;
        }

        @Override
        public final Builder servicePeriodType(String servicePeriodType) {
            this.servicePeriodType = servicePeriodType;
            return this;
        }

        @Override
        public final Builder servicePeriodType(ServicePeriodType servicePeriodType) {
            this.servicePeriodType(servicePeriodType == null ? null : servicePeriodType.toString());
            return this;
        }

        public final String getMinimumNoticeDays() {
            return minimumNoticeDays;
        }

        public final void setMinimumNoticeDays(String minimumNoticeDays) {
            this.minimumNoticeDays = minimumNoticeDays;
        }

        @Override
        public final Builder minimumNoticeDays(String minimumNoticeDays) {
            this.minimumNoticeDays = minimumNoticeDays;
            return this;
        }

        public final Instant getEndDate() {
            return endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        @Override
        public StartServicePeriodPayload build() {
            return new StartServicePeriodPayload(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
